/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.wms;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.Logger;
import com.vividsolutions.wms.BoundingBox;
import com.vividsolutions.wms.Capabilities;
import com.vividsolutions.wms.IParser;
import com.vividsolutions.wms.MapLayer;
import com.vividsolutions.wms.MapStyle;
import com.vividsolutions.wms.WMSException;
import com.vividsolutions.wms.WMService;
import com.vividsolutions.wms.util.XMLTools;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.apache.xerces.parsers.DOMParser;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSSerializer;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class AbstractParser
implements IParser {
    @Override
    public Capabilities parseCapabilities(WMService service, InputStream inStream) throws IOException {
        Document doc;
        try {
            DOMParser parser = new DOMParser();
            parser.setFeature("http://xml.org/sax/features/validation", false);
            parser.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            parser.parse(new InputSource(inStream));
            doc = parser.getDocument();
            this.checkCapabilities(doc);
        }
        catch (SAXException saxe) {
            throw new IOException(saxe.toString());
        }
        return this.parseCapabilities(service, doc);
    }

    protected abstract String getRootPath();

    protected void checkCapabilities(Document doc) throws IOException {
        if (XMLTools.simpleXPath(doc, this.getRootPath()) == null) {
            String str = "";
            try {
                DOMImplementationRegistry registry = DOMImplementationRegistry.newInstance();
                DOMImplementationLS impl = (DOMImplementationLS)((Object)registry.getDOMImplementation("LS"));
                LSSerializer writer = impl.createLSSerializer();
                str = writer.writeToString(doc);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
            throw new WMSException("Missing root node <" + this.getRootPath() + "> : you probably use a wrong URL or a wrong version of WMS", str);
        }
    }

    protected abstract Capabilities parseCapabilities(WMService var1, Document var2) throws IOException;

    protected String getTitlePath() {
        return this.getRootPath() + "/Service/Title";
    }

    protected String getTitle(Document doc) throws IOException {
        String title = "";
        Node titleNode = XMLTools.simpleXPath(doc, this.getTitlePath());
        if (titleNode != null) {
            Node firstTitle = titleNode.getFirstChild();
            if (firstTitle != null) {
                title = ((CharacterData)firstTitle).getData();
            } else {
                Logger.warn("service <Title/> unset or empty.");
            }
        } else {
            Logger.warn("service <Title/> unset or empty.");
        }
        return title;
    }

    protected LinkedList<String> getFormatList(Document doc) throws IOException {
        LinkedList<String> formatList = new LinkedList<String>();
        Node formatNode = XMLTools.simpleXPath(doc, this.getRootPath() + "/Capability/Request/GetMap");
        if (formatNode != null) {
            NodeList nl = formatNode.getChildNodes();
            for (int i = 0; i < nl.getLength(); ++i) {
                String format;
                Node n = nl.item(i);
                if (n.getNodeType() != 1 || !"Format".equals(n.getNodeName()) || !(format = n.getFirstChild().getNodeValue()).matches("^image/(png|jpeg|gif).*")) continue;
                formatList.add(format);
            }
        } else {
            Logger.warn("Element '/Capability/Request/GetMap' not found");
        }
        return formatList;
    }

    protected LinkedList<String> getInfoFormats(Document doc) {
        Node infoFormatNode = XMLTools.simpleXPath(doc, "WMT_MS_Capabilities/Capability/Request/GetFeatureInfo");
        LinkedList<String> infoFormatList = new LinkedList<String>();
        if (infoFormatNode != null) {
            NodeList nl = infoFormatNode.getChildNodes();
            for (int i = 0; i < nl.getLength(); ++i) {
                Node n = nl.item(i);
                if (n.getNodeType() != 1 || !"Format".equals(n.getNodeName())) continue;
                infoFormatList.add(n.getFirstChild().getNodeValue());
            }
        }
        return infoFormatList;
    }

    public MapLayer wmsLayerFromNode(Node layerNode) {
        String name = null;
        String title = null;
        LinkedList<String> srsList = new LinkedList<String>();
        LinkedList<MapLayer> subLayers = new LinkedList<MapLayer>();
        BoundingBox geographicBBox = null;
        ArrayList<BoundingBox> boundingBoxList = new ArrayList<BoundingBox>();
        ArrayList<MapStyle> styles = new ArrayList<MapStyle>();
        boolean firstBoundingBox = true;
        NodeList nl = layerNode.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            try {
                if (n.getNodeType() != 1) continue;
                if (n.getNodeName().equals("Name")) {
                    name = ((CharacterData)n.getFirstChild()).getData();
                    continue;
                }
                if (n.getNodeName().equals("Title")) {
                    title = ((CharacterData)n.getFirstChild()).getData();
                    continue;
                }
                if (n.getNodeName().equals(this.getSRSName())) {
                    this.addSRSNode(n, srsList);
                    continue;
                }
                if (n.getNodeName().equals("LatLonBoundingBox")) {
                    geographicBBox = this.latLonBoundingBoxFromNode(n);
                    boundingBoxList.add(geographicBBox);
                    boundingBoxList.add(new BoundingBox("Geographics", geographicBBox.getEnvelope()));
                    continue;
                }
                if (n.getNodeName().equals("BoundingBox")) {
                    if (firstBoundingBox) {
                        boundingBoxList.add(0, this.boundingBoxFromNode(n));
                        firstBoundingBox = false;
                        continue;
                    }
                    boundingBoxList.add(this.boundingBoxFromNode(n));
                    continue;
                }
                if (n.getNodeName().equals("EX_GeographicBoundingBox")) {
                    geographicBBox = this.exGeographicBoundingBoxFromNode(n);
                    boundingBoxList.add(geographicBBox);
                    boundingBoxList.add(new BoundingBox("Geographics", geographicBBox.getEnvelope()));
                    continue;
                }
                if (n.getNodeName().equals("Layer")) {
                    subLayers.add(this.wmsLayerFromNode(n));
                    continue;
                }
                if (!n.getNodeName().equals("Style")) continue;
                String styleName = "";
                String titleName = "";
                String legendFormat = "";
                String url = "";
                int h = 0;
                int w = 0;
                NodeList nodeStyle = n.getChildNodes();
                for (int k = 0; k < nodeStyle.getLength(); ++k) {
                    Node n1 = nodeStyle.item(k);
                    if (n1.getNodeName().equals("Name")) {
                        styleName = ((CharacterData)n1.getFirstChild()).getData();
                        continue;
                    }
                    if (n1.getNodeName().equals("Title") & n1.hasChildNodes()) {
                        titleName = ((CharacterData)n1.getFirstChild()).getData();
                        continue;
                    }
                    if (!n1.getNodeName().equals("LegendURL")) continue;
                    try {
                        h = Integer.parseInt(n1.getAttributes().getNamedItem("height").getNodeValue());
                        w = Integer.parseInt(n1.getAttributes().getNamedItem("width").getNodeValue());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        throw new Exception(e.toString());
                    }
                    NodeList nodelegend = n1.getChildNodes();
                    for (int k1 = 0; k1 < nodelegend.getLength(); ++k1) {
                        Node n2 = nodelegend.item(k1);
                        if (n2.getNodeName().equals("Format")) {
                            legendFormat = ((CharacterData)n2.getFirstChild()).getData();
                            continue;
                        }
                        if (!n2.getNodeName().equals("OnlineResource")) continue;
                        url = n2.getAttributes().getNamedItem("xlink:href").getNodeValue();
                    }
                }
                styles.add(new MapStyle(styleName, titleName, url, legendFormat, w, h));
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                Logger.error("Exception caught in wmsLayerFromNode(): " + e.toString());
            }
        }
        if (title == null) {
            title = name + " (untitled)";
        }
        return new MapLayer(name, title, srsList, subLayers, geographicBBox, boundingBoxList, styles);
    }

    protected void addSRSNode(Node n, List<String> srsList) {
        String srsString = ((CharacterData)n.getFirstChild()).getData();
        String[] tokens = srsString.split("\\s+");
        srsList.addAll(Arrays.asList(tokens));
    }

    protected BoundingBox boundingBoxFromNode(Node n) throws Exception {
        try {
            NamedNodeMap nm = n.getAttributes();
            String srs = nm.getNamedItem(this.getSRSName()).getNodeValue();
            double minx = this.getCoord("minx", nm);
            double miny = this.getCoord("miny", nm);
            double maxx = this.getCoord("maxx", nm);
            double maxy = this.getCoord("maxy", nm);
            return new BoundingBox(srs, minx, miny, maxx, maxy);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception(I18N.getInstance().get("com.vividsolutions.wms.Parser.invalid-bounding-box-element-node") + ": " + e.toString());
        }
    }

    protected BoundingBox latLonBoundingBoxFromNode(Node n) throws Exception {
        try {
            NamedNodeMap nm = n.getAttributes();
            String srs = "EPSG:4326";
            double minx = this.getCoord("minx", nm);
            double miny = this.getCoord("miny", nm);
            double maxx = this.getCoord("maxx", nm);
            double maxy = this.getCoord("maxy", nm);
            return new BoundingBox(srs, minx, miny, maxx, maxy);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception(I18N.getInstance().get("com.vividsolutions.wms.Parser.invalid-bounding-box-element-node") + ": " + e.toString());
        }
    }

    public BoundingBox exGeographicBoundingBoxFromNode(Node n) throws Exception {
        try {
            String srs = "EPSG:4326";
            double minx = 0.0;
            double miny = 0.0;
            double maxx = 0.0;
            double maxy = 0.0;
            NodeList childNodes = n.getChildNodes();
            block14: for (int i = 0; i < childNodes.getLength(); ++i) {
                Node childNode = childNodes.item(i);
                if (childNode.getNodeType() != 1) continue;
                switch (childNode.getNodeName()) {
                    case "westBoundLongitude": {
                        minx = this.getCoord(childNode.getTextContent().trim());
                        continue block14;
                    }
                    case "eastBoundLongitude": {
                        maxx = this.getCoord(childNode.getTextContent().trim());
                        continue block14;
                    }
                    case "southBoundLatitude": {
                        miny = this.getCoord(childNode.getTextContent().trim());
                        continue block14;
                    }
                    case "northBoundLatitude": {
                        maxy = this.getCoord(childNode.getTextContent().trim());
                        continue block14;
                    }
                }
            }
            return new BoundingBox(srs, minx, miny, maxx, maxy);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception(I18N.getInstance().get("com.vividsolutions.wms.Parser.invalid-bounding-box-element-node") + ": " + e.toString());
        }
    }

    public double getCoord(String name, NamedNodeMap nm) throws Exception {
        return this.getCoord(nm.getNamedItem(name).getNodeValue());
    }

    public double getCoord(String text) throws Exception {
        if (text.equals("inf")) {
            return Double.POSITIVE_INFINITY;
        }
        return Double.parseDouble(text);
    }

    protected abstract String getSRSName();
}

