/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.warp;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.JUMPException;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.warp.AffineTransform;
import com.vividsolutions.jump.workbench.JUMPWorkbench;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.imagery.ReferencedImageStyle;
import com.vividsolutions.jump.workbench.model.Category;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.model.StandardCategoryNames;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import com.vividsolutions.jump.workbench.ui.warp.WarpingVectorLayerFinder;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.io.File;
import java.util.Random;
import javax.imageio.ImageIO;
import javax.media.jai.InterpolationNearest;
import javax.media.jai.JAI;
import javax.media.jai.PerspectiveTransform;
import javax.media.jai.RenderedOp;
import javax.media.jai.WarpPerspective;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.util.AssertionFailedException;
import org.openjump.core.apitools.LayerTools;
import org.openjump.core.rasterimage.RasterImageIOUtils;
import org.openjump.core.rasterimage.RasterImageLayer;
import org.openjump.core.rasterimage.WorldFileHandler;

public class AffineTransformPlugIn
extends AbstractPlugIn {
    public static String path;

    public static EnableCheck getEnableCheck(EnableCheckFactory enableCheckFactory) {
        return new MultiEnableCheck().add(enableCheckFactory.createAtLeastNLayerablesMustExistCheck(1)).add(enableCheckFactory.createBetweenNAndMVectorsMustBeDrawnCheck(1, 3));
    }

    @Override
    public String getName() {
        return I18N.getInstance().get("com.vividsolutions.jump.workbench.ui.warp.AffineTransformPlugIn");
    }

    @Override
    public void initialize(PlugInContext context) throws Exception {
        super.initialize(context);
        context.getFeatureInstaller().addMainMenuPlugin(this, new String[]{MenuNames.TOOLS, MenuNames.TOOLS_WARP}, this.getName(), false, null, AffineTransformPlugIn.getEnableCheck(context.getCheckFactory()));
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        this.reportNothingToUndoYet(context);
        Layerable layer = LayerTools.getSelectedLayerable(context, Layerable.class);
        if (layer instanceof RasterImageLayer) {
            AffineTransformPlugIn.affineTransformRaster(context);
        } else if (layer instanceof Layer && ((Layer)layer).getStyle(ReferencedImageStyle.class) == null) {
            AffineTransformPlugIn.affineTransformVector(context);
        } else {
            if (layer instanceof Layer && ((Layer)layer).getStyle(ReferencedImageStyle.class) != null) {
                JOptionPane.showMessageDialog(null, I18N.getInstance().get("com.vividsolutions.jump.workbench.ui.warp.AffineTransformPlugIn.message1"), null, 1);
                return false;
            }
            JOptionPane.showMessageDialog(null, I18N.getInstance().get("com.vividsolutions.jump.workbench.ui.warp.AffineTransformPlugIn.message2"), null, 1);
            return false;
        }
        return true;
    }

    public static void affineTransformVector(PlugInContext context) throws JUMPException {
        AffineTransform transform = AffineTransformPlugIn.affineTransform(context);
        FeatureCollection featureCollection = transform.transform(context.getSelectedLayer(0).getFeatureCollectionWrapper());
        context.getLayerManager().addLayer(StandardCategoryNames.WORKING, I18N.getInstance().get("ui.warp.AffineTransformPlugIn.affined") + " " + context.getSelectedLayer(0).getName(), featureCollection);
        AffineTransformPlugIn.checkValid(featureCollection, context);
    }

    public static void affineTransformRaster(PlugInContext context) throws Exception {
        RasterImageLayer rLayer = (RasterImageLayer)LayerTools.getSelectedLayerable(context, RasterImageLayer.class);
        BufferedImage inImageBuffer = rLayer.getImage();
        if (rLayer.getNumBands() == 1) {
            JOptionPane.showMessageDialog(null, I18N.getInstance().get("com.vividsolutions.jump.workbench.ui.warp.AffineTransformPlugIn.message3"), null, 1);
            return;
        }
        Random rnd = new Random();
        int n = 1000 + rnd.nextInt(9000);
        String random = Integer.toString(n);
        String part = I18N.getInstance().get("ui.warp.AffineTransformPlugIn.affined") + " ";
        String fileName = part + rLayer.getName() + "_" + random + ".tif";
        File outFile = new File(System.getProperty("java.io.tmpdir").concat(File.separator).concat(fileName));
        AffineTransform transform = AffineTransformPlugIn.affineTransform(context);
        Envelope inEnvelope = rLayer.getWholeImageEnvelope();
        Geometry inGeometry = rLayer.getWholeImageEnvelopeAsGeometry();
        Point P0 = new GeometryFactory().createPoint(new Coordinate(inEnvelope.getMinX(), inEnvelope.getMinY()));
        Point P1 = new GeometryFactory().createPoint(new Coordinate(inEnvelope.getMaxX(), inEnvelope.getMinY()));
        Point P2 = new GeometryFactory().createPoint(new Coordinate(inEnvelope.getMaxX(), inEnvelope.getMaxY()));
        Point P3 = new GeometryFactory().createPoint(new Coordinate(inEnvelope.getMinX(), inEnvelope.getMaxY()));
        Geometry P0_ = transform.transform((Geometry)P0);
        Geometry P1_ = transform.transform((Geometry)P1);
        Geometry P2_ = transform.transform((Geometry)P2);
        Geometry P3_ = transform.transform((Geometry)P3);
        WarpPerspective warp = new WarpPerspective(PerspectiveTransform.getQuadToQuad((double)P0.getCoordinate().x, (double)P0.getCoordinate().y, (double)P1.getCoordinate().x, (double)P1.getCoordinate().y, (double)P2.getCoordinate().x, (double)P2.getCoordinate().y, (double)P3.getCoordinate().x, (double)P3.getCoordinate().y, (double)P0_.getCoordinate().x, (double)P0_.getCoordinate().y, (double)P1_.getCoordinate().x, (double)P1_.getCoordinate().y, (double)P2_.getCoordinate().x, (double)P2_.getCoordinate().y, (double)P3_.getCoordinate().x, (double)P3_.getCoordinate().y));
        ParameterBlock pb = new ParameterBlock();
        pb.addSource(inImageBuffer);
        pb.add(warp);
        pb.add(new InterpolationNearest());
        RenderedOp outputOp = JAI.create((String)"warp", (ParameterBlock)pb);
        BufferedImage outImageBuffer = outputOp.getAsBufferedImage();
        Geometry outGeometry = transform.transform(inGeometry);
        Envelope outEnvelope = outGeometry.getEnvelope().getEnvelopeInternal();
        rLayer.setVisible(false);
        RasterImageIOUtils.saveImage(outFile, "tif", outImageBuffer, outEnvelope);
        String catName = StandardCategoryNames.WORKING;
        try {
            catName = ((Category)context.getLayerNamePanel().getSelectedCategories().toArray()[0]).getName();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        RasterImageIOUtils.loadTIF(outFile, context, catName);
    }

    public static void checkValid(FeatureCollection featureCollection, PlugInContext context) {
        for (Feature feature : featureCollection) {
            if (feature.getGeometry().isValid()) continue;
            context.getLayerViewPanel().getContext().warnUser(I18N.getInstance().get("ui.warp.AffineTransformPlugIn.some-geometries-are-not-valid"));
            return;
        }
    }

    public static void saveTIF(File file, Envelope envelope, BufferedImage planarimage) throws Exception {
        ImageIO.write((RenderedImage)planarimage, "tif", file);
        WorldFileHandler worldFileHandler = new WorldFileHandler(file.getAbsolutePath(), false);
        worldFileHandler.writeWorldFile(envelope, planarimage.getWidth(), planarimage.getHeight());
    }

    private static Coordinate vectorCoordinate(int n, boolean tip, PlugInContext context, WarpingVectorLayerFinder vectorLayerManager) {
        LineString vector = (LineString)vectorLayerManager.getVectors().get(n);
        return tip ? vector.getCoordinateN(1) : vector.getCoordinateN(0);
    }

    private static AffineTransform affineTransform(PlugInContext context) {
        WarpingVectorLayerFinder vlm = new WarpingVectorLayerFinder(context);
        switch (vlm.getVectors().size()) {
            case 1: {
                return new AffineTransform(AffineTransformPlugIn.vectorCoordinate(0, false, context, vlm), AffineTransformPlugIn.vectorCoordinate(0, true, context, vlm));
            }
            case 2: {
                return new AffineTransform(AffineTransformPlugIn.vectorCoordinate(0, false, context, vlm), AffineTransformPlugIn.vectorCoordinate(0, true, context, vlm), AffineTransformPlugIn.vectorCoordinate(1, false, context, vlm), AffineTransformPlugIn.vectorCoordinate(1, true, context, vlm));
            }
            case 3: {
                return new AffineTransform(AffineTransformPlugIn.vectorCoordinate(0, false, context, vlm), AffineTransformPlugIn.vectorCoordinate(0, true, context, vlm), AffineTransformPlugIn.vectorCoordinate(1, false, context, vlm), AffineTransformPlugIn.vectorCoordinate(1, true, context, vlm), AffineTransformPlugIn.vectorCoordinate(2, false, context, vlm), AffineTransformPlugIn.vectorCoordinate(2, true, context, vlm));
            }
        }
        JOptionPane.showMessageDialog(null, "You should draw between 1 to 3 vectors to apply an affine transformation of the image", "Info", 1);
        return null;
    }

    public static void warning(String paramString) {
        throw new AssertionFailedException(paramString != null ? paramString : "");
    }

    public Icon createEnableCheck(WorkbenchContext workbenchContext) {
        return null;
    }

    private static Coordinate vectorCoordinatePublic(int n, boolean tip, WarpingVectorLayerFinder vectorLayerManager) {
        LineString vector = (LineString)vectorLayerManager.getVectors().get(n);
        return tip ? vector.getCoordinateN(1) : vector.getCoordinateN(0);
    }

    public static AffineTransform getTransform() {
        WarpingVectorLayerFinder vlm = new WarpingVectorLayerFinder(JUMPWorkbench.getInstance().getContext());
        switch (vlm.getVectors().size()) {
            case 1: {
                return new AffineTransform(AffineTransformPlugIn.vectorCoordinatePublic(0, false, vlm), AffineTransformPlugIn.vectorCoordinatePublic(0, true, vlm));
            }
            case 2: {
                return new AffineTransform(AffineTransformPlugIn.vectorCoordinatePublic(0, false, vlm), AffineTransformPlugIn.vectorCoordinatePublic(0, true, vlm), AffineTransformPlugIn.vectorCoordinatePublic(1, false, vlm), AffineTransformPlugIn.vectorCoordinatePublic(1, true, vlm));
            }
            case 3: {
                return new AffineTransform(AffineTransformPlugIn.vectorCoordinatePublic(0, false, vlm), AffineTransformPlugIn.vectorCoordinatePublic(0, true, vlm), AffineTransformPlugIn.vectorCoordinatePublic(1, false, vlm), AffineTransformPlugIn.vectorCoordinatePublic(1, true, vlm), AffineTransformPlugIn.vectorCoordinatePublic(2, false, vlm), AffineTransformPlugIn.vectorCoordinatePublic(2, true, vlm));
            }
        }
        JUMPWorkbench.getInstance().getFrame().getContext().getLayerViewPanel().getContext().warnUser(I18N.getInstance().get("ui.warp.WarpingPanel.warning_1"));
        return null;
    }
}

