/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.style;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.imagery.ReferencedImageStyle;
import com.vividsolutions.jump.workbench.imagery.ReferencedImagesLayer;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import com.vividsolutions.jump.workbench.ui.renderer.style.ColorThemingStyle;
import com.vividsolutions.jump.workbench.ui.renderer.style.LabelStyle;
import com.vividsolutions.jump.workbench.ui.renderer.style.Style;
import com.vividsolutions.jump.workbench.ui.style.CopyStylesPlugIn;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import org.openjump.core.ccordsys.srid.SRIDStyle;

public class PasteStylesPlugIn
extends AbstractPlugIn {
    public static MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerNamePanelMustBeActiveCheck()).add(checkFactory.createAtLeastNLayersMustBeSelectedCheck(1));
    }

    @Override
    public String getName() {
        return I18N.getInstance().get("ui.style.PasteStylesPlugIn.paste-styles");
    }

    @Override
    public ImageIcon getIcon() {
        return GUIUtil.toSmallIcon(IconLoader.icon("Palette_paste.png"));
    }

    @Override
    public void initialize(PlugInContext context) throws Exception {
        super.initialize(context);
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        if (CopyStylesPlugIn.stylesBuffer == null) {
            return false;
        }
        Layer[] selectedLayers = context.getSelectedLayers();
        for (int i = 0; i < selectedLayers.length; ++i) {
            this.pasteStyles(selectedLayers[i]);
        }
        return true;
    }

    private void pasteStyles(Layer layer) throws Exception {
        layer.setScaleDependentRenderingEnabled(CopyStylesPlugIn.isScaleDependentRenderingEnabled);
        layer.setMaxScale(CopyStylesPlugIn.maxScale);
        layer.setMinScale(CopyStylesPlugIn.minScale);
        if (CopyStylesPlugIn.stylesBuffer.size() > 0) {
            ArrayList<Style> styles = new ArrayList<Style>();
            for (Style style : CopyStylesPlugIn.stylesBuffer) {
                if (style instanceof ReferencedImageStyle && !(layer instanceof ReferencedImagesLayer) || style instanceof SRIDStyle) continue;
                styles.add(style);
            }
            if (!(styles.get(0) instanceof ReferencedImageStyle) && layer instanceof ReferencedImagesLayer) {
                styles.add(0, layer.getStyles(ReferencedImageStyle.class).get(0));
            }
            this.validateStyleForLayer(layer);
            layer.setStyles(styles);
        }
    }

    private void validateStyleForLayer(Layer layer) throws IllegalArgumentException {
        if (layer instanceof ReferencedImagesLayer) {
            return;
        }
        String attribName2 = "";
        try {
            FeatureSchema featureSchema = layer.getFeatureCollectionWrapper().getFeatureSchema();
            ArrayList<String> attribList = new ArrayList<String>();
            for (Style style : CopyStylesPlugIn.stylesBuffer) {
                ColorThemingStyle ctStyle;
                if (style instanceof LabelStyle) {
                    LabelStyle labelStyle = (LabelStyle)style;
                    if (!labelStyle.isEnabled()) continue;
                    attribName2 = labelStyle.getAttribute();
                    if (!attribName2.equals("")) {
                        attribList.add(attribName2);
                    }
                    if (!(attribName2 = labelStyle.getAngleAttribute()).equals("")) {
                        attribList.add(attribName2);
                    }
                    if ((attribName2 = labelStyle.getHeightAttribute()).equals("")) continue;
                    attribList.add(attribName2);
                    continue;
                }
                if (!(style instanceof ColorThemingStyle) || !(ctStyle = (ColorThemingStyle)style).isEnabled() || (attribName2 = ctStyle.getAttributeName()) == "") continue;
                attribList.add(attribName2);
            }
            for (String attribName2 : attribList) {
                if (attribName2.equals("$FID")) continue;
                featureSchema.getAttributeIndex(attribName2);
            }
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalArgumentException("Attribute " + attribName2 + " not found on Layer: " + layer.getName());
        }
    }
}

