/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.renderer.style;

import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.Viewport;
import com.vividsolutions.jump.workbench.ui.renderer.style.BasicStyle;
import com.vividsolutions.jump.workbench.ui.renderer.style.Style;
import de.latlon.deejump.plugin.style.BitmapVertexStyle;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.awt.geom.RectangularShape;
import org.locationtech.jts.geom.Coordinate;
import org.openjump.util.SLDImporter;

public abstract class VertexStyle
implements Style,
SLDImporter.SizedStrokeFillStyle {
    protected Shape shape;
    protected int size = 4;
    private Color fillColor;
    private int alpha;
    private boolean enabled = false;
    private boolean filling = true;
    private Color strokeColor;
    private BasicStroke stroke = new BasicStroke(1.0f);

    protected VertexStyle() {
    }

    protected VertexStyle(Shape shape) {
        this.shape = shape;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setSize(int size) {
        this.size = size;
    }

    public int getSize() {
        return this.size;
    }

    public Shape getShape() {
        return this.shape;
    }

    public Color getFillColor() {
        return this.fillColor;
    }

    @Override
    public void setFillColor(Color c) {
        this.fillColor = GUIUtil.alphaColor(c, this.alpha);
    }

    @Override
    public void setLineColor(Color c) {
        this.strokeColor = GUIUtil.alphaColor(c, this.alpha);
    }

    public Color getLineColor() {
        return this.strokeColor;
    }

    @Override
    public BasicStyle setRenderingLinePattern(boolean b) {
        return null;
    }

    @Override
    public BasicStyle setLinePattern(String s) {
        return null;
    }

    @Override
    public void setAlpha(int a) {
        if (this.fillColor != null) {
            this.fillColor = GUIUtil.alphaColor(this.fillColor, a);
        }
        if (this.strokeColor != null) {
            this.strokeColor = GUIUtil.alphaColor(this.strokeColor, a);
        }
        this.alpha = a;
    }

    @Override
    public void setLineWidth(int w) {
    }

    @Override
    public void initialize(Layer layer) {
        this.fillColor = GUIUtil.alphaColor(layer.getBasicStyle().getFillColor(), layer.getBasicStyle().getAlpha());
        this.strokeColor = GUIUtil.alphaColor(layer.getBasicStyle().getLineColor(), layer.getBasicStyle().getAlpha());
    }

    @Override
    public void paint(Feature f, Graphics2D g, Viewport viewport) throws Exception {
        Coordinate[] coordinates = f.getGeometry().getCoordinates();
        g.setColor(this.fillColor);
        g.setStroke(this.stroke);
        for (Coordinate c : coordinates) {
            if (!viewport.getEnvelopeInModelCoordinates().contains(c)) continue;
            this.paint(g, viewport.toViewPoint(new Point2D.Double(c.x, c.y)));
        }
    }

    public void paint(Graphics2D g, Point2D p) {
        this.setFrame(p);
        this.render(g);
    }

    private void setFrame(Point2D p) {
        ((RectangularShape)this.shape).setFrame(p.getX() - (double)this.getSize() / 2.0, p.getY() - (double)this.getSize() / 2.0, this.getSize(), this.getSize());
    }

    public void setFilling(boolean filling) {
        this.filling = filling;
    }

    public boolean getFilling() {
        return this.filling;
    }

    protected void render(Graphics2D g) {
        if (this.filling) {
            g.setColor(this.fillColor);
            g.fill(this.shape);
        }
        g.setColor(this.strokeColor);
        g.draw(this.shape);
    }

    @Override
    public Object clone() {
        VertexStyle vStyle = null;
        try {
            vStyle = (VertexStyle)this.getClass().newInstance();
            if (vStyle instanceof BitmapVertexStyle) {
                ((BitmapVertexStyle)vStyle).setFileName(((BitmapVertexStyle)this).getFileName());
            } else {
                vStyle.setFillColor(this.getFillColor());
                vStyle.setLineColor(this.getLineColor());
                vStyle.setFilling(this.getFilling());
            }
            vStyle.setSize(this.size);
            vStyle.setEnabled(this.isEnabled());
            vStyle.setAlpha(this.alpha);
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return vStyle;
    }
}

