/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.renderer.style;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.ui.Viewport;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import com.vividsolutions.jump.workbench.ui.renderer.style.LineStringSegmentStyle;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.font.TextLayout;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import org.locationtech.jts.geom.Coordinate;

public class MetricsLineStringSegmentStyle
extends LineStringSegmentStyle {
    public static final int FONT_BASE_SIZE = 10;
    private Font font = new Font("Dialog", 0, 10);

    public MetricsLineStringSegmentStyle(String name, String iconFile) {
        super(name, IconLoader.icon(iconFile));
    }

    @Override
    protected void paint(Coordinate p0, Coordinate p1, Viewport viewport, Graphics2D graphics) throws Exception {
        String lenStr = Double.toString(p0.distance(p1));
        double ang = Math.toDegrees(Math.atan2(p1.y - p0.y, p1.x - p0.x));
        String angStr = Double.toString(ang);
        String text = lenStr + " / " + angStr;
        this.paint(text, viewport.toViewPoint(new Point2D.Double(p0.x, p0.y)), viewport.toViewPoint(new Point2D.Double(p1.x, p1.y)), viewport, graphics);
    }

    private void paint(String text, Point2D p0, Point2D p1, Viewport viewport, Graphics2D g) throws NoninvertibleTransformException {
        if (p0.equals(p1)) {
            return;
        }
        Point2D.Float mid = new Point2D.Float((float)((p0.getX() + p1.getX()) / 2.0), (float)((p0.getY() + p1.getY()) / 2.0));
        g.setColor(Color.BLACK);
        g.setStroke(this.stroke);
        TextLayout layout = new TextLayout(text, this.font, g.getFontRenderContext());
        layout.draw(g, (float)((Point2D)mid).getX(), (float)((Point2D)mid).getY());
    }

    @Override
    protected void paint(Point2D p0, Point2D p1, Viewport viewport, Graphics2D g) throws NoninvertibleTransformException {
        throw new UnsupportedOperationException("This method should never be called");
    }

    public static class LengthAngle
    extends MetricsLineStringSegmentStyle {
        public LengthAngle() {
            super(I18N.getInstance().get("ui.renderer.style.MetricsLineStringSegmentStyle.Segment-Metrics"), "LengthAngleDecorator.gif");
        }
    }
}

