/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.renderer.style;

import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.util.LangUtil;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.ui.Viewport;
import com.vividsolutions.jump.workbench.ui.renderer.style.AlphaSetting;
import com.vividsolutions.jump.workbench.ui.renderer.style.BasicStyle;
import com.vividsolutions.jump.workbench.ui.renderer.style.SquareVertexStyle;
import com.vividsolutions.jump.workbench.ui.renderer.style.Style;
import com.vividsolutions.jump.workbench.ui.renderer.style.XBasicStyle;
import java.awt.Color;
import java.awt.Graphics2D;
import java.util.HashMap;
import java.util.Map;
import org.locationtech.jts.util.Assert;

public class ColorThemingStyle
implements Style,
AlphaSetting {
    private BasicStyle defaultStyle;
    private boolean globalTransparencyEnabled = true;
    private boolean globalLineWidthEnabled = true;
    private boolean vertexStyleEnabled;
    private Layer layer;
    private Map<Object, BasicStyle> attributeValueToBasicStyleMap = new HashMap<Object, BasicStyle>();
    private Map<Object, String> attributeValueToLabelMap;
    private String attributeName;
    private boolean enabled = false;

    public ColorThemingStyle() {
    }

    @Override
    public void setAlpha(int alpha) {
        if (this.isGlobalTransparencyEnabled()) {
            this.defaultStyle.setAlpha(alpha);
            for (BasicStyle style : this.attributeValueToBasicStyleMap.values()) {
                style.setAlpha(alpha);
            }
        }
    }

    public void setLineWidth(int lineWidth) {
        if (this.isGlobalLineWidthEnabled()) {
            this.defaultStyle.setLineWidth(lineWidth);
            for (BasicStyle style : this.attributeValueToBasicStyleMap.values()) {
                style.setLineWidth(lineWidth);
            }
        }
    }

    public ColorThemingStyle(String attributeName, Map<Object, BasicStyle> attributeValueToBasicStyleMap, BasicStyle defaultStyle) {
        this(attributeName, attributeValueToBasicStyleMap, ColorThemingStyle.attributeValueToLabelMap(attributeValueToBasicStyleMap), defaultStyle);
    }

    public ColorThemingStyle(String attributeName, Map<Object, BasicStyle> attributeValueToBasicStyleMap, Map<Object, String> attributeValueToLabelMap, BasicStyle defaultStyle) {
        this.setAttributeName(attributeName);
        this.setAttributeValueToBasicStyleMap(attributeValueToBasicStyleMap);
        this.setAttributeValueToLabelMap(attributeValueToLabelMap);
        this.setDefaultStyle(defaultStyle);
    }

    private static Map<Object, String> attributeValueToLabelMap(Map<Object, BasicStyle> attributeValueToBasicStyleMap) {
        Map attributeValueToLabelMap = (Map)LangUtil.newInstance(attributeValueToBasicStyleMap.getClass());
        for (Object value : attributeValueToBasicStyleMap.keySet()) {
            attributeValueToLabelMap.put(value, value.toString());
        }
        return attributeValueToLabelMap;
    }

    @Override
    public void paint(Feature f, Graphics2D g, Viewport viewport) throws Exception {
        this.getStyle(f).paint(f, g, viewport);
    }

    private BasicStyle getStyle(Feature feature) {
        BasicStyle style = null;
        try {
            style = this.attributeName != null && feature.getSchema().hasAttribute(this.attributeName) && feature.getAttribute(this.attributeName) != null ? this.attributeValueToBasicStyleMap.get(ColorThemingStyle.trimIfString(feature.getAttribute(this.attributeName))) : this.defaultStyle;
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return style == null ? this.defaultStyle : style;
    }

    public static Object trimIfString(Object object) {
        return object instanceof String ? ((String)object).trim() : object;
    }

    @Override
    public Object clone() {
        try {
            ColorThemingStyle clone = (ColorThemingStyle)super.clone();
            clone.attributeValueToBasicStyleMap = (Map)this.attributeValueToBasicStyleMap.getClass().newInstance();
            for (Object attribute : this.attributeValueToBasicStyleMap.keySet()) {
                clone.attributeValueToBasicStyleMap.put(attribute, (BasicStyle)this.attributeValueToBasicStyleMap.get(attribute).clone());
            }
            clone.attributeValueToLabelMap = (Map)this.attributeValueToLabelMap.getClass().newInstance();
            clone.attributeValueToLabelMap.putAll(this.attributeValueToLabelMap);
            return clone;
        }
        catch (InstantiationException e) {
            Assert.shouldNeverReachHere();
            return null;
        }
        catch (IllegalAccessException e) {
            Assert.shouldNeverReachHere();
            return null;
        }
        catch (CloneNotSupportedException e) {
            Assert.shouldNeverReachHere();
            return null;
        }
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public void setAttributeValueToBasicStyleMap(Map<Object, BasicStyle> attributeValueToBasicStyleMap) {
        this.attributeValueToBasicStyleMap = attributeValueToBasicStyleMap;
    }

    public void setAttributeValueToLabelMap(Map<Object, String> attributeValueToLabelMap) {
        this.attributeValueToLabelMap = attributeValueToLabelMap;
    }

    public void setAttributeName(String attributeName) {
        this.attributeName = attributeName;
    }

    public Map<Object, BasicStyle> getAttributeValueToBasicStyleMap() {
        return this.attributeValueToBasicStyleMap;
    }

    public Map<Object, String> getAttributeValueToLabelMap() {
        return this.attributeValueToLabelMap;
    }

    @Override
    public void initialize(Layer layer) {
        this.layer = layer;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public static ColorThemingStyle get(Layer layer) {
        if (layer.getStyle(ColorThemingStyle.class) == null) {
            ColorThemingStyle colorThemingStyle = new ColorThemingStyle(ColorThemingStyle.pickNonSpatialAttributeName(layer.getFeatureCollectionWrapper().getFeatureSchema()), new HashMap<Object, BasicStyle>(), new XBasicStyle(new BasicStyle(Color.lightGray), new SquareVertexStyle()));
            layer.addStyle(colorThemingStyle);
        }
        return (ColorThemingStyle)layer.getStyle(ColorThemingStyle.class);
    }

    private static String pickNonSpatialAttributeName(FeatureSchema schema) {
        for (int i = 0; i < schema.getAttributeCount(); ++i) {
            if (schema.getGeometryIndex() == i) continue;
            return schema.getAttributeName(i);
        }
        return null;
    }

    public BasicStyle getDefaultStyle() {
        return this.defaultStyle;
    }

    public void setDefaultStyle(BasicStyle defaultStyle) {
        this.defaultStyle = defaultStyle;
    }

    public boolean isGlobalTransparencyEnabled() {
        return this.globalTransparencyEnabled;
    }

    public void setGlobalTransparencyEnabled(boolean globalTransparencyEnabled) {
        this.globalTransparencyEnabled = globalTransparencyEnabled;
    }

    public boolean isGlobalLineWidthEnabled() {
        return this.globalLineWidthEnabled;
    }

    public void setGlobalLineWidthEnabled(boolean globalLineWidthEnabled) {
        this.globalLineWidthEnabled = globalLineWidthEnabled;
    }

    public boolean isVertexStyleEnabled() {
        return this.vertexStyleEnabled;
    }

    public void setVertexStyleEnabled(boolean vertexStyleEnabled) {
        this.vertexStyleEnabled = vertexStyleEnabled;
    }

    @Override
    public int getAlpha() {
        return this.defaultStyle.getAlpha();
    }
}

