/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.renderer.java2D;

import com.vividsolutions.jump.workbench.ui.renderer.java2D.GeometryCollectionShape;
import com.vividsolutions.jump.workbench.ui.renderer.java2D.PolygonShape;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateList;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;

public class Java2DConverter {
    private static double POINT_MARKER_SIZE = 3.0;
    private final PointConverter pointConverter;
    private static final GeneralPath emptyPath = new GeneralPath();
    private double decimatorResolution = 0.5;

    public Java2DConverter(PointConverter pointConverter) {
        this.pointConverter = pointConverter;
    }

    public Java2DConverter(PointConverter pointConverter, double resolution) {
        this.pointConverter = pointConverter;
        this.decimatorResolution = resolution;
    }

    private Shape toShape(Polygon p) throws NoninvertibleTransformException {
        double modelResolution = this.decimatorResolution / this.pointConverter.getScale();
        Envelope viewEnvelopeInModelCoordinate = this.pointConverter.getEnvelopeInModelCoordinates();
        Envelope geomEnvelope = p.getEnvelopeInternal();
        if (geomEnvelope.getWidth() < modelResolution && geomEnvelope.getHeight() < modelResolution) {
            Coordinate c = p.getCoordinate();
            return this.toShape(p.getFactory().createLineString(new Coordinate[]{c, new Coordinate(c.x + modelResolution, c.y)}));
        }
        GeometryCollectionShape gcs = new GeometryCollectionShape();
        GeneralPath microholes = new GeneralPath();
        ArrayList<Coordinate[]> holeVertexCollection = new ArrayList<Coordinate[]>();
        for (int j = 0; j < p.getNumInteriorRing(); ++j) {
            LinearRing ring = p.getInteriorRingN(j);
            geomEnvelope = ring.getEnvelopeInternal();
            if (!geomEnvelope.intersects(viewEnvelopeInModelCoordinate) || geomEnvelope.getWidth() < modelResolution / 10.0 && geomEnvelope.getHeight() < modelResolution / 10.0) continue;
            if (geomEnvelope.getWidth() < modelResolution && geomEnvelope.getHeight() < modelResolution) {
                Coordinate c = ring.getCoordinate();
                microholes.append(new LineStringPath(ring.getFactory().createLineString(new Coordinate[]{c, new Coordinate(c.x + modelResolution, c.y)}), this), false);
                continue;
            }
            holeVertexCollection.add(this.toViewCoordinates(ring.getCoordinates()));
        }
        gcs.add(new PolygonShape(this.toViewCoordinates(p.getExteriorRing().getCoordinates()), holeVertexCollection));
        gcs.add(microholes);
        return gcs;
    }

    public Coordinate[] toViewCoordinates(Coordinate[] modelCoordinates) throws NoninvertibleTransformException {
        double modelResolution = this.decimatorResolution / this.pointConverter.getScale();
        CoordinateList viewCoordinates = new CoordinateList();
        Coordinate p0 = modelCoordinates[0];
        int mpts = modelCoordinates.length;
        for (int i = 0; i < mpts; ++i) {
            Coordinate pi = modelCoordinates[i];
            double xd = Math.abs(p0.x - pi.x);
            double yd = Math.abs(p0.y - pi.y);
            if (!(xd >= modelResolution) && !(yd >= modelResolution) && viewCoordinates.size() >= 4 && i != mpts - 1) continue;
            Point2D point2D = this.pointConverter.toViewPoint(pi);
            viewCoordinates.add((Object)new Coordinate(point2D.getX(), point2D.getY()));
            p0 = pi;
        }
        return viewCoordinates.toCoordinateArray();
    }

    private Shape toShape(GeometryCollection gc) throws NoninvertibleTransformException {
        double modelResolution = this.decimatorResolution / this.pointConverter.getScale();
        Envelope viewEnvelopeInModelCoordinate = this.pointConverter.getEnvelopeInModelCoordinates();
        GeometryCollectionShape shape = new GeometryCollectionShape();
        for (int i = 0; i < gc.getNumGeometries(); ++i) {
            Geometry g = gc.getGeometryN(i);
            Envelope geomEnvelope = g.getEnvelopeInternal();
            if (!geomEnvelope.intersects(viewEnvelopeInModelCoordinate)) continue;
            if (g.getDimension() > 0 && geomEnvelope.getWidth() < modelResolution && geomEnvelope.getHeight() < modelResolution) {
                Coordinate c = g.getCoordinate();
                shape.add(this.toShape(g.getFactory().createLineString(new Coordinate[]{c, new Coordinate(c.x + modelResolution, c.y)})));
            }
            shape.add(this.toShape(g));
        }
        return shape;
    }

    private GeneralPath toShape(LineString lineString) {
        GeometryFactory gf = lineString.getFactory();
        Coordinate[] cc = lineString.getCoordinates();
        GeneralPath shape = new GeneralPath(1, cc.length);
        CoordinateList list = new CoordinateList();
        Envelope viewEnvelopeInModelCoordinate = this.pointConverter.getEnvelopeInModelCoordinates();
        Coordinate previous = cc[0];
        boolean start = true;
        int max = cc.length;
        for (int i = 1; i < max; ++i) {
            LineStringPath pi;
            Coordinate current = cc[i];
            if (viewEnvelopeInModelCoordinate.intersects(new Envelope(previous, current))) {
                if (start) {
                    list.add((Object)previous);
                }
                list.add((Object)current);
                start = false;
            } else if (!list.isEmpty()) {
                pi = new LineStringPath(gf.createLineString(list.toCoordinateArray()), this);
                shape.append(pi, false);
                list.clear();
                start = true;
            }
            if (i == max - 1 && !list.isEmpty()) {
                pi = new LineStringPath(gf.createLineString(list.toCoordinateArray()), this);
                shape.append(pi, false);
            }
            previous = current;
        }
        return shape;
    }

    private Shape toShape(Point point) throws NoninvertibleTransformException {
        Rectangle2D.Double pointMarker = new Rectangle2D.Double(0.0, 0.0, POINT_MARKER_SIZE, POINT_MARKER_SIZE);
        Point2D viewPoint = this.toViewPoint(point.getCoordinate());
        pointMarker.x = viewPoint.getX() - POINT_MARKER_SIZE / 2.0;
        pointMarker.y = viewPoint.getY() - POINT_MARKER_SIZE / 2.0;
        return pointMarker;
    }

    private Point2D toViewPoint(Coordinate modelCoordinate) throws NoninvertibleTransformException {
        return this.pointConverter.toViewPoint(modelCoordinate);
    }

    public Shape toShape(Geometry geometry) throws NoninvertibleTransformException {
        if (geometry.isEmpty()) {
            return emptyPath;
        }
        Envelope viewInModelCoordinates = this.pointConverter.getEnvelopeInModelCoordinates();
        Envelope env = geometry.getEnvelopeInternal();
        if (!env.intersects(viewInModelCoordinates)) {
            return emptyPath;
        }
        double modelResolution = this.decimatorResolution / this.pointConverter.getScale();
        if (geometry.getDimension() > 0 && env.getWidth() < modelResolution && env.getHeight() < modelResolution) {
            Coordinate c = geometry.getCoordinate();
            return this.toShape(geometry.getFactory().createLineString(new Coordinate[]{c, new Coordinate(c.x + modelResolution, c.y)}));
        }
        if (geometry instanceof Polygon) {
            return this.toShape((Polygon)geometry);
        }
        if (geometry instanceof LineString) {
            return this.toShape((LineString)geometry);
        }
        if (geometry instanceof Point) {
            return this.toShape((Point)geometry);
        }
        if (geometry instanceof GeometryCollection) {
            return this.toShape((GeometryCollection)geometry);
        }
        throw new IllegalArgumentException("Unrecognized Geometry class: " + geometry.getClass());
    }

    public static interface PointConverter {
        public Point2D toViewPoint(Coordinate var1) throws NoninvertibleTransformException;

        public double getScale() throws NoninvertibleTransformException;

        public Envelope getEnvelopeInModelCoordinates();
    }

    static class LineStringPath
    implements PathIterator {
        private int iterate;
        private int numPoints;
        private Coordinate[] points;
        private boolean closed;

        public LineStringPath(LineString linestring, Java2DConverter j2D) {
            try {
                this.points = j2D.toViewCoordinates(linestring.getCoordinates());
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                // empty catch block
            }
            this.numPoints = this.points.length;
            this.iterate = 0;
            this.closed = this.numPoints > 1 && this.points[0].equals2D(this.points[this.numPoints - 1]);
        }

        private int getSegType() {
            if (this.closed && this.iterate == this.numPoints - 1) {
                return 4;
            }
            return this.iterate == 0 ? 0 : 1;
        }

        @Override
        public int currentSegment(double[] coords) {
            coords[0] = this.points[this.iterate].x;
            coords[1] = this.points[this.iterate].y;
            return this.getSegType();
        }

        @Override
        public int currentSegment(float[] coords) {
            coords[0] = (float)this.points[this.iterate].x;
            coords[1] = (float)this.points[this.iterate].y;
            return this.getSegType();
        }

        @Override
        public int getWindingRule() {
            return 1;
        }

        @Override
        public boolean isDone() {
            return this.iterate >= this.numPoints;
        }

        @Override
        public void next() {
            ++this.iterate;
        }
    }
}

