/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.renderer;

import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerView;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.Viewport;
import com.vividsolutions.jump.workbench.ui.renderer.FeatureCollectionRenderer;
import com.vividsolutions.jump.workbench.ui.renderer.style.Style;
import com.vividsolutions.jump.workbench.ui.renderer.style.StyleUtil;
import com.vividsolutions.jump.workbench.ui.renderer.style.VertexStyle;
import de.latlon.deejump.plugin.style.VertexStylesFactory;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.util.Assert;

public abstract class AbstractSelectionRenderer
extends FeatureCollectionRenderer
implements Style {
    public static final int HANDLE_WIDTH = 5;
    private boolean enabled = true;
    private Stroke handleStroke = new BasicStroke(1.0f);
    private Color handleFillColor;
    private Color handleLineColor = Color.black;
    private Stroke lineStroke = new BasicStroke(2.0f);
    private Color lineColor;
    private Stroke fillStroke = new BasicStroke(1.0f);
    private Color fillColor;
    private boolean filling = true;
    private int selectionPointSize = 5;
    private String selectionPointForm = "SQUARE";
    VertexStyle vertexStyle = null;
    protected LayerViewPanel panel;
    private Map<Feature, Collection<Geometry>> featureToSelectedItemsMap;
    private boolean paintingHandles;
    Rectangle2D.Double handle = new Rectangle2D.Double(0.0, 0.0, 5.0, 5.0);

    public AbstractSelectionRenderer(Object contentID, LayerViewPanel panel, Color color, boolean paintingHandles, boolean filling) {
        super(contentID, panel);
        this.panel = panel;
        this.handleFillColor = color;
        this.lineColor = color;
        this.fillColor = GUIUtil.alphaColor(Color.white, 75);
        this.paintingHandles = paintingHandles;
        this.filling = filling;
        this.vertexStyle = VertexStylesFactory.createVertexStyle(this.selectionPointForm);
        this.vertexStyle.setSize(this.selectionPointSize);
        this.vertexStyle.setAlpha(255);
        this.vertexStyle.setFillColor(this.handleFillColor);
        this.vertexStyle.setLineColor(this.handleLineColor);
    }

    public String getName() {
        throw new UnsupportedOperationException();
    }

    public Icon getIcon() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public Object clone() {
        Assert.shouldNeverReachHere();
        return null;
    }

    @Override
    public void initialize(Layer layer) {
    }

    @Override
    public void paint(Feature f, Graphics2D g, Viewport viewport) throws NoninvertibleTransformException {
        for (Geometry geometry : this.featureToSelectedItemsMap.get(f)) {
            this.paint(geometry, g, viewport);
        }
    }

    public void paint(Geometry geometry, Graphics2D g, Viewport viewport) throws NoninvertibleTransformException {
        if (!viewport.getEnvelopeInModelCoordinates().intersects(geometry.getEnvelopeInternal())) {
            return;
        }
        Coordinate[] modelCoordinates = geometry.getCoordinates();
        if (geometry.getDimension() > 0 || !this.paintingHandles) {
            StyleUtil.paint(geometry, g, viewport, this.filling, this.fillStroke, this.fillColor, true, this.lineStroke, this.lineColor);
        }
        if (this.paintingHandles) {
            Coordinate[] viewCoordinates = viewport.getJava2DConverter().toViewCoordinates(modelCoordinates);
            g.setStroke(this.handleStroke);
            Rectangle2D viewRectangle = viewport.toViewRectangle(viewport.getEnvelopeInModelCoordinates());
            for (Coordinate p : viewCoordinates) {
                double x = p.x;
                double y = p.y;
                if (!viewRectangle.contains(x, y)) continue;
                this.vertexStyle.paint(g, new Point2D.Double(x, y));
            }
        }
    }

    @Override
    protected Collection<Style> styles() {
        return Collections.singleton(this);
    }

    @Override
    protected Map<Layer, Collection<Feature>> layerToFeaturesMap() {
        this.featureToSelectedItemsMap = new HashMap<Feature, Collection<Geometry>>();
        HashMap<Layer, Collection<Feature>> layerToFeaturesMap = new HashMap<Layer, Collection<Feature>>();
        Iterator<Layer> i = this.panel.getLayerManager().iterator(Layer.class);
        while (i.hasNext()) {
            Layer layer = i.next();
            if (layer instanceof LayerView) continue;
            Map<Feature, List<Geometry>> featureToSelectedItemsMapForLayer = this.featureToSelectedItemsMap(layer);
            for (Feature feature : featureToSelectedItemsMapForLayer.keySet()) {
                ArrayList<Geometry> list = new ArrayList<Geometry>(1);
                List<Geometry> selectedItems = featureToSelectedItemsMapForLayer.get(feature);
                if (selectedItems != null) {
                    list.addAll(selectedItems);
                }
                this.featureToSelectedItemsMap.put(feature, list);
            }
            ArrayList<Feature> list = new ArrayList<Feature>(featureToSelectedItemsMapForLayer.keySet());
            layerToFeaturesMap.put(layer, list);
        }
        return layerToFeaturesMap;
    }

    protected abstract Map<Feature, List<Geometry>> featureToSelectedItemsMap(Layer var1);

    private static Shape handle(Point2D point) {
        Rectangle2D.Double handle = new Rectangle2D.Double(0.0, 0.0, 5.0, 5.0);
        handle.x = point.getX() - 2.0;
        handle.y = point.getY() - 2.0;
        return handle;
    }

    public static void paintHandles(Graphics2D g, Coordinate[] coordinates, Stroke stroke, Color fillColor, Color lineColor, Viewport viewport) throws NoninvertibleTransformException {
        g.setStroke(stroke);
        g.setColor(fillColor);
        for (int i = 0; i < coordinates.length; ++i) {
            if (!viewport.getEnvelopeInModelCoordinates().contains(coordinates[i])) continue;
            g.fill(AbstractSelectionRenderer.handle(viewport.toViewPoint(new Point2D.Double(coordinates[i].x, coordinates[i].y))));
        }
        g.setColor(lineColor);
        for (Coordinate c : coordinates) {
            if (!viewport.getEnvelopeInModelCoordinates().contains(c)) continue;
            g.draw(AbstractSelectionRenderer.handle(viewport.toViewPoint(new Point2D.Double(c.x, c.y))));
        }
    }

    @Override
    protected boolean useImageCaching(Map<Layer, List<Feature>> layerToFeaturesMap) {
        return true;
    }

    public void setSelectionLineColor(Color color) {
        this.lineColor = color;
        this.handleFillColor = color;
        this.vertexStyle.setFillColor(this.handleFillColor);
    }

    public void setSelectionPointSize(int selectionPointSize) {
        this.selectionPointSize = selectionPointSize;
        this.vertexStyle.setSize(selectionPointSize);
    }

    public void setSelectionFillColor(Color color) {
        this.fillColor = color;
    }

    public Color getFillColor() {
        return this.fillColor;
    }

    public void setSelectionPointForm(String selectionPointForm) {
        this.selectionPointForm = selectionPointForm;
        this.vertexStyle = VertexStylesFactory.createVertexStyle(selectionPointForm);
        this.vertexStyle.setSize(this.selectionPointSize);
        this.vertexStyle.setAlpha(255);
        this.vertexStyle.setFillColor(this.handleFillColor);
        this.vertexStyle.setLineColor(this.handleLineColor);
    }
}

