/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.wms;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.util.StringUtil;
import com.vividsolutions.jump.workbench.Logger;
import com.vividsolutions.jump.workbench.WorkbenchException;
import com.vividsolutions.jump.workbench.ui.InputChangedFirer;
import com.vividsolutions.jump.workbench.ui.InputChangedListener;
import com.vividsolutions.jump.workbench.ui.plugin.PersistentBlackboardPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.wms.MapLayerWizardPanel;
import com.vividsolutions.jump.workbench.ui.plugin.wms.SelectUrlWithAuthPanel;
import com.vividsolutions.jump.workbench.ui.wizard.CancelNextException;
import com.vividsolutions.jump.workbench.ui.wizard.WizardPanelV2;
import com.vividsolutions.wms.MapImageFormatChooser;
import com.vividsolutions.wms.WMService;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.openjump.core.ui.plugin.wms.AddWmsLayerWizard;
import org.openjump.util.UriUtil;

public class URLWizardPanel
extends JPanel
implements WizardPanelV2 {
    private static URLWizardPanel instance = null;
    public static final String SERVICE_KEY = "SERVICE";
    public static final String FORMAT_KEY = "FORMAT";
    public static final String URL_KEY = "URL";
    public static final String API_KEY_NAME_AND_VALUE = "API_KEY_NAME_AND_VALUE";
    public static final String I18N_PREFIX = "ui.plugin.wms.URLWizardPanel.";
    private final InputChangedFirer inputChangedFirer = new InputChangedFirer();
    private Map<String, Object> dataMap;
    private String[] urlList;
    private SelectUrlWithAuthPanel urlPanel;
    private ApiKeyPanel apiKeyPanel;
    public static final String VERSION_KEY = "WMS_VERSION";
    public static final String TITLE = I18N.getInstance().get("ui.plugin.wms.URLWizardPanel.select-uniform-resource-locator-url");
    public static final String API_KEY_AUTHENTICATION = I18N.getInstance().get("ui.plugin.wms.URLWizardPanel.api-key-authentication");
    public static final String API_KEY_NAME = I18N.getInstance().get("ui.plugin.wms.URLWizardPanel.api-key-name");
    public static final String API_KEY_VALUE = I18N.getInstance().get("ui.plugin.wms.URLWizardPanel.api-key-value");
    public static final String API_KEY_NEEDED_FOR_GETCAPABILITIES = I18N.getInstance().get("ui.plugin.wms.URLWizardPanel.api-key-needed-for-getcapabilities");
    public static String wmsVersion = "1.3.0";
    public static final String[] wmsVersions = new String[]{"1.0.0", "1.1.0", "1.1.1", "1.3.0"};
    private String[] initialUrls = new String[0];

    private URLWizardPanel() {
        try {
            String urlString = (String)PersistentBlackboardPlugIn.getInstance().get("AddWMSQueryPlugin.CACHED_URL");
            this.initialUrls = urlString != null ? urlString.split(",") : AddWmsLayerWizard.DEFAULT_URLS;
            this.dataMap = new LinkedHashMap<String, Object>();
            this.jbInit();
        }
        catch (Exception ex) {
            Logger.warn(ex);
        }
    }

    @Override
    public void add(InputChangedListener listener) {
        this.inputChangedFirer.add(listener);
    }

    @Override
    public void remove(InputChangedListener listener) {
        this.inputChangedFirer.remove(listener);
    }

    void jbInit() {
        JPanel keepNorth = new JPanel(new GridBagLayout());
        this.urlList = (String[])this.dataMap.get(URL_KEY);
        if (this.urlList == null) {
            this.urlList = this.initialUrls;
        }
        this.urlPanel = new SelectUrlWithAuthPanel(this.urlList);
        this.urlPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), this.getTitle()));
        keepNorth.add((Component)this.urlPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
        JPanel versionPanel = this.createVersionPanel();
        versionPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), I18N.getInstance().get("ui.GenericNames.version")));
        keepNorth.add((Component)versionPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
        this.apiKeyPanel = new ApiKeyPanel();
        this.apiKeyPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), API_KEY_AUTHENTICATION));
        keepNorth.add((Component)this.apiKeyPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
        this.setLayout(new GridBagLayout());
        this.add((Component)keepNorth, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
    }

    @Override
    public String getInstructions() {
        return I18N.getInstance().get("ui.plugin.wms.URLWizardPanel.please-enter-the-url-of-the-wms-server");
    }

    @Override
    public void exitingToRight() throws WorkbenchException {
        try {
            String url = this.urlPanel.getUrl();
            url = UriUtil.urlAddCredentials(url, this.urlPanel.getUser(), this.urlPanel.getPass());
            String apiKeyNameAndValue = this.apiKeyPanel.getApiKeyNameAndValue();
            WMService service = new WMService(url, wmsVersion, apiKeyNameAndValue, this.apiKeyPanel.isApiKeyNeededForGetCapabilities());
            service.initialize(true);
            LinkedHashSet<String> list = new LinkedHashSet<String>();
            list.add(url);
            list.addAll(Arrays.asList(this.urlList));
            this.dataMap.put(URL_KEY, list.toArray(new String[0]));
            this.dataMap.put(SERVICE_KEY, service);
            MapImageFormatChooser formatChooser = new MapImageFormatChooser(wmsVersion);
            formatChooser.setPreferLossyCompression(false);
            formatChooser.setTransparencyRequired(true);
            String format = formatChooser.chooseFormat(service.getCapabilities().getMapFormats());
            if (format == null) {
                throw new WorkbenchException(I18N.getInstance().get("ui.plugin.wms.URLWizardPanel.the-server-does-not-support-gif-png-or-jpeg-format"));
            }
            this.dataMap.put("FORMAT_LIST", service.getCapabilities().getMapFormats());
            this.dataMap.put(FORMAT_KEY, format);
            this.dataMap.put("INITIAL_LAYER_NAMES", null);
            this.dataMap.put(VERSION_KEY, wmsVersion);
            this.dataMap.put(API_KEY_NAME_AND_VALUE, apiKeyNameAndValue);
            this.dataMap.put(API_KEY_NEEDED_FOR_GETCAPABILITIES, this.apiKeyPanel.isApiKeyNeededForGetCapabilities());
        }
        catch (IOException e) {
            throw new CancelNextException(e);
        }
    }

    @Override
    public void enteredFromLeft(Map<String, Object> dataMap) {
        this.dataMap = dataMap;
    }

    @Override
    public void enteredFromRight() {
        if (this.dataMap.get(URL_KEY) != null) {
            this.urlPanel.setUrlsList((String[])this.dataMap.get(URL_KEY));
        }
    }

    @Override
    public String getTitle() {
        return TITLE;
    }

    @Override
    public String getID() {
        return this.getClass().getName();
    }

    @Override
    public boolean isInputValid() {
        try {
            String urlString = this.urlPanel.getUrl();
            String host = new URL(urlString).getHost();
            return !host.isEmpty();
        }
        catch (Throwable e) {
            return false;
        }
    }

    @Override
    public String getNextID() {
        return MapLayerWizardPanel.class.getName();
    }

    public JPanel createVersionPanel() {
        JPanel p = new JPanel(new GridBagLayout());
        ActionListener al = e -> {
            JRadioButton jb = (JRadioButton)e.getSource();
            wmsVersion = jb.getText();
        };
        String[] versions = wmsVersions;
        ButtonGroup group = new ButtonGroup();
        JRadioButton[] buttons = new JRadioButton[versions.length];
        for (int i = 0; i < buttons.length; ++i) {
            buttons[i] = new JRadioButton(versions[i]);
            buttons[i].addActionListener(al);
            group.add(buttons[i]);
            p.add(buttons[i]);
            if (!versions[i].equals(wmsVersion)) continue;
            buttons[i].setSelected(true);
        }
        return p;
    }

    public static URLWizardPanel getInstance() {
        if (instance == null) {
            instance = new URLWizardPanel();
        }
        return instance;
    }

    @Override
    public void exitingToLeft() {
    }

    private static class ApiKeyPanel
    extends JPanel {
        JLabel keyNameLabel = new JLabel(API_KEY_NAME);
        JTextField keyNameField = new JTextField(12);
        JLabel keyValueName = new JLabel(API_KEY_VALUE);
        JTextField keyValueField = new JTextField(12);
        JCheckBox apiKeyNeededForGetCapabilities = new JCheckBox(API_KEY_NEEDED_FOR_GETCAPABILITIES, true);

        public ApiKeyPanel() {
            super(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.insets = new Insets(2, 2, 2, 2);
            c.anchor = 17;
            c.fill = 0;
            c.gridx = 0;
            c.gridy = 0;
            c.weightx = 0.1;
            this.add((Component)this.keyNameLabel, c);
            c.gridx = 1;
            c.gridy = 0;
            c.weightx = 1.0;
            this.add((Component)this.keyNameField, c);
            c.fill = 0;
            c.gridx = 0;
            c.gridy = 1;
            c.weightx = 0.1;
            this.add((Component)this.keyValueName, c);
            c.gridx = 1;
            c.gridy = 1;
            c.weightx = 1.0;
            this.add((Component)this.keyValueField, c);
            c.gridx = 0;
            c.gridy = 2;
            c.gridwidth = 2;
            c.weightx = 1.0;
            this.add((Component)this.apiKeyNeededForGetCapabilities, c);
        }

        public String getApiKeyNameAndValue() throws UnsupportedEncodingException {
            if (!StringUtil.isEmpty(this.keyNameField.getText()) && !StringUtil.isEmpty(this.keyValueField.getText())) {
                return URLEncoder.encode(this.keyNameField.getText(), "UTF-8") + "=" + URLEncoder.encode(this.keyValueField.getText(), "UTF-8");
            }
            return null;
        }

        public Boolean isApiKeyNeededForGetCapabilities() throws UnsupportedEncodingException {
            return !StringUtil.isEmpty(this.keyValueField.getText()) && !StringUtil.isEmpty(this.keyValueField.getText()) && this.apiKeyNeededForGetCapabilities.isSelected();
        }
    }
}

