/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.wms;

import com.vividsolutions.jump.I18N;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxEditor;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.openjump.util.UriUtil;

public class SelectUrlWithAuthPanel
extends JPanel {
    private JComboBox<String> urls;
    private JTextField user;
    private JPasswordField pass;
    private JTextComponent url;
    private final String[] initialUrls;

    public SelectUrlWithAuthPanel(String[] initialUrls) {
        this.initialUrls = initialUrls;
        this.initUrlPanel();
    }

    private void initUrlPanel() {
        JLabel urlLabel = new JLabel(I18N.getInstance().get("ui.GenericNames.url"));
        JLabel userLabel = new JLabel(I18N.getInstance().get("ui.GenericNames.user"));
        JLabel passLabel = new JLabel(I18N.getInstance().get("ui.GenericNames.password"));
        JLabel showLabel = new JLabel(I18N.getInstance().get("ui.GenericNames.show"));
        this.user = new JTextField();
        this.pass = new JPasswordField();
        char echoChar = this.pass.getEchoChar();
        JCheckBox show = new JCheckBox();
        show.setBorder(null);
        show.addActionListener(e -> {
            char c = show.isSelected() ? (char)'\u0000' : echoChar;
            this.pass.setEchoChar(c);
        });
        this.setLayout(new GridBagLayout());
        this.urls = new JComboBox<String>(this.initialUrls){

            private int limitH(int h) {
                return Math.min(h, 50);
            }

            @Override
            public Dimension getMinimumSize() {
                int w = super.getMinimumSize().width;
                int h = this.getEditor().getEditorComponent().getMinimumSize().height;
                return new Dimension(w, this.limitH(h));
            }

            @Override
            public Dimension getPreferredSize() {
                int w = super.getPreferredSize().width;
                int h = this.getEditor().getEditorComponent().getPreferredSize().height;
                return new Dimension(w, this.limitH(h));
            }
        };
        this.urls.setEditable(true);
        this.urls.getEditor().selectAll();
        ListCellRenderer<String> rendi = this.urls.getRenderer();
        this.urls.setRenderer((list, value, index, isSelected, cellHasFocus) -> {
            Component c = rendi.getListCellRendererComponent(list, (String)value, index, isSelected, cellHasFocus);
            if (c instanceof JLabel) {
                String url = ((JLabel)c).getText();
                ((JLabel)c).setText(UriUtil.urlStripPassword(url));
            }
            return c;
        });
        URLComboBoxEditor ed = new URLComboBoxEditor(this.user, this.pass);
        this.urls.setEditor(ed);
        this.url = (JTextComponent)ed.getEditorComponent();
        Insets insets = new Insets(3, 3, 3, 3);
        this.add((Component)urlLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        this.add(this.urls, new GridBagConstraints(1, 0, 4, 1, 0.0, 0.0, 10, 1, insets, 0, 0));
        this.add((Component)userLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        this.add((Component)this.user, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 2, insets, 0, 0));
        this.add((Component)passLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        this.add((Component)this.pass, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 2, insets, 0, 0));
        this.add((Component)show, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 10, 0, insets, 0, 0));
        this.add((Component)showLabel, new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 13, 2, insets, 0, 0));
    }

    public String getUser() {
        return this.user.getText();
    }

    public String getPass() {
        return new String(this.pass.getPassword());
    }

    public void setUrl(String url) {
        this.urls.getEditor().setItem(url);
    }

    public String getUrl() {
        return this.url.getText();
    }

    public List<String> getUrlsList() {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < this.urls.getItemCount(); ++i) {
            if (i == this.urls.getSelectedIndex()) continue;
            list.add(this.urls.getItemAt(i));
        }
        return list;
    }

    public void setUrlsList(String[] urls) {
        this.urls.setModel(new JComboBox<String>(urls).getModel());
    }

    static class URLComboBoxEditor
    extends TextAreaComboBoxEditor {
        private final JTextField user;
        private final JTextField pass;

        public URLComboBoxEditor(final JTextField user, final JTextField pass) {
            this.user = user;
            this.pass = pass;
            final JTextComponent editor = (JTextComponent)this.getEditorComponent();
            editor.getDocument().addDocumentListener(new DocumentListener(){
                boolean enabled = true;

                @Override
                public void removeUpdate(DocumentEvent e) {
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.fetchAuthIntoFields(e);
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.fetchAuthIntoFields(e);
                }

                private void fetchAuthIntoFields(DocumentEvent e) {
                    if (!this.enabled) {
                        return;
                    }
                    this.enabled = false;
                    final String edText = editor.getText();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            String passText;
                            String userText;
                            FilteredURLString url = new FilteredURLString(edText);
                            String text = url.toString();
                            if (!text.equals(url.unFiltered())) {
                                int posdiff = url.unFiltered().length() - text.length();
                                int curpos = editor.getCaretPosition();
                                int maxpos = text.length();
                                editor.setText(text);
                                editor.setCaretPosition(curpos > maxpos ? maxpos : curpos - posdiff);
                            }
                            if (!(userText = UriUtil.urlGetUser(url.unFiltered())).isEmpty()) {
                                user.setText(userText);
                            }
                            if (!(passText = UriUtil.urlGetPassword(url.unFiltered())).isEmpty()) {
                                pass.setText(passText);
                            }
                            enabled = true;
                        }
                    });
                }
            });
        }

        @Override
        public void setItem(Object anObject) {
            FilteredURLString url = anObject instanceof FilteredURLString ? (FilteredURLString)anObject : new FilteredURLString(anObject.toString());
            JTextComponent editor = (JTextComponent)this.getEditorComponent();
            this.user.setText("");
            this.pass.setText("");
            editor.setText(url.unFiltered());
        }

        @Override
        public Object getItem() {
            return new FilteredURLString(UriUtil.urlAddCredentials(this.editor.getText(), this.user.getText(), this.pass.getText()));
        }
    }

    static class TextAreaComboBoxEditor
    implements ComboBoxEditor {
        protected final JTextArea editor;
        protected Object item = null;

        public TextAreaComboBoxEditor() {
            JTextField dummy = new JTextField();
            dummy.setEnabled(true);
            dummy.setEditable(true);
            JTextArea area = new JTextArea();
            area.setLineWrap(true);
            area.setFont(dummy.getFont());
            area.setForeground(dummy.getForeground());
            area.setBackground(dummy.getBackground());
            Insets insets = dummy.getBorder().getBorderInsets(dummy);
            area.setBorder(BorderFactory.createEmptyBorder(insets.top, insets.left, insets.bottom, insets.right));
            this.editor = area;
        }

        @Override
        public void addActionListener(ActionListener l) {
        }

        @Override
        public Component getEditorComponent() {
            return this.editor;
        }

        @Override
        public Object getItem() {
            return this.item;
        }

        @Override
        public void removeActionListener(ActionListener l) {
        }

        @Override
        public void selectAll() {
        }

        @Override
        public void setItem(Object newValue) {
            this.item = newValue;
            this.editor.setText(this.item.toString());
        }
    }

    static class FilteredURLString {
        private final String url;

        public FilteredURLString(String url) {
            this.url = url;
        }

        public String filtered() {
            return UriUtil.urlStripAuth(this.url);
        }

        public String unFiltered() {
            return this.url;
        }

        public String toString() {
            return this.filtered();
        }

        public boolean equals(Object obj) {
            return obj instanceof FilteredURLString && this.url.equals(((FilteredURLString)obj).url);
        }
    }
}

