/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.skin;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.Logger;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.OptionsDialog;
import com.vividsolutions.jump.workbench.ui.plugin.skin.LookAndFeelProxy;
import com.vividsolutions.jump.workbench.ui.plugin.skin.SkinOptionsPanel;
import java.util.ArrayList;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;

public class InstallSkinsPlugIn
extends AbstractPlugIn {
    private static String SKINS = I18N.getInstance().get("ui.plugin.skin.InstallSkinsPlugIn.skins");
    private static String DEFAULT = I18N.getInstance().get("ui.plugin.skin.InstallSkinsPlugIn.default");

    private LookAndFeelProxy createProxy(final String name, final String lookAndFeelClassName) {
        return new LookAndFeelProxy(){

            @Override
            public LookAndFeel getLookAndFeel() {
                try {
                    return (LookAndFeel)Class.forName(lookAndFeelClassName).newInstance();
                }
                catch (InstantiationException e) {
                    Logger.error(e);
                }
                catch (IllegalAccessException e) {
                    Logger.error(e);
                }
                catch (ClassNotFoundException e) {
                    Logger.error(e);
                }
                return null;
            }

            public String toString() {
                return name;
            }
        };
    }

    @Override
    public void initialize(PlugInContext context) throws Exception {
        SKINS = I18N.getInstance().get("ui.plugin.skin.InstallSkinsPlugIn.skins");
        DEFAULT = I18N.getInstance().get("ui.plugin.skin.InstallSkinsPlugIn.default");
        ArrayList<LookAndFeelProxy> skins = new ArrayList<LookAndFeelProxy>();
        for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
            String desc = info.getName();
            if (info.getClassName() == UIManager.getSystemLookAndFeelClassName()) {
                desc = desc + " (" + DEFAULT + ")";
            }
            skins.add(this.createProxy(desc, info.getClassName()));
        }
        context.getWorkbenchContext().getWorkbench().getBlackboard().put(SkinOptionsPanel.SKINS_KEY, skins);
        OptionsDialog.instance(context.getWorkbenchContext().getWorkbench()).addTab(SKINS, new SkinOptionsPanel(context));
    }
}

