/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.datastore;

import com.vividsolutions.jump.datastore.DataStoreConnection;
import com.vividsolutions.jump.datastore.DataStoreMetadata;
import com.vividsolutions.jump.datastore.FilterQuery;
import com.vividsolutions.jump.datastore.SpatialReferenceSystemID;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.io.datasource.Connection;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.util.CollectionUtil;
import com.vividsolutions.jump.util.LangUtil;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.datastore.ConnectionDescriptor;
import com.vividsolutions.jump.workbench.datastore.ConnectionManager;
import com.vividsolutions.jump.workbench.model.cache.CachingFeatureCollection;
import com.vividsolutions.jump.workbench.model.cache.DynamicFeatureCollection;
import com.vividsolutions.jump.workbench.ui.plugin.WorkbenchContextReference;
import com.vividsolutions.jump.workbench.ui.plugin.datastore.DataStoreQueryDataSource;
import com.vividsolutions.jump.workbench.ui.plugin.datastore.PasswordPrompter;
import java.util.ArrayList;
import java.util.Collection;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.GeometryFactory;

public class DataStoreDataSource
extends DataStoreQueryDataSource
implements WorkbenchContextReference {
    public static final String DATASET_NAME_KEY = "Dataset Name";
    public static final String GEOMETRY_ATTRIBUTE_NAME_KEY = "Geometry Attribute Name";
    public static final String MAX_FEATURES_KEY = "Max Features";
    public static final String WHERE_CLAUSE_KEY = "Where Clause";
    public static final String CACHING_KEY = "Caching";
    protected WorkbenchContext context;

    public DataStoreDataSource() {
    }

    public DataStoreDataSource(String datasetName, String geometryAttributeName, String whereClause, ConnectionDescriptor connectionDescriptor, boolean caching, WorkbenchContext context) {
        this.setProperties(CollectionUtil.createMap(new Object[]{DATASET_NAME_KEY, datasetName, GEOMETRY_ATTRIBUTE_NAME_KEY, geometryAttributeName, WHERE_CLAUSE_KEY, whereClause, "Connection Descriptor", connectionDescriptor, CACHING_KEY, caching, "SQL Query", ""}));
        this.setWorkbenchContext(context);
    }

    public DataStoreDataSource(String datasetName, String geometryAttributeName, String whereClause, int maxFeatures, ConnectionDescriptor connectionDescriptor, boolean caching, WorkbenchContext context) {
        this.setProperties(CollectionUtil.createMap(new Object[]{DATASET_NAME_KEY, datasetName, GEOMETRY_ATTRIBUTE_NAME_KEY, geometryAttributeName, WHERE_CLAUSE_KEY, whereClause, MAX_FEATURES_KEY, maxFeatures, "Connection Descriptor", connectionDescriptor, CACHING_KEY, caching}));
        this.setWorkbenchContext(context);
    }

    public void setWhereClause(String whereClause) {
        this.getProperties().put(WHERE_CLAUSE_KEY, whereClause);
    }

    public void setMaxFeature(int maxFeatures) {
        this.getProperties().put(MAX_FEATURES_KEY, maxFeatures);
    }

    @Override
    public boolean isWritable() {
        return false;
    }

    @Override
    public Connection getConnection() {
        return new Connection(){

            @Override
            public FeatureCollection executeQuery(String query, Collection<Throwable> exceptions, TaskMonitor monitor) {
                try {
                    return DataStoreDataSource.this.createFeatureCollection();
                }
                catch (Exception e) {
                    exceptions.add(e);
                    return null;
                }
            }

            @Override
            public FeatureCollection executeQuery(String query, TaskMonitor monitor) throws Exception {
                ArrayList<Throwable> exceptions = new ArrayList<Throwable>();
                FeatureCollection featureCollection = this.executeQuery(query, exceptions, monitor);
                if (!exceptions.isEmpty()) {
                    throw (Exception)exceptions.iterator().next();
                }
                return featureCollection;
            }

            @Override
            public void executeUpdate(String query, FeatureCollection featureCollection, TaskMonitor monitor) throws Exception {
                throw new UnsupportedOperationException();
            }

            @Override
            public void close() {
            }
        };
    }

    @Override
    protected FeatureCollection createFeatureCollection() throws Exception {
        FilterQuery query = new FilterQuery();
        query.setDatasetName((String)this.getProperties().get(DATASET_NAME_KEY));
        query.setGeometryAttributeName((String)this.getProperties().get(GEOMETRY_ATTRIBUTE_NAME_KEY));
        if (((String)this.getProperties().get(WHERE_CLAUSE_KEY)).length() > 0) {
            query.setCondition((String)this.getProperties().get(WHERE_CLAUSE_KEY));
        }
        if (this.getProperties().get(MAX_FEATURES_KEY) != null) {
            query.setLimit((Integer)this.getProperties().get(MAX_FEATURES_KEY));
        }
        DataStoreConnection conn = ConnectionManager.instance(this.context).getConnection((ConnectionDescriptor)this.getProperties().get("Connection Descriptor"));
        DataStoreMetadata meta = conn.getMetadata();
        SpatialReferenceSystemID srid = meta.getSRID(query.getDatasetName(), query.getGeometryAttributeName());
        String[] colNames = meta.getColumnNames(query.getDatasetName());
        Envelope env = meta.getExtents(query.getDatasetName(), query.getGeometryAttributeName());
        if (env == null) {
            env = new Envelope();
        }
        query.setFilterGeometry(new GeometryFactory().toGeometry(env));
        String queryString = conn.getSqlBuilder(srid, colNames).getSQL(query);
        this.getProperties().put("SQL Query", queryString);
        return new CachingFeatureCollection(new DynamicFeatureCollection((ConnectionDescriptor)this.getProperties().get("Connection Descriptor"), ConnectionManager.instance(this.context), query)).setCachingByEnvelope((Boolean)LangUtil.ifNull(this.getProperties().get(CACHING_KEY), Boolean.TRUE));
    }

    @Override
    protected WorkbenchContext getWorkbenchContext() {
        return this.context;
    }

    @Override
    public void setWorkbenchContext(WorkbenchContext context) {
        this.context = context;
        try {
            new PasswordPrompter().getOpenConnection(ConnectionManager.instance(context), (ConnectionDescriptor)this.getProperties().get("Connection Descriptor"), context.getWorkbench().getFrame());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

