/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.analysis;

import com.vividsolutions.jump.geom.AbstractGeometryProcessor;
import java.util.List;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateList;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;

public class RemoveSmallSegments
extends AbstractGeometryProcessor {
    private double tolerance;
    private double minTolerance;
    private double squareTolerance;

    public RemoveSmallSegments(double tolerance) {
        this.tolerance = tolerance;
        this.squareTolerance = tolerance * tolerance;
        this.minTolerance = tolerance / 16.0;
    }

    private RemoveSmallSegments(double tolerance, double minTolerance) {
        this.tolerance = tolerance;
        this.minTolerance = minTolerance;
        this.squareTolerance = tolerance * tolerance;
    }

    @Override
    public Geometry process(Geometry geometry) {
        Geometry geom = super.process(geometry);
        if (!geom.isValid() && this.tolerance > this.minTolerance) {
            return new RemoveSmallSegments(this.tolerance / 2.0, this.minTolerance).process(geometry);
        }
        return geom;
    }

    @Override
    public void process(LineString line, List<Geometry> list) {
        CoordinateList cl = new CoordinateList(line.getCoordinates(), false);
        if ((cl = this.simplifies(cl, this.tolerance, false)).size() < 2) {
            System.out.println("" + line + " -> " + cl.getCoordinate(0));
        }
        list.add((Geometry)line.getFactory().createLineString(cl.toCoordinateArray()));
    }

    @Override
    public LinearRing process(LinearRing ring) {
        CoordinateList cl = new CoordinateList(ring.getCoordinates(), false);
        cl.remove(cl.size() - 1);
        cl = this.simplifies(cl, this.tolerance, true);
        cl.closeRing();
        return ring.getFactory().createLinearRing(cl.toCoordinateArray());
    }

    private CoordinateList simplifies(CoordinateList cl, double tolerance, boolean closed) {
        int index;
        int size;
        int min;
        int n = min = closed ? 4 : 2;
        while ((size = cl.size()) > min && (index = this.getShortestSegment(cl, tolerance, closed)) > -1) {
            double a1;
            double a0;
            if (closed) {
                Coordinate prev = cl.getCoordinate((size + index - 1) % size);
                Coordinate cur0 = cl.getCoordinate((size + index) % size);
                Coordinate cur1 = cl.getCoordinate((size + index + 1) % size);
                Coordinate next = cl.getCoordinate((size + index + 2) % size);
                a0 = this.sin2AOB(prev, cur0, cur1);
                a1 = this.sin2AOB(cur0, cur1, next);
            } else {
                a0 = index == 0 ? 1.0 : this.sin2AOB(cl.getCoordinate(index - 1), cl.getCoordinate(index), cl.getCoordinate(index + 1));
                double d = a1 = index == size - 2 ? 1.0 : this.sin2AOB(cl.getCoordinate(index), cl.getCoordinate(index + 1), cl.getCoordinate(index + 2));
            }
            if (a0 < a1) {
                cl.remove(index);
                continue;
            }
            cl.remove((index + 1) % size);
        }
        return cl;
    }

    private int getShortestSegment(CoordinateList cl, double tolerance, boolean closed) {
        int index = -1;
        double shortestLength = tolerance;
        int size = cl.size();
        int max = closed ? size : size - 1;
        for (int i = 0; i < max; ++i) {
            double length = cl.getCoordinate(i).distance(cl.getCoordinate((i + 1) % size));
            if (!(length < shortestLength)) continue;
            index = i;
            shortestLength = length;
        }
        return index;
    }

    private boolean isMicro(Coordinate c0, Coordinate c1) {
        double dx = c1.x - c0.x;
        double dy = c1.y - c0.y;
        return dx * dx + dy * dy < this.squareTolerance;
    }

    private double sin2AOB(Coordinate A, Coordinate O, Coordinate B) {
        double dxa = A.x - O.x;
        double dya = A.y - O.y;
        double dxb = B.x - O.x;
        double dyb = B.y - O.y;
        return (dxa * dyb - dya * dxb) * (dxa * dyb - dya * dxb) / (dxa * dxa + dya * dya) / (dxb * dxb + dyb * dyb);
    }

    private double cos2OAOB(Coordinate A, Coordinate O, Coordinate B) {
        double oax = A.x - O.x;
        double oay = A.y - O.y;
        double obx = B.x - O.x;
        double oby = B.y - O.y;
        return (oax * obx + oay * oby) * (oax * obx + oay * oby) / (oax * oax + oay * oay) / (obx * obx + oby * oby);
    }
}

