/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.analysis;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.algorithm.Densifier;
import com.vividsolutions.jump.geom.AbstractGeometryProcessor;
import com.vividsolutions.jump.workbench.ui.plugin.analysis.RemoveSmallSegments;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.locationtech.jts.algorithm.ConvexHull;
import org.locationtech.jts.algorithm.MinimumBoundingCircle;
import org.locationtech.jts.algorithm.MinimumDiameter;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.operation.linemerge.LineMerger;
import org.locationtech.jts.operation.linemerge.LineSequencer;
import org.locationtech.jts.operation.overlay.snap.GeometrySnapper;
import org.locationtech.jts.operation.overlayng.OverlayNG;
import org.locationtech.jts.operation.overlayng.OverlayNGRobust;
import org.locationtech.jts.operation.polygonize.Polygonizer;
import org.locationtech.jts.simplify.DouglasPeuckerSimplifier;
import org.locationtech.jts.simplify.TopologyPreservingSimplifier;
import org.locationtech.jts.simplify.VWSimplifier;

public abstract class GeometryFunction {
    private static final GeometryFunction[] methods = new GeometryFunction[]{new IntersectionFunction(), new RobustIntersectionFunction(), new FixedPrecisionIntersectionFunction(), new UnionFunction(), new RobustUnionFunction(), new FixedPrecisionUnionFunction(), new DifferenceABFunction(), new RobustDifferenceABFunction(), new FixedPrecisionDifferenceABFunction(), new DifferenceBAFunction(), new RobustDifferenceBAFunction(), new FixedPrecisionDifferenceBAFunction(), new SymDifferenceFunction(), new RobustSymDifferenceFunction(), new FixedPrecisionSymDifferenceFunction(), new CentroidFunction(), new InteriorPointFunction(), new BufferFunction(), new SimplifyFunction(), new SimplifyTopologyFunction(), new SimplifyVWFunction(), new RemoveSmallSegmentsFunction(), new DensifyFunction(), new ConvexHullFunction(), new BoundaryFunction(), new EnvelopeFunction(), new WrapIntoMultiFunction(), new UnwrapSingleFunction(), new LineMergeFunction(), new LineSequenceFunction(), new PolygonizeFunction(), new ReverseLinestringFunction(), new MinimumBoundingCircleFunction(), new MinimumDiameterFunction(), new MinimumBoundingRectangleFunction(), new RemoveHolesFunction(), new RemoveSmallHolesFunction(), new SnapToSelfFunction()};
    private final String name;
    private final int nArguments;
    private final int nParams;
    private boolean isAggregate = false;
    private final String description;

    public static List<String> getNames() {
        ArrayList<String> methodNames = new ArrayList<String>();
        for (GeometryFunction method : methods) {
            methodNames.add(method.name);
        }
        return methodNames;
    }

    public static List<String> getNames(Collection<GeometryFunction> functions) {
        ArrayList<String> names = new ArrayList<String>();
        for (GeometryFunction fun : functions) {
            names.add(fun.name);
        }
        return names;
    }

    public static GeometryFunction getFunction(String name) {
        for (GeometryFunction method : methods) {
            if (!method.name.equals(name)) continue;
            return method;
        }
        return null;
    }

    public static GeometryFunction getFunction(Collection<GeometryFunction> functions, String name) {
        for (GeometryFunction func : functions) {
            if (!func.name.equals(name)) continue;
            return func;
        }
        return null;
    }

    public static GeometryFunction[] getFunctions() {
        return methods;
    }

    public String getName() {
        return this.name;
    }

    public int getGeometryArgumentCount() {
        return this.nArguments;
    }

    public int getParameterCount() {
        return this.nParams;
    }

    public GeometryFunction(String name, int nArgs, int nParams) {
        this(name, nArgs, nParams, name + " " + I18N.getInstance().get("ui.plugin.analysis.GeometryFunctionPlugIn.function"));
    }

    public GeometryFunction(String name, int nArgs, int nParams, String description) {
        this.name = name;
        this.nArguments = nArgs;
        this.nParams = nParams;
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public abstract Geometry execute(Geometry[] var1, double[] var2);

    public String toString() {
        return this.name;
    }

    private static class SnapToSelfFunction
    extends GeometryFunction {
        public SnapToSelfFunction() {
            super(I18N.getInstance().get("ui.plugin.analysis.GeometryFunction.Snap-To-Self"), 1, 1);
        }

        @Override
        public Geometry execute(Geometry[] geom, double[] param) {
            return GeometrySnapper.snapToSelf((Geometry)geom[0], (double)param[0], (boolean)true);
        }
    }

    private static class RemoveSmallSegmentsFunction
    extends GeometryFunction {
        public RemoveSmallSegmentsFunction() {
            super(I18N.getInstance().get("ui.plugin.analysis.GeometryFunction.Remove-Small-Segments"), 1, 1);
        }

        @Override
        public Geometry execute(Geometry[] geom, double[] param) {
            RemoveSmallSegments removeSmallSegments = new RemoveSmallSegments(param[0]);
            return removeSmallSegments.process(geom[0]);
        }
    }

    private static class RemoveSmallHolesFunction
    extends GeometryFunction {
        public RemoveSmallHolesFunction() {
            super(I18N.getInstance().get("ui.plugin.analysis.GeometryFunction.Remove-Small-Holes"), 1, 1);
        }

        @Override
        public Geometry execute(Geometry[] geom, final double[] param) {
            AbstractGeometryProcessor removeHoleProcessor = new AbstractGeometryProcessor(){

                @Override
                public void process(Polygon polygon, List<Geometry> list) {
                    ArrayList<LinearRing> holes = new ArrayList<LinearRing>();
                    for (int i = 0; i < polygon.getNumInteriorRing(); ++i) {
                        LinearRing ring = polygon.getInteriorRingN(i);
                        if (!(ring.getFactory().createPolygon(ring).getArea() >= param[0])) continue;
                        holes.add(ring);
                    }
                    list.add((Geometry)polygon.getFactory().createPolygon(polygon.getExteriorRing(), holes.toArray(new LinearRing[0])));
                }
            };
            return removeHoleProcessor.process(geom[0]);
        }
    }

    private static class RemoveHolesFunction
    extends GeometryFunction {
        public RemoveHolesFunction() {
            super(I18N.getInstance().get("ui.plugin.analysis.GeometryFunction.Remove-Holes"), 1, 0);
        }

        @Override
        public Geometry execute(Geometry[] geom, double[] param) {
            AbstractGeometryProcessor removeHoleProcessor = new AbstractGeometryProcessor(){

                @Override
                public void process(Polygon polygon, List<Geometry> list) {
                    list.add((Geometry)polygon.getFactory().createPolygon(polygon.getExteriorRing()));
                }
            };
            return removeHoleProcessor.process(geom[0]);
        }
    }

    private static class MinimumBoundingRectangleFunction
    extends GeometryFunction {
        public MinimumBoundingRectangleFunction() {
            super(I18N.getInstance().get("ui.plugin.analysis.GeometryFunction.Minimum-Bounding-Rectangle"), 1, 0);
        }

        @Override
        public Geometry execute(Geometry[] geom, double[] param) {
            return new MinimumDiameter(geom[0]).getMinimumRectangle();
        }
    }

    private static class MinimumDiameterFunction
    extends GeometryFunction {
        public MinimumDiameterFunction() {
            super(I18N.getInstance().get("ui.plugin.analysis.GeometryFunction.Minimum-Diameter"), 1, 0);
        }

        @Override
        public Geometry execute(Geometry[] geom, double[] param) {
            return new MinimumDiameter(geom[0]).getDiameter();
        }
    }

    private static class MinimumBoundingCircleFunction
    extends GeometryFunction {
        public MinimumBoundingCircleFunction() {
            super(I18N.getInstance().get("ui.plugin.analysis.GeometryFunction.Minimum-Bounding-Circle"), 1, 0);
        }

        @Override
        public Geometry execute(Geometry[] geom, double[] param) {
            return new MinimumBoundingCircle(geom[0]).getCircle();
        }
    }

    private static class DensifyFunction
    extends GeometryFunction {
        public DensifyFunction() {
            super(I18N.getInstance().get("ui.plugin.analysis.GeometryFunction.Densify"), 1, 1);
        }

        @Override
        public Geometry execute(Geometry[] geom, double[] param) {
            return Densifier.densify(geom[0], param[0]);
        }
    }

    private static class ReverseLinestringFunction
    extends GeometryFunction {
        public ReverseLinestringFunction() {
            super(I18N.getInstance().get("ui.plugin.analysis.GeometryFunction.Reverse-Line-Direction"), 1, 0);
        }

        @Override
        public Geometry execute(Geometry[] geom, double[] param) {
            Geometry clone = geom[0].copy();
            return clone.reverse();
        }
    }

    private static class PolygonizeFunction
    extends GeometryFunction {
        public PolygonizeFunction() {
            super(I18N.getInstance().get("ui.plugin.analysis.GeometryFunction.Polygonize"), 1, 0);
        }

        @Override
        public Geometry execute(Geometry[] geom, double[] param) {
            Polygonizer polygonizer = new Polygonizer();
            polygonizer.add(geom[0]);
            Collection polyColl = polygonizer.getPolygons();
            return geom[0].getFactory().buildGeometry(polyColl);
        }
    }

    private static class LineSequenceFunction
    extends GeometryFunction {
        public LineSequenceFunction() {
            super(I18N.getInstance().get("ui.plugin.analysis.GeometryFunction.Line-Sequence"), 1, 0);
        }

        @Override
        public Geometry execute(Geometry[] geom, double[] param) {
            LineSequencer sequencer = new LineSequencer();
            sequencer.add(geom[0]);
            return sequencer.getSequencedLineStrings();
        }
    }

    private static class LineMergeFunction
    extends GeometryFunction {
        public LineMergeFunction() {
            super(I18N.getInstance().get("ui.plugin.analysis.GeometryFunction.Line-Merge"), 1, 0);
        }

        @Override
        public Geometry execute(Geometry[] geom, double[] param) {
            LineMerger merger = new LineMerger();
            merger.add(geom[0]);
            Collection lines = merger.getMergedLineStrings();
            return geom[0].getFactory().buildGeometry(lines);
        }
    }

    private static class UnwrapSingleFunction
    extends GeometryFunction {
        public UnwrapSingleFunction() {
            super(I18N.getInstance().get("ui.plugin.analysis.GeometryFunction.UnwrapSingle"), 1, 0);
        }

        @Override
        public Geometry execute(Geometry[] geom, double[] param) {
            if (geom[0] instanceof GeometryCollection && geom[0].getNumGeometries() == 1) {
                return geom[0].getGeometryN(0);
            }
            return geom[0];
        }
    }

    private static class WrapIntoMultiFunction
    extends GeometryFunction {
        public WrapIntoMultiFunction() {
            super(I18N.getInstance().get("ui.plugin.analysis.GeometryFunction.WrapIntoMulti"), 1, 0);
        }

        @Override
        public Geometry execute(Geometry[] geom, double[] param) {
            if (geom[0] instanceof GeometryCollection) {
                return geom[0];
            }
            if (geom[0].getDimension() == 0) {
                return geom[0].getFactory().createMultiPoint(new Point[]{(Point)geom[0]});
            }
            if (geom[0].getDimension() == 1) {
                return geom[0].getFactory().createMultiLineString(new LineString[]{(LineString)geom[0]});
            }
            if (geom[0].getDimension() == 2) {
                return geom[0].getFactory().createMultiPolygon(new Polygon[]{(Polygon)geom[0]});
            }
            return geom[0];
        }
    }

    private static class EnvelopeFunction
    extends GeometryFunction {
        public EnvelopeFunction() {
            super(I18N.getInstance().get("ui.plugin.analysis.GeometryFunction.Envelope"), 1, 0);
        }

        @Override
        public Geometry execute(Geometry[] geom, double[] param) {
            return geom[0].getEnvelope();
        }
    }

    private static class BoundaryFunction
    extends GeometryFunction {
        public BoundaryFunction() {
            super(I18N.getInstance().get("ui.plugin.analysis.GeometryFunction.Boundary"), 1, 0);
        }

        @Override
        public Geometry execute(Geometry[] geom, double[] param) {
            return geom[0].getBoundary();
        }
    }

    private static class ConvexHullFunction
    extends GeometryFunction {
        public ConvexHullFunction() {
            super(I18N.getInstance().get("ui.plugin.analysis.GeometryFunction.Convex-Hull"), 1, 0);
        }

        @Override
        public Geometry execute(Geometry[] geom, double[] param) {
            ConvexHull hull = new ConvexHull(geom[0]);
            return hull.getConvexHull();
        }
    }

    private static class SimplifyVWFunction
    extends GeometryFunction {
        public SimplifyVWFunction() {
            super(I18N.getInstance().get("ui.plugin.analysis.GeometryFunction.Simplify-(Visvalingam-Whyatt)"), 1, 1, I18N.getInstance().get("ui.plugin.analysis.GeometryFunction.Simplifies-a-geometry-using-the-Visvalingam-Whyatt-algorithm"));
        }

        @Override
        public Geometry execute(Geometry[] geom, double[] param) {
            return VWSimplifier.simplify((Geometry)geom[0], (double)param[0]);
        }
    }

    private static class SimplifyTopologyFunction
    extends GeometryFunction {
        public SimplifyTopologyFunction() {
            super(I18N.getInstance().get("ui.plugin.analysis.GeometryFunction.Simplify-(preserve-topology)"), 1, 1);
        }

        @Override
        public Geometry execute(Geometry[] geom, double[] param) {
            return TopologyPreservingSimplifier.simplify((Geometry)geom[0], (double)param[0]);
        }
    }

    private static class SimplifyFunction
    extends GeometryFunction {
        public SimplifyFunction() {
            super(I18N.getInstance().get("ui.plugin.analysis.GeometryFunction.Simplify-(D-P)"), 1, 1, I18N.getInstance().get("ui.plugin.analysis.GeometryFunction.Simplifies-a-geometry-using-the-Douglas-Peucker-algorithm"));
        }

        @Override
        public Geometry execute(Geometry[] geom, double[] param) {
            return DouglasPeuckerSimplifier.simplify((Geometry)geom[0], (double)param[0]);
        }
    }

    private static class BufferFunction
    extends GeometryFunction {
        public BufferFunction() {
            super(I18N.getInstance().get("ui.plugin.analysis.GeometryFunction.buffer"), 1, 1);
        }

        @Override
        public Geometry execute(Geometry[] geom, double[] param) {
            return geom[0].buffer(param[0]);
        }
    }

    private static class InteriorPointFunction
    extends GeometryFunction {
        public InteriorPointFunction() {
            super(I18N.getInstance().get("ui.plugin.analysis.GeometryFunction.interior-point"), 1, 0);
        }

        @Override
        public Geometry execute(Geometry[] geom, double[] param) {
            return geom[0].getInteriorPoint();
        }
    }

    private static class CentroidFunction
    extends GeometryFunction {
        public CentroidFunction() {
            super(I18N.getInstance().get("ui.plugin.analysis.GeometryFunction.centroid-of-a"), 1, 0);
        }

        @Override
        public Geometry execute(Geometry[] geom, double[] param) {
            return geom[0].getCentroid();
        }
    }

    private static class FixedPrecisionSymDifferenceFunction
    extends GeometryFunction {
        public FixedPrecisionSymDifferenceFunction() {
            super(I18N.getInstance().get("ui.plugin.analysis.GeometryFunction.symetric-difference-fixed-precision"), 2, 1);
        }

        @Override
        public Geometry execute(Geometry[] geom, double[] param) {
            return OverlayNG.overlay((Geometry)geom[0], (Geometry)geom[1], (int)4, (PrecisionModel)new PrecisionModel(param[0]));
        }
    }

    private static class RobustSymDifferenceFunction
    extends GeometryFunction {
        public RobustSymDifferenceFunction() {
            super(I18N.getInstance().get("ui.plugin.analysis.GeometryFunction.symetric-difference-robust"), 2, 0);
        }

        @Override
        public Geometry execute(Geometry[] geom, double[] param) {
            return OverlayNGRobust.overlay((Geometry)geom[0], (Geometry)geom[1], (int)4);
        }
    }

    private static class SymDifferenceFunction
    extends GeometryFunction {
        public SymDifferenceFunction() {
            super(I18N.getInstance().get("ui.plugin.analysis.GeometryFunction.symetric-difference"), 2, 0);
        }

        @Override
        public Geometry execute(Geometry[] geom, double[] param) {
            return geom[0].symDifference(geom[1]);
        }
    }

    private static class FixedPrecisionDifferenceBAFunction
    extends GeometryFunction {
        public FixedPrecisionDifferenceBAFunction() {
            super(I18N.getInstance().get("ui.plugin.analysis.GeometryFunction.difference-b-a-fixed-precision"), 2, 1);
        }

        @Override
        public Geometry execute(Geometry[] geom, double[] param) {
            return OverlayNG.overlay((Geometry)geom[1], (Geometry)geom[0], (int)3, (PrecisionModel)new PrecisionModel(param[0]));
        }
    }

    private static class RobustDifferenceBAFunction
    extends GeometryFunction {
        public RobustDifferenceBAFunction() {
            super(I18N.getInstance().get("ui.plugin.analysis.GeometryFunction.difference-b-a-robust"), 2, 0);
        }

        @Override
        public Geometry execute(Geometry[] geom, double[] param) {
            return OverlayNGRobust.overlay((Geometry)geom[1], (Geometry)geom[0], (int)3);
        }
    }

    private static class DifferenceBAFunction
    extends GeometryFunction {
        public DifferenceBAFunction() {
            super(I18N.getInstance().get("ui.plugin.analysis.GeometryFunction.difference-b-a"), 2, 0);
        }

        @Override
        public Geometry execute(Geometry[] geom, double[] param) {
            return geom[1].difference(geom[0]);
        }
    }

    private static class FixedPrecisionDifferenceABFunction
    extends GeometryFunction {
        public FixedPrecisionDifferenceABFunction() {
            super(I18N.getInstance().get("ui.plugin.analysis.GeometryFunction.difference-a-b-fixed-precision"), 2, 1);
        }

        @Override
        public Geometry execute(Geometry[] geom, double[] param) {
            return OverlayNG.overlay((Geometry)geom[0], (Geometry)geom[1], (int)3, (PrecisionModel)new PrecisionModel(param[0]));
        }
    }

    private static class RobustDifferenceABFunction
    extends GeometryFunction {
        public RobustDifferenceABFunction() {
            super(I18N.getInstance().get("ui.plugin.analysis.GeometryFunction.difference-a-b-robust"), 2, 0);
        }

        @Override
        public Geometry execute(Geometry[] geom, double[] param) {
            return OverlayNGRobust.overlay((Geometry)geom[0], (Geometry)geom[1], (int)3);
        }
    }

    private static class DifferenceABFunction
    extends GeometryFunction {
        public DifferenceABFunction() {
            super(I18N.getInstance().get("ui.plugin.analysis.GeometryFunction.difference-a-b"), 2, 0);
        }

        @Override
        public Geometry execute(Geometry[] geom, double[] param) {
            return geom[0].difference(geom[1]);
        }
    }

    private static class FixedPrecisionUnionFunction
    extends GeometryFunction {
        public FixedPrecisionUnionFunction() {
            super(I18N.getInstance().get("ui.plugin.analysis.GeometryFunction.union-fixed-precision"), 2, 1);
        }

        @Override
        public Geometry execute(Geometry[] geom, double[] param) {
            return OverlayNG.overlay((Geometry)geom[0], (Geometry)geom[1], (int)2, (PrecisionModel)new PrecisionModel(param[0]));
        }
    }

    private static class RobustUnionFunction
    extends GeometryFunction {
        public RobustUnionFunction() {
            super(I18N.getInstance().get("ui.plugin.analysis.GeometryFunction.union-robust"), 2, 0);
        }

        @Override
        public Geometry execute(Geometry[] geom, double[] param) {
            return OverlayNGRobust.overlay((Geometry)geom[0], (Geometry)geom[1], (int)2);
        }
    }

    private static class UnionFunction
    extends GeometryFunction {
        public UnionFunction() {
            super(I18N.getInstance().get("ui.plugin.analysis.GeometryFunction.union"), 2, 0);
        }

        @Override
        public Geometry execute(Geometry[] geom, double[] param) {
            return geom[0].union(geom[1]);
        }
    }

    private static class FixedPrecisionIntersectionFunction
    extends GeometryFunction {
        public FixedPrecisionIntersectionFunction() {
            super(I18N.getInstance().get("ui.plugin.analysis.GeometryFunction.intersection-fixed-precision"), 2, 1);
        }

        @Override
        public Geometry execute(Geometry[] geom, double[] param) {
            return OverlayNG.overlay((Geometry)geom[0], (Geometry)geom[1], (int)1, (PrecisionModel)new PrecisionModel(param[0]));
        }
    }

    private static class RobustIntersectionFunction
    extends GeometryFunction {
        public RobustIntersectionFunction() {
            super(I18N.getInstance().get("ui.plugin.analysis.GeometryFunction.intersection-robust"), 2, 0);
        }

        @Override
        public Geometry execute(Geometry[] geom, double[] param) {
            return OverlayNGRobust.overlay((Geometry)geom[0], (Geometry)geom[1], (int)1);
        }
    }

    private static class IntersectionFunction
    extends GeometryFunction {
        public IntersectionFunction() {
            super(I18N.getInstance().get("ui.plugin.analysis.GeometryFunction.intersection"), 2, 0);
        }

        @Override
        public Geometry execute(Geometry[] geom, double[] param) {
            return geom[0].intersection(geom[1]);
        }
    }
}

