/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.analysis;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.AttributeType;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.feature.FeatureDataset;
import com.vividsolutions.jump.feature.FeatureDatasetFactory;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.feature.FeatureUtil;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.StandardCategoryNames;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.Macro;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.AttributeTypeFilter;
import com.vividsolutions.jump.workbench.ui.EditTransaction;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import com.vividsolutions.jump.workbench.ui.MultiInputDialog;
import com.vividsolutions.jump.workbench.ui.MultiTabInputDialog;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import com.vividsolutions.jump.workbench.ui.plugin.clipboard.PasteItemsPlugIn;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.operation.buffer.BufferOp;
import org.locationtech.jts.operation.buffer.BufferParameters;
import org.locationtech.jts.operation.union.UnaryUnionOp;
import org.locationtech.jts.simplify.DouglasPeuckerSimplifier;
import org.openjump.core.ui.plugin.AbstractThreadedUiPlugIn;

public class BufferPlugIn
extends AbstractThreadedUiPlugIn {
    private static final int LEFT = 1;
    private static final int RIGHT = 2;
    private String MAIN_OPTIONS;
    private String PROCESSED_DATA;
    private String LAYER;
    private String SELECTION;
    private String SELECTION_HELP;
    private String UPDATE_SOURCE;
    private String UPDATE_SOURCE_HELP;
    private String DISTANCE;
    private String FIXED_DISTANCE;
    private String ATTRIBUTE;
    private String FROM_ATTRIBUTE;
    private String ATTRIBUTE_TOOLTIP;
    private String OTHER_OPTIONS;
    private String QUADRANT_SEGMENTS;
    private String UNION_RESULT;
    private String COPY_ATTRIBUTES;
    private String ADVANCED_OPTIONS;
    private String END_CAP_STYLE;
    private String S_CAP_FLAT = I18N.getInstance().get("ui.plugin.analysis.BufferPlugIn.cap-flat");
    private String S_CAP_ROUND = I18N.getInstance().get("ui.plugin.analysis.BufferPlugIn.cap-round");
    private String S_CAP_SQUARE = I18N.getInstance().get("ui.plugin.analysis.BufferPlugIn.cap-square");
    private String JOIN_STYLE;
    private String S_JOIN_BEVEL = I18N.getInstance().get("ui.plugin.analysis.BufferPlugIn.join-bevel");
    private String S_JOIN_MITRE = I18N.getInstance().get("ui.plugin.analysis.BufferPlugIn.join-mitre");
    private String S_JOIN_ROUND = I18N.getInstance().get("ui.plugin.analysis.BufferPlugIn.join-round");
    private String S_FEATURES_PROCESSED = I18N.getInstance().get("jump.features-processed");
    private String MITRE_LIMIT;
    private String LEFT_SINGLE_SIDED;
    private String RIGHT_SINGLE_SIDED;
    private List endCapStyles;
    private List joinStyles;
    private static final String P_LAYER_NAME = "LayerName";
    private static final String P_USE_SELECTION = "UseSelection";
    private static final String P_UPDATE_SOURCE = "UpdateSource";
    private static final String P_DISTANCE = "Distance";
    private static final String P_QUADRANT_SEGMENTS = "QuadrantSegments";
    private static final String P_END_CAP_STYLE = "EndCapStyle";
    private static final String P_JOIN_STYLE = "JoinStyle";
    private static final String P_MITRE_LIMIT = "MitreLimit";
    private static final String P_LEFT_SINGLE_SIDED = "LeftSingleSided";
    private static final String P_RIGHT_SINGLE_SIDED = "RightSingleSided";
    private static final String P_UNION_RESULT = "UnionResult";
    private static final String P_COPY_ATTRIBUTE = "CopyAttribute";
    private static final String P_FROM_ATTRIBUTE = "FromAttribute";
    private static final String P_ATTRIBUTE_INDEX = "AttributeIndex";

    private int encodeCapStyle(String value) {
        if (value.equalsIgnoreCase(this.S_CAP_ROUND)) {
            return 1;
        }
        if (value.equalsIgnoreCase(this.S_CAP_FLAT)) {
            return 2;
        }
        if (value.equalsIgnoreCase(this.S_CAP_SQUARE)) {
            return 3;
        }
        return -1;
    }

    private String decodeCapStyle(int value) {
        if (value == 1) {
            return this.S_CAP_ROUND;
        }
        if (value == 2) {
            return this.S_CAP_FLAT;
        }
        if (value == 3) {
            return this.S_CAP_SQUARE;
        }
        return "Unknown";
    }

    private int encodeJoinStyle(String value) {
        if (value.equalsIgnoreCase(this.S_JOIN_ROUND)) {
            return 1;
        }
        if (value.equalsIgnoreCase(this.S_JOIN_MITRE)) {
            return 2;
        }
        if (value.equalsIgnoreCase(this.S_JOIN_BEVEL)) {
            return 3;
        }
        return -1;
    }

    private String decodeJoinStyle(int value) {
        if (value == 1) {
            return this.S_JOIN_ROUND;
        }
        if (value == 2) {
            return this.S_JOIN_MITRE;
        }
        if (value == 3) {
            return this.S_JOIN_BEVEL;
        }
        return "Unknown";
    }

    public BufferPlugIn() {
        super(I18N.getInstance().get("com.vividsolutions.jump.workbench.ui.plugin.analysis.BufferPlugIn") + "...", IconLoader.icon("buffer.gif"));
        this.addParameter(P_USE_SELECTION, false);
        this.addParameter(P_UPDATE_SOURCE, false);
        this.addParameter(P_DISTANCE, 1.0);
        this.addParameter(P_QUADRANT_SEGMENTS, 8);
        this.addParameter(P_END_CAP_STYLE, 1);
        this.addParameter(P_JOIN_STYLE, 1);
        this.addParameter(P_MITRE_LIMIT, 1.0);
        this.addParameter(P_LEFT_SINGLE_SIDED, false);
        this.addParameter(P_RIGHT_SINGLE_SIDED, false);
        this.addParameter(P_UNION_RESULT, false);
        this.addParameter(P_COPY_ATTRIBUTE, true);
        this.addParameter(P_FROM_ATTRIBUTE, false);
        this.addParameter(P_ATTRIBUTE_INDEX, -1);
    }

    @Override
    public void initialize(PlugInContext context) throws Exception {
        context.getFeatureInstaller().addMainMenuPlugin(this, new String[]{MenuNames.TOOLS, MenuNames.TOOLS_ANALYSIS}, this.getName(), false, this.getIcon(), BufferPlugIn.createEnableCheck(context.getWorkbenchContext()));
    }

    public static MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerNamePanelMustBeActiveCheck()).add(checkFactory.createAtLeastNLayersMustExistCheck(1));
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        this.MAIN_OPTIONS = I18N.getInstance().get("ui.plugin.analysis.BufferPlugIn.main-options");
        this.PROCESSED_DATA = I18N.getInstance().get("ui.plugin.analysis.BufferPlugIn.processed-data");
        this.LAYER = I18N.getInstance().get("ui.plugin.analysis.BufferPlugIn.layer");
        this.SELECTION = I18N.getInstance().get("ui.plugin.analysis.BufferPlugIn.selection");
        this.SELECTION_HELP = I18N.getInstance().get("ui.plugin.analysis.BufferPlugIn.selection-help");
        this.UPDATE_SOURCE = I18N.getInstance().get("ui.plugin.analysis.BufferPlugIn.update-source");
        this.UPDATE_SOURCE_HELP = I18N.getInstance().get("ui.plugin.analysis.BufferPlugIn.update-source-help");
        this.DISTANCE = I18N.getInstance().get("ui.plugin.analysis.BufferPlugIn.distance");
        this.FIXED_DISTANCE = I18N.getInstance().get("ui.plugin.analysis.BufferPlugIn.fixed-distance");
        this.FROM_ATTRIBUTE = I18N.getInstance().get("ui.plugin.analysis.BufferPlugIn.get-distance-from-attribute-value");
        this.ATTRIBUTE = I18N.getInstance().get("ui.plugin.analysis.BufferPlugIn.attribute-to-use");
        this.ATTRIBUTE_TOOLTIP = I18N.getInstance().get("ui.plugin.analysis.BufferPlugIn.attribute-to-use-tooltip");
        this.OTHER_OPTIONS = I18N.getInstance().get("ui.plugin.analysis.BufferPlugIn.other-options");
        this.QUADRANT_SEGMENTS = I18N.getInstance().get("org.openjump.core.ui.plugin.edittoolbox.cursortools.DrawCircleWithGivenRadiusTool.Number-of-segments-per-circle-quarter");
        this.UNION_RESULT = I18N.getInstance().get("ui.plugin.analysis.UnionPlugIn.union");
        this.COPY_ATTRIBUTES = I18N.getInstance().get("ui.plugin.analysis.BufferPlugIn.preserve-attributes");
        this.ADVANCED_OPTIONS = I18N.getInstance().get("ui.plugin.analysis.BufferPlugIn.advanced-options");
        this.END_CAP_STYLE = I18N.getInstance().get("ui.plugin.analysis.BufferPlugIn.end-cap-style");
        this.JOIN_STYLE = I18N.getInstance().get("ui.plugin.analysis.BufferPlugIn.join-style");
        this.MITRE_LIMIT = I18N.getInstance().get("ui.plugin.analysis.BufferPlugIn.mitre-join-limit");
        this.LEFT_SINGLE_SIDED = I18N.getInstance().get("ui.plugin.analysis.BufferPlugIn.left-single-sided");
        this.RIGHT_SINGLE_SIDED = I18N.getInstance().get("ui.plugin.analysis.BufferPlugIn.right-single-sided");
        this.S_FEATURES_PROCESSED = I18N.getInstance().get("jump.features-processed");
        this.endCapStyles = new ArrayList();
        this.endCapStyles.add(this.S_CAP_FLAT);
        this.endCapStyles.add(this.S_CAP_ROUND);
        this.endCapStyles.add(this.S_CAP_SQUARE);
        this.joinStyles = new ArrayList();
        this.joinStyles.add(this.S_JOIN_BEVEL);
        this.joinStyles.add(this.S_JOIN_MITRE);
        this.joinStyles.add(this.S_JOIN_ROUND);
        MultiTabInputDialog dialog = new MultiTabInputDialog((Frame)context.getWorkbenchFrame(), this.getName(), this.MAIN_OPTIONS, true);
        int n = context.getLayerViewPanel().getSelectionManager().getFeaturesWithSelectedItems().size();
        boolean useSelection = n > 0;
        String sideBarText = useSelection ? this.SELECTION : I18N.getInstance().get("ui.plugin.analysis.BufferPlugIn.buffers-all-geometries-in-the-input-layer");
        dialog.setSideBarDescription(sideBarText);
        this.addParameter(P_USE_SELECTION, useSelection);
        this.setDialogValues(dialog, context, useSelection);
        this.updateControls(context, dialog, useSelection);
        GUIUtil.centreOnWindow(dialog);
        dialog.setVisible(true);
        if (!dialog.wasOKPressed()) {
            return false;
        }
        this.getDialogValues(dialog, useSelection);
        return true;
    }

    @Override
    public void run(TaskMonitor monitor, PlugInContext context) throws Exception {
        FeatureDataset inputFD;
        Collection<Feature> inputC;
        Layer layer = context.getLayerManager().getLayer((String)this.getParameter(P_LAYER_NAME));
        if (layer == null && context.getLayerNamePanel().getSelectedLayers().length > 0) {
            layer = context.getLayerNamePanel().getSelectedLayers()[0];
        }
        if (layer == null && context.getLayerManager().getLayers().size() > 0) {
            layer = context.getLayerManager().getLayer(0);
        }
        FeatureSchema featureSchema = new FeatureSchema();
        featureSchema.addAttribute("GEOMETRY", AttributeType.GEOMETRY);
        if (((Boolean)this.getParameter(P_USE_SELECTION)).booleanValue()) {
            inputC = context.getLayerViewPanel().getSelectionManager().getFeaturesWithSelectedItems();
            if (!((Boolean)this.getParameter(P_UPDATE_SOURCE)).booleanValue()) {
                Feature feature = inputC.iterator().next();
                featureSchema = feature.getSchema();
                inputC = PasteItemsPlugIn.conform(inputC, featureSchema);
            }
        } else {
            inputC = layer.getFeatureCollectionWrapper().getFeatures();
            featureSchema = layer.getFeatureCollectionWrapper().getFeatureSchema();
        }
        if ((inputFD = new FeatureDataset(inputC, featureSchema)).isEmpty()) {
            context.getWorkbenchFrame().warnUser(I18N.getInstance().get("ui.plugin.analysis.BufferPlugIn.empty-result-set"));
            return;
        }
        Map<Integer, Geometry> resultMap = this.runBuffer(monitor, context, inputFD);
        if (((Boolean)this.getParameters().get(P_UPDATE_SOURCE)).booleanValue()) {
            this.updateSourceLayer(monitor, context, layer, inputFD, resultMap);
        } else {
            this.createNewLayer(monitor, context, inputFD, resultMap, featureSchema);
        }
        if (context.getWorkbenchContext().getBlackboard().get("MacroStarted", false)) {
            ((Macro)context.getWorkbenchContext().getBlackboard().get("Macro")).addProcess(this);
        }
    }

    private void createNewLayer(TaskMonitor monitor, PlugInContext context, FeatureCollection inputFD, Map<Integer, Geometry> resultMap, FeatureSchema featureSchema) {
        FeatureCollection resultFC = new FeatureDataset(featureSchema);
        if (((Boolean)this.getParameter(P_COPY_ATTRIBUTE)).booleanValue()) {
            FeatureDataset resultFeatureColl = new FeatureDataset(featureSchema);
            for (Feature sourceFeature : inputFD) {
                Geometry gResult = resultMap.get(sourceFeature.getID());
                if (gResult != null && !gResult.isEmpty()) {
                    Feature newFeature = sourceFeature.clone(false);
                    newFeature.setGeometry(gResult);
                    resultFeatureColl.add(newFeature);
                }
                if (!monitor.isCancelRequested()) continue;
                break;
            }
            resultFC = resultFeatureColl;
        } else {
            resultFC = FeatureDatasetFactory.createFromGeometry(resultMap.values());
        }
        if (((Boolean)this.getParameter(P_UNION_RESULT)).booleanValue()) {
            monitor.report(I18N.getInstance().get("ui.plugin.analysis.BufferPlugIn.union-buffered-features"));
            List<Geometry> geoms = FeatureUtil.toGeometries(resultFC.getFeatures());
            Geometry g = UnaryUnionOp.union(geoms);
            geoms.clear();
            if (g != null && !g.isEmpty()) {
                geoms.add(g);
            }
            resultFC = FeatureDatasetFactory.createFromGeometry(geoms);
        }
        if (resultFC.isEmpty()) {
            context.getWorkbenchFrame().warnUser(I18N.getInstance().get("ui.plugin.analysis.BufferPlugIn.empty-result-set"));
            return;
        }
        context.getLayerManager().addCategory(StandardCategoryNames.RESULT);
        String name = (Boolean)this.getParameter(P_USE_SELECTION) == false ? (String)this.getParameter(P_LAYER_NAME) : I18N.getInstance().get("ui.MenuNames.SELECTION");
        name = I18N.getInstance().get("com.vividsolutions.jump.workbench.ui.plugin.analysis.BufferPlugIn") + "-" + name;
        context.addLayer(StandardCategoryNames.RESULT, name, resultFC);
    }

    private void updateSourceLayer(TaskMonitor monitor, PlugInContext context, Layer layer, FeatureCollection input, Map<Integer, Geometry> map) {
        EditTransaction transaction = new EditTransaction(new LinkedHashSet<Feature>(), "Buffer", layer, true, true, context.getLayerViewPanel().getContext());
        for (Feature feature : input) {
            Geometry newGeometry = map.get(feature.getID());
            transaction.modifyFeatureGeometry(feature, newGeometry);
        }
        transaction.commit();
    }

    private Map<Integer, Geometry> runBuffer(TaskMonitor monitor, PlugInContext context, FeatureCollection fcA) throws Exception {
        int quadrantSegments = (Integer)this.getParameter(P_QUADRANT_SEGMENTS);
        int endCapStyleCode = (Integer)this.getParameter(P_END_CAP_STYLE);
        int joinStyleCode = (Integer)this.getParameter(P_JOIN_STYLE);
        double mitreLimit = (Double)this.getParameter(P_MITRE_LIMIT);
        boolean leftSingleSided = (Boolean)this.getParameter(P_LEFT_SINGLE_SIDED);
        boolean rightSingleSided = (Boolean)this.getParameter(P_RIGHT_SINGLE_SIDED);
        double bufferDistance = (Double)this.getParameter(P_DISTANCE);
        boolean fromAttribute = (Boolean)this.getParameter(P_FROM_ATTRIBUTE);
        int attributeIndex = (Integer)this.getParameter(P_ATTRIBUTE_INDEX);
        int total = fcA.size();
        int count = 0;
        HashMap<Integer, Geometry> map = new HashMap<Integer, Geometry>(fcA.size());
        BufferParameters bufferParameters = new BufferParameters(quadrantSegments, endCapStyleCode, joinStyleCode, mitreLimit);
        bufferParameters.setSingleSided(leftSingleSided || rightSingleSided);
        int side = 0;
        if (leftSingleSided) {
            ++side;
        }
        if (rightSingleSided) {
            side += 2;
        }
        Iterator<Feature> ia = fcA.iterator();
        while (ia.hasNext()) {
            monitor.report(count++, total, this.S_FEATURES_PROCESSED);
            if (monitor.isCancelRequested()) break;
            Feature fa = ia.next();
            Geometry ga = fa.getGeometry();
            if (fromAttribute) {
                Object o = fa.getAttribute(attributeIndex);
                if (o instanceof Double) {
                    bufferDistance = (Double)o;
                } else if (o instanceof Integer) {
                    bufferDistance = ((Integer)o).doubleValue();
                }
            }
            try {
                Geometry result;
                if (side == 0) {
                    result = this.runBuffer(ga, bufferParameters, 0, bufferDistance);
                    map.put(fa.getID(), result);
                }
                if (side == 1) {
                    result = this.runBuffer(ga, bufferParameters, 1, bufferDistance);
                    map.put(fa.getID(), result);
                }
                if (side == 2) {
                    result = this.runBuffer(ga, bufferParameters, 2, bufferDistance);
                    map.put(fa.getID(), result);
                }
                if (side != 3) continue;
                Geometry left = this.runBuffer(ga, bufferParameters, 1, bufferDistance);
                Geometry right = this.runBuffer(ga, bufferParameters, 2, bufferDistance);
                map.put(fa.getID(), (Geometry)left.getFactory().createGeometryCollection(new Geometry[]{left, right}));
            }
            catch (Exception e) {
                String errorMessage = I18N.getInstance().get("ui.plugin.analysis.BufferPlugIn.error-found", fa.getID(), ga.getCoordinate().x, ga.getCoordinate().x);
                context.getWorkbenchFrame().warnUser(errorMessage);
                throw new Exception(errorMessage, e);
            }
        }
        return map;
    }

    private Geometry runBuffer(Geometry a, BufferParameters param, int side, double bufferDistance) throws Exception {
        a = DouglasPeuckerSimplifier.simplify((Geometry)a, (double)0.0);
        BufferOp bufOp = new BufferOp(a, param);
        Geometry result = side == 1 && bufferDistance < 0.0 || side == 2 && bufferDistance > 0.0 ? bufOp.getResultGeometry(-bufferDistance) : bufOp.getResultGeometry(bufferDistance);
        return result;
    }

    private void setDialogValues(final MultiTabInputDialog dialog, final PlugInContext context, final boolean useSelection) {
        try {
            this.updateIcon(dialog);
        }
        catch (Exception exception) {
            // empty catch block
        }
        dialog.addSubTitle(this.PROCESSED_DATA);
        final JComboBox<Layer> layerComboBox = dialog.addLayerComboBox(this.LAYER, context.getCandidateLayer(0), context.getLayerManager());
        dialog.addLabel(this.SELECTION);
        dialog.addLabel(this.SELECTION_HELP);
        JCheckBox updateCheckBox = dialog.addCheckBox(this.UPDATE_SOURCE, (Boolean)this.getParameter(P_UPDATE_SOURCE), this.UPDATE_SOURCE_HELP);
        dialog.addSeparator();
        dialog.addSubTitle(this.DISTANCE);
        JTextField bufferDistanceTextField = dialog.addDoubleField(this.FIXED_DISTANCE, (Double)this.getParameter(P_DISTANCE), 10, null);
        JCheckBox fromAttributeCheckBox = dialog.addCheckBox(this.FROM_ATTRIBUTE, false, this.ATTRIBUTE_TOOLTIP);
        JComboBox<String> attributeComboBox = dialog.addAttributeComboBox(this.ATTRIBUTE, this.LAYER, AttributeTypeFilter.NUMERIC_FILTER, this.ATTRIBUTE_TOOLTIP);
        dialog.addSeparator();
        dialog.addSubTitle(this.OTHER_OPTIONS);
        JTextField quadrantSegmentsIntegerField = dialog.addIntegerField(this.QUADRANT_SEGMENTS, (Integer)this.getParameter(P_QUADRANT_SEGMENTS), 3, null);
        JCheckBox unionCheckBox = dialog.addCheckBox(this.UNION_RESULT, (Boolean)this.getParameter(P_UNION_RESULT));
        JCheckBox copyAttributesCheckBox = dialog.addCheckBox(this.COPY_ATTRIBUTES, (Boolean)this.getParameter(P_COPY_ATTRIBUTE));
        dialog.addPane(this.ADVANCED_OPTIONS);
        JComboBox<String> endCapComboBox = dialog.addComboBox(this.END_CAP_STYLE, this.decodeCapStyle((Integer)this.getParameter(P_END_CAP_STYLE)), this.endCapStyles, null);
        dialog.addSeparator();
        JComboBox<String> joinStyleComboBox = dialog.addComboBox(this.JOIN_STYLE, this.decodeJoinStyle((Integer)this.getParameter(P_JOIN_STYLE)), this.joinStyles, null);
        JTextField mitreLimitTextField = dialog.addDoubleField(this.MITRE_LIMIT, (Double)this.getParameter(P_MITRE_LIMIT), 10, null);
        dialog.addSeparator();
        JCheckBox leftSingleSidedCheckBox = dialog.addCheckBox(this.LEFT_SINGLE_SIDED, (Boolean)this.getParameter(P_LEFT_SINGLE_SIDED));
        JCheckBox rightSingleSidedCheckBox = dialog.addCheckBox(this.RIGHT_SINGLE_SIDED, (Boolean)this.getParameter(P_RIGHT_SINGLE_SIDED));
        dialog.addRow(new JPanel());
        mitreLimitTextField.setEnabled((Integer)this.getParameter(P_JOIN_STYLE) == 2);
        quadrantSegmentsIntegerField.setEnabled((Integer)this.getParameter(P_END_CAP_STYLE) == 1 || (Integer)this.getParameter(P_JOIN_STYLE) == 1);
        endCapComboBox.setEnabled((Boolean)this.getParameter(P_LEFT_SINGLE_SIDED) == false && (Boolean)this.getParameter(P_RIGHT_SINGLE_SIDED) == false);
        copyAttributesCheckBox.setEnabled((Boolean)this.getParameter(P_UNION_RESULT) == false);
        this.updateIcon(dialog);
        layerComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (ActionListener listener : layerComboBox.getActionListeners()) {
                    if (listener == this) continue;
                    listener.actionPerformed(e);
                }
                BufferPlugIn.this.updateControls(context, dialog, useSelection);
            }
        });
        updateCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BufferPlugIn.this.updateControls(context, dialog, useSelection);
            }
        });
        fromAttributeCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BufferPlugIn.this.updateControls(context, dialog, useSelection);
            }
        });
        unionCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BufferPlugIn.this.updateControls(context, dialog, useSelection);
            }
        });
        endCapComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BufferPlugIn.this.updateControls(context, dialog, useSelection);
            }
        });
        joinStyleComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BufferPlugIn.this.updateControls(context, dialog, useSelection);
            }
        });
        leftSingleSidedCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BufferPlugIn.this.updateControls(context, dialog, useSelection);
            }
        });
        rightSingleSidedCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BufferPlugIn.this.updateControls(context, dialog, useSelection);
            }
        });
    }

    private void getDialogValues(MultiInputDialog dialog, boolean useSelection) {
        int attributeIndex;
        Layer layer = null;
        if (!useSelection) {
            layer = dialog.getLayer(this.LAYER);
        }
        boolean updateSource = dialog.getBoolean(this.UPDATE_SOURCE);
        double bufferDistance = dialog.getDouble(this.FIXED_DISTANCE);
        int endCapStyleCode = this.encodeCapStyle(dialog.getText(this.END_CAP_STYLE));
        int quadrantSegments = dialog.getInteger(this.QUADRANT_SEGMENTS);
        int joinStyleCode = this.encodeJoinStyle(dialog.getText(this.JOIN_STYLE));
        double mitreLimit = dialog.getDouble(this.MITRE_LIMIT);
        boolean leftSingleSided = dialog.getBoolean(this.LEFT_SINGLE_SIDED);
        boolean rightSingleSided = dialog.getBoolean(this.RIGHT_SINGLE_SIDED);
        boolean unionResult = dialog.getBoolean(this.UNION_RESULT);
        boolean copyAttributes = dialog.getBoolean(this.COPY_ATTRIBUTES);
        boolean fromAttribute = this.getParameter(P_FROM_ATTRIBUTE) != null ? (Boolean)this.getParameter(P_FROM_ATTRIBUTE) : false;
        int n = attributeIndex = this.getParameter(P_ATTRIBUTE_INDEX) != null ? (Integer)this.getParameter(P_ATTRIBUTE_INDEX) : -1;
        if (!useSelection) {
            boolean hasNumericAttributes = AttributeTypeFilter.NUMERIC_FILTER.filter(layer.getFeatureCollectionWrapper().getFeatureSchema()).size() > 0;
            fromAttribute = dialog.getBoolean(this.FROM_ATTRIBUTE);
            if (fromAttribute && dialog.getCheckBox(this.FROM_ATTRIBUTE).isEnabled() && hasNumericAttributes) {
                FeatureSchema schema = layer.getFeatureCollectionWrapper().getFeatureSchema();
                String attributeName = dialog.getText(this.ATTRIBUTE);
                attributeIndex = schema.getAttributeIndex(attributeName);
            } else {
                dialog.getCheckBox(this.FROM_ATTRIBUTE).setSelected(false);
                fromAttribute = false;
            }
        }
        this.addParameter(P_USE_SELECTION, useSelection);
        this.addParameter(P_UPDATE_SOURCE, updateSource);
        this.addParameter(P_DISTANCE, bufferDistance);
        this.addParameter(P_LAYER_NAME, useSelection ? null : layer.getName());
        this.addParameter(P_QUADRANT_SEGMENTS, quadrantSegments);
        this.addParameter(P_END_CAP_STYLE, endCapStyleCode);
        this.addParameter(P_JOIN_STYLE, joinStyleCode);
        this.addParameter(P_MITRE_LIMIT, mitreLimit);
        this.addParameter(P_LEFT_SINGLE_SIDED, leftSingleSided);
        this.addParameter(P_RIGHT_SINGLE_SIDED, rightSingleSided);
        this.addParameter(P_UNION_RESULT, unionResult);
        this.addParameter(P_COPY_ATTRIBUTE, copyAttributes);
        this.addParameter(P_FROM_ATTRIBUTE, fromAttribute);
        this.addParameter(P_ATTRIBUTE_INDEX, attributeIndex);
    }

    private Feature combine(Collection originalFeatures) {
        GeometryFactory factory = new GeometryFactory();
        Feature feature = ((Feature)originalFeatures.iterator().next()).clone();
        feature.setGeometry((Geometry)factory.createGeometryCollection(FeatureUtil.toGeometries(originalFeatures).toArray(new Geometry[originalFeatures.size()])));
        return feature;
    }

    protected void updateControls(PlugInContext context, MultiInputDialog dialog, boolean useSelection) {
        this.getDialogValues(dialog, useSelection);
        this.updateIcon(dialog);
        boolean hasNumericAttributes = !useSelection && AttributeTypeFilter.NUMERIC_FILTER.filter(context.getLayerManager().getLayer((String)this.getParameter(P_LAYER_NAME)).getFeatureCollectionWrapper().getFeatureSchema()).size() > 0;
        dialog.setFieldVisible(this.LAYER, !useSelection);
        dialog.setFieldVisible(this.SELECTION, useSelection);
        dialog.setFieldVisible(this.UPDATE_SOURCE, useSelection);
        dialog.setFieldVisible(this.SELECTION_HELP, useSelection);
        dialog.setFieldEnabled(this.FIXED_DISTANCE, useSelection || (Boolean)this.getParameter(P_FROM_ATTRIBUTE) == false || !hasNumericAttributes);
        dialog.setFieldEnabled(this.FROM_ATTRIBUTE, !useSelection && hasNumericAttributes);
        dialog.setFieldEnabled(this.ATTRIBUTE, !useSelection && (Boolean)this.getParameter(P_FROM_ATTRIBUTE) != false && hasNumericAttributes);
        dialog.setFieldEnabled(this.COPY_ATTRIBUTES, (Boolean)this.getParameter(P_UNION_RESULT) == false && (Boolean)this.getParameter(P_UPDATE_SOURCE) == false);
        dialog.setFieldEnabled(this.UNION_RESULT, (Boolean)this.getParameter(P_UPDATE_SOURCE) == false);
        dialog.setFieldEnabled(this.QUADRANT_SEGMENTS, (Integer)this.getParameter(P_END_CAP_STYLE) == 1 || (Integer)this.getParameter(P_JOIN_STYLE) == 1);
        dialog.setFieldEnabled(this.MITRE_LIMIT, (Integer)this.getParameter(P_JOIN_STYLE) == 2);
        dialog.setFieldEnabled(this.END_CAP_STYLE, (Boolean)this.getParameter(P_LEFT_SINGLE_SIDED) == false && (Boolean)this.getParameter(P_RIGHT_SINGLE_SIDED) == false);
    }

    private void updateIcon(MultiInputDialog dialog) {
        boolean notSingleSided;
        StringBuffer fileName = new StringBuffer("Buffer");
        if (((Boolean)this.getParameter(P_UNION_RESULT)).booleanValue()) {
            fileName.append("Union");
        }
        if (((Boolean)this.getParameter(P_LEFT_SINGLE_SIDED)).booleanValue() || ((Boolean)this.getParameter(P_RIGHT_SINGLE_SIDED)).booleanValue()) {
            fileName.append("SingleSided");
        }
        boolean bl = notSingleSided = (Boolean)this.getParameter(P_LEFT_SINGLE_SIDED) == false && (Boolean)this.getParameter(P_RIGHT_SINGLE_SIDED) == false;
        if (notSingleSided && (Integer)this.getParameter(P_END_CAP_STYLE) == 2) {
            fileName.append("Flat");
        } else if (notSingleSided && (Integer)this.getParameter(P_END_CAP_STYLE) == 1) {
            fileName.append("Round");
        } else if (notSingleSided && (Integer)this.getParameter(P_END_CAP_STYLE) == 3) {
            fileName.append("Square");
        }
        if ((Integer)this.getParameter(P_JOIN_STYLE) == 3) {
            fileName.append("Bevel");
        } else if ((Integer)this.getParameter(P_JOIN_STYLE) == 1) {
            fileName.append("Round");
        } else if ((Integer)this.getParameter(P_JOIN_STYLE) == 2) {
            fileName.append("Mitre");
        }
        dialog.setSideBarImage(new ImageIcon(IconLoader.image(fileName.toString() + ".png").getScaledInstance(172, 127, 4)));
    }
}

