/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin;

import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.FenceLayerFinder;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.LayerNamePanel;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.locationtech.jts.geom.Geometry;

public class SelectFeaturesInFencePlugIn
extends AbstractPlugIn {
    @Override
    public void initialize(PlugInContext context) throws Exception {
        super.initialize(context);
        context.getFeatureInstaller().addMainMenuPlugin(this, new String[]{MenuNames.EDIT, MenuNames.SELECTION}, this.getName(), false, null, SelectFeaturesInFencePlugIn.createEnableCheck(context.getWorkbenchContext()));
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        this.reportNothingToUndoYet(context);
        context.getLayerViewPanel().getSelectionManager().clear();
        SelectFeaturesInFencePlugIn.execute(context.getLayerViewPanel(), context.getLayerNamePanel(), context.getLayerViewPanel().getFence(), true, false);
        return true;
    }

    public static void execute(LayerViewPanel layerViewPanel, LayerNamePanel layerNamePanel, Geometry fence, boolean skipUnselectedLayers, boolean mentionModifierHelp) {
        List<Layer> selectedLayers = Arrays.asList(layerNamePanel.getSelectedLayers());
        Map<Layer, Set<Feature>> layerToFeaturesInFenceMap = layerViewPanel.visibleLayerToFeaturesInFenceMap(fence);
        for (Layer layer : layerToFeaturesInFenceMap.keySet()) {
            if (layer == new FenceLayerFinder(layerViewPanel).getLayer() || skipUnselectedLayers && !selectedLayers.contains(layer)) continue;
            layerViewPanel.getSelectionManager().getFeatureSelection().selectItems(layer, layerToFeaturesInFenceMap.get(layer));
        }
    }

    public static MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerViewPanelMustBeActiveCheck()).add(checkFactory.createFenceMustBeDrawnCheck()).add(checkFactory.createAtLeastNLayersMustBeSelectedCheck(1));
    }
}

