/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.HTMLPanel;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import com.vividsolutions.jump.workbench.ui.plugin.FeatureInstaller;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.Polygon;
import org.openjump.sextante.gui.additionalResults.AdditionalResults;

public class LayerStatisticsPlugIn
extends AbstractPlugIn {
    @Override
    public void initialize(PlugInContext context) throws Exception {
        super.initialize(context);
        FeatureInstaller featureInstaller = context.getFeatureInstaller();
        featureInstaller.addMainMenuPlugin(this, new String[]{MenuNames.TOOLS, MenuNames.STATISTICS}, this.getName() + "...", false, null, LayerStatisticsPlugIn.createEnableCheck(context.getWorkbenchContext()));
    }

    public static MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerNamePanelMustBeActiveCheck()).add(checkFactory.createAtLeastNLayersMustBeSelectedCheck(1));
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        Layer[] selectedLayers = context.getSelectedLayers();
        HTMLPanel out = new HTMLPanel();
        out.setRecordNavigationControlVisible(false);
        out.createNewDocument();
        out.addHeader(1, I18N.getInstance().get("ui.plugin.LayerStatisticsPlugIn.layer-statistics"));
        LayerStatistics totalStats = new LayerStatistics();
        Envelope totalEnv = new Envelope();
        for (Layer layer : selectedLayers) {
            LayerStatistics ls = this.layerStatistics(layer, totalStats);
            out.addHeader(2, I18N.getInstance().get("ui.plugin.LayerStatisticsPlugIn.layer") + " " + layer.getName());
            Envelope layerEnv = layer.getFeatureCollectionWrapper().getEnvelope();
            out.addField(I18N.getInstance().get("ui.plugin.LayerStatisticsPlugIn.envelope"), layerEnv.toString());
            totalEnv.expandToInclude(layerEnv);
            this.output(ls, out);
        }
        if (selectedLayers.length > 1) {
            out.addHeader(2, I18N.getInstance().get("ui.plugin.LayerStatisticsPlugIn.summary-for-all-layers"));
            out.addField(I18N.getInstance().get("ui.plugin.LayerStatisticsPlugIn.envelope"), totalEnv.toString());
            this.output(totalStats, out);
        }
        AdditionalResults.addAdditionalResultAndShow(this.getName(), out);
        return true;
    }

    private LayerStatistics layerStatistics(Layer layer, LayerStatistics totalStats) {
        LayerStatistics ls = new LayerStatistics();
        for (Feature f : layer.getFeatureCollectionWrapper()) {
            Geometry g = f.getGeometry();
            double area = g.getArea();
            double length = g.getLength();
            int[] comps_and_holes = new int[]{0, 0};
            comps_and_holes = this.recurse(g, comps_and_holes);
            int comps = comps_and_holes[0];
            int holes = comps_and_holes[1];
            Coordinate[] pts = g.getCoordinates();
            ls.addFeature(pts.length, holes, comps, area, length);
            totalStats.addFeature(pts.length, holes, comps, area, length);
        }
        return ls;
    }

    private int[] recurse(Geometry g, int[] comps_holes) {
        if (g instanceof GeometryCollection) {
            for (int i = 0; i < g.getNumGeometries(); ++i) {
                comps_holes = this.recurse(g.getGeometryN(i), comps_holes);
            }
        } else {
            comps_holes[0] = comps_holes[0] + 1;
            if (g instanceof Polygon) {
                comps_holes[1] = comps_holes[1] + ((Polygon)g).getNumInteriorRing();
            }
        }
        return comps_holes;
    }

    public void output(LayerStatistics ls, HTMLPanel out) {
        out.addField("# Features:", ls.featureCount + "");
        out.append("<table border='1'>");
        out.append("<tr><td bgcolor=#CCCCCC>&nbsp;</td><td  bgcolor=#CCCCCC align='center'> Min </td><td  bgcolor=#CCCCCC align='center'> Max </td><td  bgcolor=#CCCCCC align='center'> " + I18N.getInstance().get("ui.plugin.LayerStatisticsPlugIn.avg") + " </td><td  bgcolor=#CCCCCC align='center'> Total </td></tr>");
        out.append("<tr><td bgcolor=#CCCCCC> Pts </td><td align='right'>" + ls.minCoord + "</td><td align='right'>" + ls.maxCoord + "</td><td align='right'>" + ls.avgCoord() + "</td><td align='right'>" + ls.totalCoord + "</td></tr>");
        out.append("<tr><td bgcolor=#CCCCCC> " + I18N.getInstance().get("ui.plugin.LayerStatisticsPlugIn.holes") + " </td><td align='right'>" + ls.minHoles + "</td><td align='right'>" + ls.maxHoles + "</td><td align='right'>" + ls.avgHoles() + "</td><td align='right'>" + ls.totalHoles + "</td></tr>");
        out.append("<tr><td bgcolor=#CCCCCC> " + I18N.getInstance().get("ui.plugin.LayerStatisticsPlugIn.components") + " </td><td align='right'>" + ls.minComp + "</td><td align='right'>" + ls.maxComp + "</td><td align='right'>" + ls.avgComp() + "</td><td align='right'>" + ls.totalComp + "</td></tr>");
        out.append("<tr><td bgcolor=#CCCCCC> " + I18N.getInstance().get("ui.plugin.LayerStatisticsPlugIn.area") + " </td><td align='right'>" + ls.minArea + "</td><td align='right'>" + ls.maxArea + "</td><td align='right'>" + ls.avgArea() + "</td><td align='right'>" + ls.totalArea + "</td></tr>");
        out.append("<tr><td bgcolor=#CCCCCC> " + I18N.getInstance().get("ui.plugin.LayerStatisticsPlugIn.length") + " </td><td align='right'>" + ls.minLength + "</td><td align='right'>" + ls.maxLength + "</td><td align='right'>" + ls.avgLength() + "</td><td align='right'>" + ls.totalLength + "</td></tr>");
        out.append("</table>");
    }

    private class LayerStatistics {
        boolean isFirst = true;
        int minCoord = 0;
        int maxCoord = 0;
        int totalCoord = 0;
        int minComp = 0;
        int maxComp = 0;
        int totalComp = 0;
        int minHoles = 0;
        int maxHoles = 0;
        int totalHoles = 0;
        double minArea = 0.0;
        double maxArea = 0.0;
        double totalArea = 0.0;
        double minLength = 0.0;
        double maxLength = 0.0;
        double totalLength = 0.0;
        int featureCount = 0;

        private LayerStatistics() {
        }

        private void addFeature(int coordCount, int holeCount, int compCount, double area, double length) {
            ++this.featureCount;
            if (this.isFirst || coordCount < this.minCoord) {
                this.minCoord = coordCount;
            }
            if (this.isFirst || coordCount > this.maxCoord) {
                this.maxCoord = coordCount;
            }
            this.totalCoord += coordCount;
            if (this.isFirst || holeCount < this.minHoles) {
                this.minHoles = holeCount;
            }
            if (this.isFirst || holeCount > this.maxHoles) {
                this.maxHoles = holeCount;
            }
            this.totalHoles += holeCount;
            if (this.isFirst || compCount < this.minComp) {
                this.minComp = compCount;
            }
            if (this.isFirst || compCount > this.maxComp) {
                this.maxComp = compCount;
            }
            this.totalComp += compCount;
            if (this.isFirst || area < this.minArea) {
                this.minArea = area;
            }
            if (this.isFirst || area > this.maxArea) {
                this.maxArea = area;
            }
            this.totalArea += area;
            if (this.isFirst || length < this.minLength) {
                this.minLength = length;
            }
            if (this.isFirst || length > this.maxLength) {
                this.maxLength = length;
            }
            this.totalLength += length;
            this.isFirst = false;
        }

        private double avgCoord() {
            return this.featureCount == 0 ? 0.0 : (double)this.totalCoord / (double)this.featureCount;
        }

        private double avgHoles() {
            return this.featureCount == 0 ? 0.0 : (double)this.totalHoles / (double)this.featureCount;
        }

        private double avgComp() {
            return this.featureCount == 0 ? 0.0 : (double)this.totalComp / (double)this.featureCount;
        }

        private double avgArea() {
            return this.featureCount == 0 ? 0.0 : this.totalArea / (double)this.featureCount;
        }

        private double avgLength() {
            return this.featureCount == 0 ? 0.0 : this.totalLength / (double)this.featureCount;
        }
    }
}

