/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin;

import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.EditTransaction;
import com.vividsolutions.jump.workbench.ui.GeometryEditor;
import com.vividsolutions.jump.workbench.ui.SelectionManager;
import com.vividsolutions.jump.workbench.ui.SelectionManagerProxy;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.ImageIcon;
import org.locationtech.jts.geom.Geometry;

public class DeleteSelectedItemsPlugIn
extends AbstractPlugIn {
    public static ImageIcon ICON = IconLoader.icon("famfam/cross.png");
    private GeometryEditor geometryEditor = new GeometryEditor();

    public DeleteSelectedItemsPlugIn() {
        this.setShortcutKeys(127);
    }

    @Override
    public void initialize(PlugInContext context) throws Exception {
        super.initialize(context);
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        this.reportNothingToUndoYet(context);
        ArrayList<EditTransaction> transactions = new ArrayList<EditTransaction>();
        SelectionManager selectionManager = ((SelectionManagerProxy)((Object)context.getActiveInternalFrame())).getSelectionManager();
        for (Layer layer : selectionManager.getLayersWithSelectedItems()) {
            transactions.add(EditTransaction.createTransactionOnSelection(new EditTransaction.SelectionEditor(){

                public Geometry edit(Geometry geometryWithSelectedItems, Collection selectedItems) {
                    Geometry g = geometryWithSelectedItems;
                    for (Geometry selectedItem : selectedItems) {
                        g = DeleteSelectedItemsPlugIn.this.geometryEditor.remove(g, selectedItem);
                    }
                    return g;
                }
            }, (SelectionManagerProxy)((Object)context.getActiveInternalFrame()), context.getWorkbenchFrame(), this.getName(), layer, this.isRollingBackInvalidEdits(context), true));
        }
        return EditTransaction.commit(transactions);
    }

    public static MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createWindowWithSelectionManagerMustBeActiveCheck()).add(checkFactory.createAtLeastNItemsMustBeSelectedCheck(1)).add(checkFactory.createSelectedItemsLayersMustBeEditableCheck());
    }

    @Override
    public ImageIcon getIcon() {
        return ICON;
    }
}

