/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.cursortool;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.geom.EnvelopeUtil;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.FenceLayerFinder;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.ui.AbstractSelection;
import com.vividsolutions.jump.workbench.ui.cursortool.DragTool;
import com.vividsolutions.jump.workbench.ui.cursortool.QuasimodeTool;
import com.vividsolutions.jump.workbench.ui.cursortool.ShortcutsDescriptor;
import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.awt.geom.NoninvertibleTransformException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.locationtech.jts.geom.Geometry;

public abstract class SelectTool
extends DragTool
implements ShortcutsDescriptor {
    private String rendererID;
    protected AbstractSelection selection;

    @Override
    public Cursor getCursor() {
        return Cursor.getDefaultCursor();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        try {
            super.mouseClicked(e);
            this.setViewSource(e.getPoint());
            this.setViewDestination(e.getPoint());
            this.fireGestureFinished();
        }
        catch (Throwable t) {
            this.getPanel().getContext().handleThrowable(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void gestureFinished() throws NoninvertibleTransformException {
        this.reportNothingToUndoYet();
        boolean originalPanelUpdatesEnabled = this.getPanel().getSelectionManager().arePanelUpdatesEnabled();
        this.getPanel().getSelectionManager().setPanelUpdatesEnabled(false);
        if (!this.wasShiftPressed()) {
            this.getPanel().getSelectionManager().clear();
        }
        Map<Layer, Set<Feature>> layerToFeaturesInFenceMap = this.getPanel().visibleLayerToFeaturesInFenceMap(EnvelopeUtil.toGeometry(this.getBoxInModelCoordinates()));
        Set<Layer> layers = layerToFeaturesInFenceMap.keySet();
        for (Layer layer : layers) {
            if (layer.getName().equals(FenceLayerFinder.LAYER_NAME)) continue;
            this.getPanel().getSelectionManager().setPanelUpdatesEnabled(false);
            try {
                Map<Feature, List<Geometry>> featureToItemsToSelectMap = this.featureToItemsInFenceMap((Collection<Feature>)layerToFeaturesInFenceMap.get(layer), layer, false);
                Map<Feature, List<Geometry>> featureToItemsToUnselectMap = this.featureToItemsInFenceMap((Collection<Feature>)layerToFeaturesInFenceMap.get(layer), layer, true);
                this.selection.selectItems(layer, featureToItemsToSelectMap);
                if (!this.wasShiftPressed()) continue;
                this.selection.unselectItems(layer, featureToItemsToUnselectMap);
            }
            finally {
                this.getPanel().getSelectionManager().setPanelUpdatesEnabled(originalPanelUpdatesEnabled);
            }
        }
        this.getPanel().getSelectionManager().setPanelUpdatesEnabled(originalPanelUpdatesEnabled);
        this.getPanel().getSelectionManager().updatePanel();
    }

    protected boolean selectedLayersOnly() {
        return this.wasControlPressed();
    }

    protected SelectTool(WorkbenchContext context, String rendererID) {
        super(context);
        this.rendererID = rendererID;
    }

    private Map<Feature, List<Geometry>> featureToItemsInFenceMap(Collection<Feature> features, Layer layer, boolean selected) throws NoninvertibleTransformException {
        Map<Feature, List<Geometry>> featureToSelectedItemsMap = this.selection.getFeatureToSelectedItemCollectionMap(layer);
        LinkedHashMap<Feature, List<Geometry>> featureToItemsInFenceMap = new LinkedHashMap<Feature, List<Geometry>>();
        for (Feature feature : features) {
            List selectedItems = featureToSelectedItemsMap.get(feature);
            if (selectedItems == null) {
                selectedItems = Collections.EMPTY_LIST;
            }
            List<Geometry> itemsToReturn = this.itemsInFence(feature);
            if (selected) {
                itemsToReturn.retainAll(selectedItems);
            } else {
                itemsToReturn.removeAll(selectedItems);
            }
            featureToItemsInFenceMap.put(feature, itemsToReturn);
        }
        return featureToItemsInFenceMap;
    }

    private List<Geometry> itemsInFence(Feature feature) throws NoninvertibleTransformException {
        ArrayList<Geometry> itemsInFence = new ArrayList<Geometry>(1);
        Geometry fence = EnvelopeUtil.toGeometry(this.getBoxInModelCoordinates());
        for (Geometry selectedItem : this.selection.items(feature.getGeometry())) {
            if (!selectedItem.intersects(fence)) continue;
            itemsInFence.add(selectedItem);
        }
        return itemsInFence;
    }

    @Override
    public Icon getIcon() {
        return null;
    }

    @Override
    public Map<QuasimodeTool.ModifierKeySpec, String> describeShortcuts() {
        HashMap<QuasimodeTool.ModifierKeySpec, String> map = new HashMap<QuasimodeTool.ModifierKeySpec, String>();
        map.put(new QuasimodeTool.ModifierKeySpec(new int[]{16}), I18N.getInstance().get(this.getClass().getName() + ".add-to-selection"));
        return map;
    }
}

