/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.cursortool;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.BasicFeature;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureDataset;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.FeatureEventType;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerManager;
import com.vividsolutions.jump.workbench.model.StandardCategoryNames;
import com.vividsolutions.jump.workbench.model.UndoableCommand;
import com.vividsolutions.jump.workbench.ui.EditTransaction;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.cursortool.NClickTool;
import com.vividsolutions.jump.workbench.ui.cursortool.NoteStyle;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import com.vividsolutions.jump.workbench.ui.snap.SnapToFeaturesPolicy;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Shape;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.geom.NoninvertibleTransformException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.GeometryFactory;

public class NoteTool
extends NClickTool {
    public static final String NOTES = I18N.getInstance().get("ui.cursortool.NoteTool.notes");
    private static final FeatureSchema DEFAULT_SCHEMA = NoteStyle.createFeatureSchema();
    private LayerViewPanel panel;
    private JTextArea textArea;
    private Mode mode;
    private ImageIcon icon = IconLoader.icon("sticky.png");
    private Cursor cursor = GUIUtil.createCursorFromIcon(this.icon.getImage());

    public NoteTool(WorkbenchContext context) {
        super(context, 1);
        this.panel = this.getPanel();
        this.getSnapManager().addPolicies(Collections.singleton(new SnapToFeaturesPolicy()));
        this.textArea = NoteStyle.createTextArea();
        this.textArea.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (NoteTool.this.panelContainsTextArea()) {
                    boolean doit;
                    boolean bl = doit = NoteTool.this.textArea.getText().trim().length() > 0;
                    if (doit) {
                        NoteTool.this.getPanel().getLayerManager().getUndoableEditReceiver().startReceiving();
                    }
                    NoteTool.this.removeTextAreaFromPanel();
                    if (doit) {
                        NoteTool.this.getPanel().getLayerManager().getUndoableEditReceiver().stopReceiving();
                    }
                }
            }
        });
    }

    @Override
    public String getName() {
        return I18N.getInstance().get("ui.cursortool.NoteTool");
    }

    @Override
    public void deactivate() {
        if (this.panelContainsTextArea()) {
            boolean doit;
            boolean bl = doit = this.textArea.getText().trim().length() > 0;
            if (doit) {
                this.getPanel().getLayerManager().getUndoableEditReceiver().startReceiving();
            }
            this.removeTextAreaFromPanel();
            if (doit) {
                this.getPanel().getLayerManager().getUndoableEditReceiver().stopReceiving();
            }
        }
        super.deactivate();
    }

    @Override
    public Cursor getCursor() {
        return this.cursor;
    }

    @Override
    protected void gestureFinished() throws Exception {
        this.reportNothingToUndoYet();
        Feature noteFeatureAtClick = this.noteFeature(this.getModelDestination());
        this.removeTextAreaFromPanel();
        this.mode = this.mode(noteFeatureAtClick, this.getModelDestination());
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    NoteTool.this.addTextAreaToPanel(NoteTool.this.mode.location());
                }
                catch (NoninvertibleTransformException e) {
                    NoteTool.this.getPanel().getContext().handleThrowable(e);
                }
            }
        });
    }

    private Mode mode(Feature noteFeatureAtClick, Coordinate click) {
        return noteFeatureAtClick == null ? new CreateMode(click) : new EditMode(noteFeatureAtClick);
    }

    private Feature noteFeature(Coordinate click) {
        return this.noteFeature(new Envelope(click, new Coordinate(click.x - 80.0 / this.scale(), click.y + 30.0 / this.scale())));
    }

    private Feature noteFeature(Envelope envelope) {
        return (Feature)this.firstOrNull(this.layer().getFeatureCollectionWrapper().query(envelope));
    }

    private Object firstOrNull(Collection items) {
        return !items.isEmpty() ? items.iterator().next() : null;
    }

    private double scale() {
        return this.getPanel().getViewport().getScale();
    }

    private void addTextAreaToPanel(Coordinate location) throws NoninvertibleTransformException {
        this.layer().setVisible(true);
        if (this.getPanel().getLayout() != null) {
            this.getPanel().setLayout(null);
        }
        this.textArea.setText(this.mode.initialText());
        this.textArea.setBackground(this.layer().getBasicStyle().getFillColor());
        this.getPanel().add(this.textArea);
        this.textArea.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent e) {
                JTextArea textArea = (JTextArea)e.getSource();
                int ht = textArea.getPreferredSize().height;
                int wt = textArea.getPreferredSize().width;
                if (ht < 30) {
                    ht = 30;
                }
                if (wt < 80) {
                    wt = 80;
                }
                int x = textArea.getBounds().x;
                int y = textArea.getBounds().y;
                textArea.setBounds(x, y, wt, ht);
            }
        });
        int ht = this.textArea.getPreferredSize().height;
        int wt = this.textArea.getPreferredSize().width;
        if (ht < 30) {
            ht = 30;
        }
        if (wt < 80) {
            wt = 80;
        }
        this.textArea.setBounds((int)this.getPanel().getViewport().toViewPoint(location).getX(), (int)this.getPanel().getViewport().toViewPoint(location).getY(), wt, ht);
        this.textArea.requestFocus();
    }

    private boolean panelContainsTextArea() {
        return this.getPanel() != null && Arrays.asList(this.getPanel().getComponents()).contains(this.textArea);
    }

    private void removeTextAreaFromPanel() {
        if (!this.panelContainsTextArea()) {
            return;
        }
        this.mode.commit(this.textArea.getText().trim());
        this.getPanel().remove(this.textArea);
        this.getPanel().superRepaint();
    }

    private void disableAutomaticInitialZooming() {
        this.getPanel().setViewportInitialized(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Layer layer() {
        LayerManager layerManager = this.getPanel().getLayerManager();
        if (layerManager.getLayer(NOTES) != null) {
            return layerManager.getLayer(NOTES);
        }
        Layer noteLayer = new Layer(NOTES, Color.yellow.brighter().brighter(), new FeatureDataset(DEFAULT_SCHEMA), layerManager);
        boolean firingEvents = layerManager.isFiringEvents();
        layerManager.setFiringEvents(false);
        try {
            noteLayer.addStyle(new NoteStyle());
            noteLayer.setEditable(true);
        }
        finally {
            layerManager.setFiringEvents(firingEvents);
        }
        layerManager.addLayer(StandardCategoryNames.SYSTEM, noteLayer);
        return noteLayer;
    }

    @Override
    public Icon getIcon() {
        return this.icon;
    }

    @Override
    protected Shape getShape() throws NoninvertibleTransformException {
        return null;
    }

    private class EditMode
    extends Mode {
        public EditMode(Feature noteFeature) {
            super(noteFeature);
        }

        @Override
        public void commit(final String text) {
            final Date modifiedDate = new Date();
            final Date oldModifiedDate = (Date)this.getNoteFeature().getAttribute(NoteStyle.MODIFIED);
            final String oldText = this.getNoteFeature().getString(NoteStyle.TEXT);
            NoteTool.this.execute(new UndoableCommand(NoteTool.this.getName()){

                @Override
                public void execute() {
                    EditMode.this.update(EditMode.this.getNoteFeature(), text, modifiedDate, NoteTool.this.layer());
                }

                @Override
                public void unexecute() {
                    EditMode.this.update(EditMode.this.getNoteFeature(), oldText, oldModifiedDate, NoteTool.this.layer());
                }
            });
        }

        private void update(Feature noteFeature, String text, Date modifiedDate, Layer layer) {
            noteFeature.setAttribute(NoteStyle.MODIFIED, (Object)modifiedDate);
            noteFeature.setAttribute(NoteStyle.TEXT, (Object)text);
            layer.getLayerManager().fireFeaturesChanged(Collections.singleton(noteFeature), FeatureEventType.ATTRIBUTES_MODIFIED, layer);
        }

        @Override
        public String initialText() {
            return this.getNoteFeature().getString(NoteStyle.TEXT);
        }
    }

    private class CreateMode
    extends Mode {
        public CreateMode(final Coordinate location) {
            super(new BasicFeature(NoteTool.this.layer().getFeatureCollectionWrapper().getFeatureSchema()){
                {
                    super(featureSchema);
                    this.setAttribute(NoteStyle.CREATED, (Object)new Date());
                    this.setAttribute("GEOMETRY", (Object)new GeometryFactory().createPoint(location));
                }
            });
        }

        @Override
        public void commit(String text) {
            if (text.length() > 0) {
                NoteTool.this.disableAutomaticInitialZooming();
                this.getNoteFeature().setAttribute(NoteStyle.MODIFIED, (Object)new Date());
                this.getNoteFeature().setAttribute(NoteStyle.TEXT, (Object)text);
                EditTransaction transaction = new EditTransaction((Collection<Feature>)Collections.EMPTY_LIST, NoteTool.this.getName(), NoteTool.this.layer(), NoteTool.this.isRollingBackInvalidEdits(), true, NoteTool.this.getPanel());
                transaction.createFeature(this.getNoteFeature());
                transaction.commit();
            }
        }

        @Override
        public String initialText() {
            return "";
        }
    }

    private abstract class Mode {
        private Feature noteFeature;

        public Mode(Feature noteFeature) {
            this.noteFeature = noteFeature;
        }

        public Coordinate location() {
            return this.noteFeature.getGeometry().getCoordinate();
        }

        public abstract void commit(String var1);

        protected Feature getNoteFeature() {
            return this.noteFeature;
        }

        public abstract String initialText();
    }
}

