/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.cursortool;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.util.Blackboard;
import com.vividsolutions.jump.util.StringUtil;
import com.vividsolutions.jump.workbench.JUMPWorkbench;
import com.vividsolutions.jump.workbench.Logger;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.UndoableCommand;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.ui.EditTransaction;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.LayerViewPanelListener;
import com.vividsolutions.jump.workbench.ui.TaskFrame;
import com.vividsolutions.jump.workbench.ui.WorkbenchFrame;
import com.vividsolutions.jump.workbench.ui.cursortool.CursorTool;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.EditingPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.PersistentBlackboardPlugIn;
import com.vividsolutions.jump.workbench.ui.snap.SnapManager;
import com.vividsolutions.jump.workbench.ui.snap.SnapPolicy;
import com.vividsolutions.jump.workbench.ui.snap.SnapToFeaturesPolicy;
import com.vividsolutions.jump.workbench.ui.snap.SnapToGridPolicy;
import com.vividsolutions.jump.workbench.ui.snap.SnapToVerticesPolicy;
import com.vividsolutions.jump.workbench.ui.toolbox.ToolboxDialog;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.MissingResourceException;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import org.locationtech.jts.geom.Coordinate;

public abstract class AbstractCursorTool
implements CursorTool {
    private boolean snappingInitialized = false;
    private boolean snappingAllowed = false;
    private boolean controlPressed = false;
    private boolean shiftPressed = false;
    private Color color = Color.red;
    private boolean filling = false;
    private Shape lastShapeDrawn;
    private Image lastImageDrawn = null;
    private Point lastMousePosition = null;
    protected boolean isLinuxOS = System.getProperty("os.name").toLowerCase().startsWith("linux");
    private final LayerViewPanelListener layerViewPanelListener = new LayerViewPanelListener(){

        @Override
        public void cursorPositionChanged(String x, String y) {
        }

        @Override
        public void selectionChanged() {
        }

        public void fenceChanged() {
        }

        @Override
        public void painted(Graphics graphics) {
            try {
                if (AbstractCursorTool.this.shapeOnScreen) {
                    AbstractCursorTool.this.setShapeOnScreen(false);
                    AbstractCursorTool.this.redrawShape((Graphics2D)graphics);
                }
            }
            catch (Throwable t) {
                AbstractCursorTool.this.panel.getContext().handleThrowable(t);
            }
        }
    };
    private Color originalColor;
    private Stroke originalStroke;
    protected LayerViewPanel panel = null;
    private boolean shapeOnScreen = false;
    private final SnapManager snapManager = new SnapManager();
    private Stroke stroke = new BasicStroke(1.0f);
    private final List<Listener> listeners = new ArrayList<Listener>();
    private Cursor cursor;
    private WorkbenchContext context;
    private final KeyListener keyListener = new KeyListener(){
        boolean off = false;

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            this.saveModifiers(e);
            if (!AbstractCursorTool.componentWithFocusIsHandledByCursorTools()) {
                return;
            }
            if (AbstractCursorTool.this.snappingInitialized && this.isSpace(e) && !this.off) {
                this.off = true;
                AbstractCursorTool.this.prohibitSnapping();
                Logger.debug("snap off");
                this.showMsg("com.vividsolutions.jump.workbench.ui.cursortool.AbstractCursorTool.snapping-off");
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
            this.saveModifiers(e);
            if (!AbstractCursorTool.componentWithFocusIsHandledByCursorTools()) {
                return;
            }
            if (AbstractCursorTool.this.snappingInitialized && this.isSpace(e) && this.off) {
                this.off = false;
                AbstractCursorTool.this.allowSnapping();
                Logger.debug("snap on");
                this.showMsg("com.vividsolutions.jump.workbench.ui.cursortool.AbstractCursorTool.snapping-on");
            }
        }

        private void saveModifiers(KeyEvent e) {
            AbstractCursorTool.this.setShiftPressed(e.isShiftDown());
            AbstractCursorTool.this.setControlPressed(e.isControlDown());
        }

        private void showMsg(String msg) {
            AbstractCursorTool.this.getPanel().getWorkBenchFrame().setStatusMessage(I18N.getInstance().get(msg), 5000);
        }

        private boolean isSpace(KeyEvent e) {
            return e.getKeyCode() == 32;
        }
    };

    private AbstractCursorTool() {
    }

    public AbstractCursorTool(WorkbenchContext context) {
        this.context = context;
    }

    protected WorkbenchContext getWorkbenchContext() {
        return this.context;
    }

    public void allowSnapping() {
        this.snappingAllowed = true;
    }

    public void prohibitSnapping() {
        this.snappingAllowed = false;
    }

    public boolean supportsSnapping() {
        return this.snappingAllowed;
    }

    protected void setShiftPressed(boolean onoff) {
        this.shiftPressed = onoff;
    }

    protected boolean wasShiftPressed() {
        return this.shiftPressed;
    }

    protected void setControlPressed(boolean onoff) {
        this.controlPressed = onoff;
    }

    protected boolean wasControlPressed() {
        return this.controlPressed;
    }

    public static Cursor createCursor(Image image) {
        return AbstractCursorTool.createCursor(image, new Point(16, 16));
    }

    public static Cursor createCursor(Image image, Point hotSpot) {
        return AbstractCursorTool.createCursor(image, hotSpot, null);
    }

    public static Cursor createCursor(Image image, Point hotSpot, String name) {
        return GUIUtil.createCursor(image, hotSpot, name);
    }

    @Override
    public Cursor getCursor() {
        if (this.cursor == null) {
            this.cursor = this.getIcon() instanceof ImageIcon ? GUIUtil.createCursorFromIcon(((ImageIcon)this.getIcon()).getImage()) : Cursor.getDefaultCursor();
        }
        return this.cursor;
    }

    @Override
    public boolean isGestureInProgress() {
        return this.isShapeOnScreen();
    }

    @Override
    public boolean isRightMouseButtonUsed() {
        return false;
    }

    public boolean isShapeOnScreen() {
        return this.shapeOnScreen;
    }

    @Override
    public void activate(LayerViewPanel new_panel) {
        Logger.debug(I18N.getInstance().get("ui.cursortool.AbstractCursorTool.activating") + " '" + this.getName() + "' -> " + this.getClass().getSimpleName());
        LayerViewPanel old_panel = this.getPanel();
        if (old_panel != null && !old_panel.equals(new_panel)) {
            this.cancelGesture();
        }
        this.panel = new_panel;
        this.panel.addListener(this.layerViewPanelListener);
        if (this.snappingAllowed && !this.snappingInitialized) {
            this.getSnapManager().addPolicies(this.createStandardSnappingPolicies(PersistentBlackboardPlugIn.get(this.getWorkbench().getContext())));
            this.snappingInitialized = true;
        }
        this.context.getWorkbench().getFrame().addEasyKeyListener(this.keyListener);
    }

    protected List<SnapPolicy> createStandardSnappingPolicies(Blackboard blackboard) {
        return Arrays.asList(new SnapToVerticesPolicy(blackboard), new SnapToFeaturesPolicy(blackboard), new SnapToGridPolicy(blackboard));
    }

    protected boolean isRollingBackInvalidEdits() {
        return PersistentBlackboardPlugIn.get(this.getWorkbench().getContext()).get(EditTransaction.ROLLING_BACK_INVALID_EDITS_KEY, false);
    }

    @Override
    public void deactivate() {
        try {
            this.context.getWorkbench().getFrame().removeEasyKeyListener(this.keyListener);
        }
        catch (Exception e) {
            Logger.error(e);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    public void setColor(Color color) {
        this.color = color;
    }

    protected void setFilling(boolean filling) {
        this.filling = filling;
    }

    protected Stroke getStroke() {
        return this.stroke;
    }

    protected void setStroke(Stroke stroke) {
        this.stroke = stroke;
    }

    protected void setup(Graphics2D graphics) {
        this.originalColor = graphics.getColor();
        this.originalStroke = graphics.getStroke();
        graphics.setColor(this.color);
        graphics.setXORMode(Color.white);
        graphics.setStroke(this.stroke);
    }

    protected abstract Shape getShape() throws Exception;

    protected Image getImage() {
        return null;
    }

    protected Point getImagePosition() {
        return null;
    }

    protected void cleanup(Graphics2D graphics) {
        graphics.setPaintMode();
        graphics.setColor(this.originalColor);
        graphics.setStroke(this.originalStroke);
    }

    protected void clearShape() {
        Graphics2D g;
        if (this.panel != null && (g = this.getGraphics2D()) != null) {
            this.clearShape(g);
        }
    }

    protected void clearImage() {
        Graphics2D g;
        if (this.panel != null && (g = this.getGraphics2D()) != null) {
            this.clearImage(g);
        }
    }

    private Graphics2D getGraphics2D() {
        Graphics2D g = (Graphics2D)this.panel.getGraphics();
        if (g != null && !this.isLinuxOS) {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        return g;
    }

    @Override
    public void cancelGesture() {
        this.clearShape();
        this.clearImage();
    }

    protected void drawShapeXOR(Graphics2D g) throws Exception {
        Shape newShape = this.getShape();
        this.drawShapeXOR(newShape, g);
        this.lastShapeDrawn = newShape;
    }

    protected void drawImageXOR(Graphics2D g) {
        Image newImage = this.getImage();
        Point newPosition = this.getImagePosition();
        this.drawImageXOR(newImage, newPosition, g);
        this.lastImageDrawn = newImage;
        this.lastMousePosition = newPosition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void drawShapeXOR(Shape shape, Graphics2D graphics) {
        this.setup(graphics);
        try {
            if (shape != null) {
                if (this.filling) {
                    graphics.fill(shape);
                } else {
                    graphics.draw(shape);
                }
            }
        }
        catch (InternalError ie) {
            ie.printStackTrace(System.err);
            Logger.error(ie.getLocalizedMessage() + ": " + Arrays.toString(ie.getStackTrace()));
        }
        finally {
            this.cleanup(graphics);
        }
    }

    protected void drawImageXOR(Image image, Point position, Graphics2D graphics) {
        if (image != null && position != null) {
            this.setup(graphics);
            graphics.drawImage(image, (int)position.getX(), (int)position.getY(), null);
        }
    }

    protected void redrawShape() throws Exception {
        this.redrawShape(this.getGraphics2D());
    }

    protected void redrawImage() throws Exception {
        this.redrawImage(this.getGraphics2D());
    }

    protected Coordinate snap(Point2D viewPoint) throws NoninvertibleTransformException {
        return this.snap(this.getPanel().getViewport().toModelCoordinate(viewPoint));
    }

    protected Coordinate snap(Coordinate modelCoordinate) {
        return this.snappingAllowed ? this.snapManager.snap(this.getPanel(), modelCoordinate) : modelCoordinate;
    }

    private void setShapeOnScreen(boolean shapeOnScreen) {
        this.shapeOnScreen = shapeOnScreen;
    }

    private void clearShape(Graphics2D graphics) {
        if (!this.shapeOnScreen) {
            return;
        }
        this.drawShapeXOR(this.lastShapeDrawn, graphics);
        this.setShapeOnScreen(false);
    }

    private void clearImage(Graphics2D graphics) {
        if (!this.shapeOnScreen) {
            return;
        }
        this.drawImageXOR(this.lastImageDrawn, this.lastMousePosition, graphics);
        this.setShapeOnScreen(false);
    }

    private void redrawShape(Graphics2D graphics) throws Exception {
        this.clearShape(graphics);
        this.drawShapeXOR(graphics);
        this.setShapeOnScreen(true);
    }

    private void redrawImage(Graphics2D graphics) {
        this.clearImage(graphics);
        this.drawImageXOR(graphics);
        this.setShapeOnScreen(true);
    }

    protected TaskFrame getTaskFrame() {
        return (TaskFrame)SwingUtilities.getAncestorOfClass(TaskFrame.class, this.getPanel());
    }

    public JUMPWorkbench getWorkbench() {
        return this.getWorkbenchContext().getWorkbench();
    }

    protected abstract void gestureFinished() throws Exception;

    protected void fireGestureFinished() throws Exception {
        WorkbenchFrame workbenchFrame;
        this.getPanel().getContext().setStatusMessage("");
        if (this.getTaskFrame() != null && (workbenchFrame = (WorkbenchFrame)SwingUtilities.getAncestorOfClass(WorkbenchFrame.class, this.getTaskFrame())) != null) {
            Logger.info(I18N.getInstance().get("ui.cursortool.AbstractCursorTool.gesture-finished") + ": " + this.getName());
        }
        this.getPanel().getLayerManager().getUndoableEditReceiver().startReceiving();
        try {
            this.gestureFinished();
        }
        finally {
            this.getPanel().getLayerManager().getUndoableEditReceiver().stopReceiving();
        }
        for (Listener listener : this.listeners) {
            listener.gestureFinished();
        }
    }

    public void add(Listener listener) {
        this.listeners.add(listener);
    }

    protected void execute(UndoableCommand command) {
        this.execute(command, false);
    }

    protected void execute(UndoableCommand command, boolean ignoreNull) {
        if (command == null) {
            if (ignoreNull) {
                return;
            }
            throw new IllegalArgumentException("UndoableCommand command must not be null.");
        }
        AbstractPlugIn.execute(command, this.getPanel());
    }

    protected void reportNothingToUndoYet() {
        this.getPanel().getLayerManager().getUndoableEditReceiver().reportNothingToUndoYet();
    }

    public String toString() {
        return AbstractCursorTool.name(this) + "@" + this.hashCode();
    }

    @Override
    public String getName() {
        return AbstractCursorTool.name(this);
    }

    public static LayerViewPanel getPanel(CursorTool ct) {
        if (ct instanceof AbstractCursorTool) {
            return ((AbstractCursorTool)ct).getPanel();
        }
        return null;
    }

    public final LayerViewPanel getPanel() {
        return this.panel;
    }

    protected void setPanel(LayerViewPanel panel) {
        this.panel = panel;
    }

    public static String name(CursorTool tool) {
        try {
            Class<?> c;
            String key = tool.getClass().getName();
            while (key.contains("$") && (c = tool.getClass().getSuperclass()) != null) {
                key = c.getName();
            }
            return I18N.getInstance().get(key);
        }
        catch (MissingResourceException e) {
            Logger.error(e.getMessage() + " " + tool.getClass().getName());
            return StringUtil.toFriendlyName(tool.getClass().getName(), I18N.getInstance().get("ui.cursortool.AbstractCursorTool.tool"));
        }
    }

    protected boolean check(EnableCheck check) {
        String warning = check.check(null);
        if (warning != null) {
            this.getPanel().getContext().warnUser(warning);
            return false;
        }
        return true;
    }

    public SnapManager getSnapManager() {
        return this.snapManager;
    }

    public Color getColor() {
        return this.color;
    }

    public static boolean componentWithFocusIsHandledByCursorTools() {
        boolean valid = false;
        for (Component c = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner(); c != null; c = c.getParent()) {
            if (!(c instanceof LayerViewPanel) && (!(c instanceof ToolboxDialog) || !c.equals(EditingPlugIn.getInstance().getToolbox()))) continue;
            valid = true;
            break;
        }
        return valid;
    }

    public static interface Listener {
        public void gestureFinished();
    }
}

