/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui;

import com.vividsolutions.jump.util.SuggestTree;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JTextField;

public class SuggestTreeComboBox
extends JComboBox<String> {
    private SuggestTree trie;
    private Map<String, String> map;

    public SuggestTreeComboBox(String[] array, int size) {
        this.map = new HashMap<String, String>(array.length);
        this.trie = this.initTrie(array, size);
        this.setEditable(true);
        this.getEditor().getEditorComponent().addKeyListener(new MyKeyAdapter(this));
    }

    public void changeModel(String[] array) {
        this.map = new HashMap<String, String>(array.length);
        this.trie = this.initTrie(array, this.trie.size());
    }

    private SuggestTree initTrie(String[] array, int size) {
        SuggestTree trie = new SuggestTree(size);
        for (String s : array) {
            String sm = s.toLowerCase();
            this.map.put(sm, s);
            int weight = 16;
            trie.put(sm, weight);
            Integer[] integerArray = this.split(sm);
            int n = integerArray.length;
            for (int i = 0; i < n; ++i) {
                int split = integerArray[i];
                String permuted = sm.substring(split) + sm.substring(0, split);
                this.map.put(permuted, s);
                trie.put(permuted, --weight);
            }
        }
        return trie;
    }

    private Integer[] split(String s) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int i = 1; i < s.length(); ++i) {
            if (!Character.isLetter(s.charAt(i - 1)) && Character.isLetter(s.charAt(i))) {
                list.add(i);
            }
            if (Character.isDigit(s.charAt(i - 1)) || !Character.isDigit(s.charAt(i))) continue;
            list.add(i);
        }
        return list.toArray(new Integer[list.size()]);
    }

    class MyKeyAdapter
    extends KeyAdapter {
        final SuggestTreeComboBox cb;

        MyKeyAdapter(SuggestTreeComboBox cb) {
            this.cb = cb;
        }

        @Override
        public void keyReleased(KeyEvent e) {
            super.keyReleased(e);
            if (e.getKeyCode() == 40 || e.getKeyCode() == 38) {
                this.cb.getEditor().setItem(this.cb.getSelectedItem());
                return;
            }
            String newValue = (String)this.cb.getEditor().getItem();
            if (newValue.length() == 0) {
                return;
            }
            SuggestTree.Node node = this.cb.trie.getAutocompleteSuggestions(newValue.toLowerCase());
            if (node == null || node.listLength() == 0) {
                return;
            }
            if (node.listLength() == 1) {
                this.cb.setSelectedItem(SuggestTreeComboBox.this.map.get(node.getSuggestion(0).getTerm()));
                this.cb.hidePopup();
            } else {
                ArrayList<String> set = new ArrayList<String>();
                for (int i = 0; i < node.listLength(); ++i) {
                    String term = (String)SuggestTreeComboBox.this.map.get(node.getSuggestion(i).getTerm());
                    if (set.contains(term)) continue;
                    set.add(term);
                }
                this.cb.setModel(new DefaultComboBoxModel<String>(set.toArray(new String[set.size()])));
                this.cb.showPopup();
                this.cb.getEditor().setItem(newValue);
                ((JTextField)this.cb.editor.getEditorComponent()).select(newValue.length(), newValue.length());
            }
        }
    }
}

