/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.util.Blackboard;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.CategoryEvent;
import com.vividsolutions.jump.workbench.model.FeatureEvent;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerEvent;
import com.vividsolutions.jump.workbench.model.LayerEventType;
import com.vividsolutions.jump.workbench.model.LayerListener;
import com.vividsolutions.jump.workbench.model.LayerManager;
import com.vividsolutions.jump.workbench.model.LayerManagerProxy;
import com.vividsolutions.jump.workbench.model.Task;
import com.vividsolutions.jump.workbench.ui.AttributeTab;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.GeometryInfoTab;
import com.vividsolutions.jump.workbench.ui.InfoModel;
import com.vividsolutions.jump.workbench.ui.LayerNamePanel;
import com.vividsolutions.jump.workbench.ui.LayerNamePanelProxy;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.LayerViewPanelProxy;
import com.vividsolutions.jump.workbench.ui.SelectionManager;
import com.vividsolutions.jump.workbench.ui.SelectionManagerProxy;
import com.vividsolutions.jump.workbench.ui.TaskFrame;
import com.vividsolutions.jump.workbench.ui.TaskFrameProxy;
import com.vividsolutions.jump.workbench.ui.WorkbenchFrame;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import com.vividsolutions.jump.workbench.ui.plugin.PersistentBlackboardPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.ViewAttributesPlugIn;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.ImageIcon;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import javax.swing.table.DefaultTableModel;
import org.locationtech.jts.util.Assert;
import org.openjump.core.ui.swing.DetachableInternalFrame;

public class InfoFrame
extends DetachableInternalFrame
implements LayerManagerProxy,
SelectionManagerProxy,
LayerNamePanelProxy,
TaskFrameProxy,
LayerViewPanelProxy {
    public static final String TABLE_VIEW = I18N.getInstance().get("com.vividsolutions.jump.workbench.ui.InfoFrame.table-view");
    public static final String HTML_VIEW = I18N.getInstance().get("com.vividsolutions.jump.workbench.ui.InfoFrame.html-view");
    public static final String BB_FEATUREINFO_WINDOW_SIZE_WIDTH = ViewAttributesPlugIn.class.getName() + " - FEATUREINFO_WINDOW_SIZE_WIDTH";
    public static final String BB_FEATUREINFO_WINDOW_SIZE_HEIGHT = ViewAttributesPlugIn.class.getName() + " - FEATUREINFO_WINDOW_SIZE_HEIGHT";
    public static final String BB_FEATUREINFO_WINDOW_POSITION_X = ViewAttributesPlugIn.class.getName() + " - FEATUREINFO_WINDOW_POSITION_X";
    public static final String BB_FEATUREINFO_WINDOW_POSITION_Y = ViewAttributesPlugIn.class.getName() + " - FEATUREINFO_WINDOW_POSITION_Y";
    private static Blackboard blackboard = null;
    private LayerManager layerManager;
    private BorderLayout borderLayout1 = new BorderLayout();
    private AttributeTab attributeTab;
    private InfoModel model = new InfoModel();
    private GeometryInfoTab geometryInfoTab;
    private JTabbedPane tabbedPane = new JTabbedPane();
    private RasterInfoTab rasterInfoTab;
    private WMSInfoTab wmsInfoTab;
    private WorkbenchFrame workbenchFrame;
    private static ImageIcon ICON = IconLoader.icon("information_16x16.png");

    @Override
    public LayerManager getLayerManager() {
        return this.layerManager;
    }

    @Override
    public TaskFrame getTaskFrame() {
        return this.attributeTab.getTaskFrame();
    }

    public InfoFrame(WorkbenchContext workbenchContext, LayerManagerProxy layerManagerProxy, final TaskFrame taskFrame) {
        blackboard = PersistentBlackboardPlugIn.get(workbenchContext);
        this.geometryInfoTab = new GeometryInfoTab(this.model, workbenchContext);
        this.rasterInfoTab = new RasterInfoTab(null, null);
        this.wmsInfoTab = new WMSInfoTab();
        Assert.isTrue((layerManagerProxy.getLayerManager() != null ? 1 : 0) != 0);
        this.layerManager = layerManagerProxy.getLayerManager();
        this.attributeTab = new AttributeTab(this.model, workbenchContext, taskFrame, this, false);
        this.workbenchFrame = workbenchContext.getWorkbench().getFrame();
        this.setResizable(true);
        this.setClosable(true);
        this.setMaximizable(true);
        this.setIconifiable(true);
        this.setFrameIcon(GUIUtil.toSmallIcon(ICON, 14));
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.tabbedPane.addTab("", IconLoader.icon("Table.gif"), this.attributeTab, TABLE_VIEW);
        this.tabbedPane.addTab("", IconLoader.icon("Paper.gif"), this.geometryInfoTab, HTML_VIEW);
        this.tabbedPane.addTab("R", null, this.rasterInfoTab, "Raster");
        this.tabbedPane.addTab("WMS", null, this.wmsInfoTab, "WMS");
        this.updateTitle(taskFrame.getTask().getName());
        taskFrame.getTask().add(new Task.NameListener(){

            @Override
            public void taskNameChanged(String name) {
                InfoFrame.this.updateTitle(taskFrame.getTask().getName());
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentMoved(ComponentEvent e) {
                super.componentMoved(e);
                InfoFrame.this.savePositionAndSize();
            }

            @Override
            public void componentResized(ComponentEvent e) {
                super.componentResized(e);
                InfoFrame.this.savePositionAndSize();
            }
        });
        final LayerListener layerListener = new LayerListener(){

            @Override
            public void featuresChanged(FeatureEvent e) {
            }

            @Override
            public void layerChanged(LayerEvent e) {
                if (e.getType() == LayerEventType.REMOVED && InfoFrame.this.getModel().getLayers().contains(e.getLayerable())) {
                    InfoFrame.this.getModel().remove((Layer)e.getLayerable());
                }
            }

            @Override
            public void categoryChanged(CategoryEvent e) {
            }
        };
        layerManagerProxy.getLayerManager().addLayerListener(layerListener);
        this.addInternalFrameListener(new InternalFrameAdapter(){

            @Override
            public void internalFrameOpened(InternalFrameEvent e) {
                InfoFrame.this.attributeTab.getToolBar().updateEnabledState();
            }

            @Override
            public void internalFrameClosed(InternalFrameEvent e) {
                InfoFrame.this.model.dispose();
                InfoFrame.this.savePositionAndSize();
                InfoFrame.this.getLayerManager().removeLayerListener(layerListener);
                InfoFrame.this.getLayerManager().removeLayerListener(((InfoFrame)InfoFrame.this).attributeTab.attributeTabLayerListener);
            }
        });
    }

    public JPanel getAttributeTab() {
        return this.attributeTab;
    }

    public JPanel getGeometryTab() {
        return this.geometryInfoTab;
    }

    public void setSelectedTab(JPanel tab) {
        this.tabbedPane.setSelectedComponent(tab);
    }

    public static String title(String taskName) {
        return I18N.getInstance().get("ui.InfoFrame.feature-info") + ": " + taskName;
    }

    private void updateTitle(String taskName) {
        this.setTitle(InfoFrame.title(taskName));
    }

    public InfoModel getModel() {
        return this.model;
    }

    private void jbInit() throws Exception {
        this.setDefaultCloseOperation(2);
        this.setTitle(I18N.getInstance().get("ui.InfoFrame.feature-info"));
        this.getContentPane().setLayout(this.borderLayout1);
        this.tabbedPane.setTabPlacement(2);
        this.getContentPane().add((Component)this.tabbedPane, "Center");
    }

    public void surface() {
        int width = blackboard.get(BB_FEATUREINFO_WINDOW_SIZE_WIDTH, 550);
        int height = blackboard.get(BB_FEATUREINFO_WINDOW_SIZE_HEIGHT, 185);
        this.setSize(width, height);
        JInternalFrame activeFrame = this.workbenchFrame.getActiveInternalFrame();
        if (!this.workbenchFrame.hasInternalFrame(this)) {
            this.workbenchFrame.addInternalFrame(this, false, true);
        }
        if (activeFrame != null) {
            this.workbenchFrame.activateFrame(activeFrame);
        }
        this.moveToFront();
        int x = blackboard.get(BB_FEATUREINFO_WINDOW_POSITION_X, this.getLocation().x);
        int y = blackboard.get(BB_FEATUREINFO_WINDOW_POSITION_Y, this.getLocation().y);
        this.setLocation(x, y);
    }

    @Override
    public SelectionManager getSelectionManager() {
        return this.attributeTab.getPanel().getSelectionManager();
    }

    @Override
    public LayerNamePanel getLayerNamePanel() {
        return this.attributeTab;
    }

    @Override
    public LayerViewPanel getLayerViewPanel() {
        return this.getTaskFrame().getLayerViewPanel();
    }

    public void setRasterValues(String[] layerNames, String[] cellValues) {
        if (layerNames == null || cellValues == null || layerNames.length == 0 || cellValues.length == 0) {
            return;
        }
        this.rasterInfoTab.setRasterValues(layerNames, cellValues);
    }

    public void setWmsInfo(String string) {
        this.wmsInfoTab.setWmsInfoText(string);
    }

    @Override
    public JFrame getFrame() {
        DetachableInternalFrameWithProxies f = new DetachableInternalFrameWithProxies(this);
        f.setIconImage(ICON.getImage());
        return f;
    }

    private void savePositionAndSize() {
        blackboard.put(BB_FEATUREINFO_WINDOW_SIZE_WIDTH, this.getSize().width);
        blackboard.put(BB_FEATUREINFO_WINDOW_SIZE_HEIGHT, this.getSize().height);
        blackboard.put(BB_FEATUREINFO_WINDOW_POSITION_X, this.getLocation().x);
        blackboard.put(BB_FEATUREINFO_WINDOW_POSITION_Y, this.getLocation().y);
    }

    protected class WMSInfoTab
    extends JPanel {
        private final JEditorPane jEditorPane;
        private final JScrollPane jScrollPane;

        public WMSInfoTab() {
            this.setLayout(new BorderLayout());
            this.jEditorPane = new JEditorPane();
            this.jEditorPane.setEditable(false);
            this.jScrollPane = new JScrollPane(this.jEditorPane, 20, 30);
            this.add(this.jScrollPane);
        }

        public void setWmsInfoText(String wmsInfo) {
            this.jEditorPane.setText(wmsInfo);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    WMSInfoTab.this.jScrollPane.getHorizontalScrollBar().setValue(0);
                    WMSInfoTab.this.jScrollPane.getVerticalScrollBar().setValue(0);
                }
            });
        }
    }

    protected class RasterInfoTab
    extends JPanel {
        private DefaultTableModel tableModel;
        private final String[] columnNames = new String[]{"Layer", "Value"};
        JTable table = null;

        public RasterInfoTab(String[] layerNames, String[] cellValues) {
            if (layerNames == null || cellValues == null) {
                this.tableModel = new DefaultTableModel(this.columnNames, 0);
            } else {
                Object[][] data = new String[layerNames.length][2];
                for (int r = 0; r < data.length; ++r) {
                    data[r][0] = layerNames[r];
                    data[r][1] = cellValues[r];
                }
                this.tableModel = new DefaultTableModel(data, this.columnNames);
            }
            this.table = new JTable(this.tableModel);
            this.table.setFillsViewportHeight(true);
            JScrollPane jScrollPane = new JScrollPane();
            jScrollPane.setViewportView(this.table);
            this.add(jScrollPane);
        }

        public void setRasterValues(String[] layerNames, String[] cellValues) {
            Object[][] data = new String[layerNames.length][2];
            for (int r = 0; r < data.length; ++r) {
                data[r][0] = layerNames[r];
                data[r][1] = cellValues[r];
            }
            this.tableModel = new DefaultTableModel(data, this.columnNames);
            this.table.setModel(this.tableModel);
        }
    }

    public static class DetachableInternalFrameWithProxies
    extends JFrame
    implements LayerNamePanelProxy {
        private JInternalFrame frame;

        public DetachableInternalFrameWithProxies(JInternalFrame f) {
            this.setRootPane(f.getRootPane());
            this.frame = f;
        }

        @Override
        public LayerNamePanel getLayerNamePanel() {
            return this.frame instanceof LayerNamePanelProxy ? ((LayerNamePanelProxy)((Object)this.frame)).getLayerNamePanel() : null;
        }
    }
}

