/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.plugin;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.util.java2xml.Java2XML;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.Macro;
import com.vividsolutions.jump.workbench.plugin.MacroManager;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import com.vividsolutions.jump.workbench.ui.MultiInputDialog;
import java.io.File;
import javax.swing.JComponent;

public class StopMacroPlugIn
extends AbstractPlugIn
implements MacroManager {
    private static final String MACRO_NAME = I18N.getInstance().get("com.vividsolutions.jump.workbench.plugin.macro-name");
    private static final String MACRO_NAME_TOOLTIP = I18N.getInstance().get("com.vividsolutions.jump.workbench.plugin.macro-name-tooltip");

    @Override
    public void initialize(PlugInContext context) throws Exception {
        super.initialize(context);
        context.getFeatureInstaller().addMainMenuPlugin(this, new String[]{MenuNames.CUSTOMIZE, "Macro"}, this.getName() + "...", false, null, null, -1);
        new File("lib/ext/macro/").mkdir();
    }

    public static EnableCheck createEnableCheck(final WorkbenchContext workbenchContext) {
        return new EnableCheck(){

            @Override
            public String check(JComponent component) {
                Object obj = workbenchContext.getBlackboard().get("MacroStarted");
                if (obj == null || obj.equals(Boolean.FALSE)) {
                    return "Macro recording is already off";
                }
                return null;
            }
        };
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        if (context.getWorkbenchContext().getBlackboard().get("Macro") != null) {
            context.getWorkbenchContext().getBlackboard().put("MacroStarted", false);
            Macro processes = (Macro)context.getWorkbenchContext().getBlackboard().get("Macro");
            final MultiInputDialog dialog = new MultiInputDialog(context.getWorkbenchFrame(), this.getName(), true);
            context.getWorkbenchContext().getBlackboard().put("Macro", null);
            dialog.addTextField(MACRO_NAME, "Macro name", 16, new EnableCheck[]{new EnableCheck(){

                @Override
                public String check(JComponent component) {
                    if (!dialog.getText(MACRO_NAME).matches("[^\\?%*:|\"<>\\.]+")) {
                        return dialog.getText(MACRO_NAME) + " is not a valid macro name";
                    }
                    return null;
                }
            }}, MACRO_NAME_TOOLTIP);
            GUIUtil.centreOnWindow(dialog);
            dialog.setVisible(true);
            if (dialog.wasOKPressed()) {
                String name = dialog.getText(MACRO_NAME);
                Java2XML java2XML = new Java2XML();
                File file = new File("lib/ext/macro/" + name + ".ojm");
                file.getParentFile().mkdirs();
                new Java2XML().write((Object)processes, "processes", new File("lib/ext/macro/" + name + ".ojm"));
                return true;
            }
            return false;
        }
        return false;
    }
}

