/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.model;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.BasicFeature;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerManagerProxy;
import com.vividsolutions.jump.workbench.model.SystemLayerFinder;
import java.awt.Color;
import org.locationtech.jts.geom.Geometry;

public class FenceLayerFinder
extends SystemLayerFinder {
    public static final String LAYER_NAME = I18N.getInstance().get("model.FenceLayerFinder.fence");

    public FenceLayerFinder(LayerManagerProxy layerManagerProxy) {
        super(LAYER_NAME, layerManagerProxy);
    }

    public Geometry getFence() {
        if (this.getLayer() == null) {
            return null;
        }
        if (this.getLayer().getFeatureCollectionWrapper().isEmpty()) {
            return null;
        }
        return this.getLayer().getFeatureCollectionWrapper().iterator().next().getGeometry();
    }

    @Override
    protected void applyStyles(Layer layer) {
        layer.getBasicStyle().setLineColor(Color.blue);
        layer.getBasicStyle().setRenderingLine(true);
        layer.getBasicStyle().setRenderingFill(false);
        layer.setDrawingLast(true);
    }

    private Feature toFeature(Geometry fence, FeatureSchema schema) {
        BasicFeature feature = new BasicFeature(schema);
        feature.setGeometry(fence);
        return feature;
    }

    public void setFence(Geometry fence) {
        if (this.getLayer() == null) {
            this.createLayer();
        }
        if (fence != null) {
            this.getLayer().getFeatureCollectionWrapper().clear();
            this.getLayer().getFeatureCollectionWrapper().add(this.toFeature(fence, this.getLayer().getFeatureCollectionWrapper().getFeatureSchema()));
        }
    }
}

