/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.imagery.graphic;

import com.sun.media.jai.codec.ImageCodec;
import com.sun.media.jai.codec.SeekableStream;
import com.vividsolutions.jump.io.CompressedFile;
import com.vividsolutions.jump.workbench.imagery.ReferencedImageException;
import com.vividsolutions.jump.workbench.imagery.graphic.AbstractGraphicImage;
import com.vividsolutions.jump.workbench.imagery.graphic.WorldFile;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.net.URI;
import javax.media.jai.JAI;
import javax.media.jai.RenderedOp;
import org.locationtech.jts.geom.Envelope;

public class JAIGraphicImage
extends AbstractGraphicImage {
    protected String uri;
    protected BufferedImage image = null;
    protected WorldFile wf;
    protected boolean initialload;
    protected Envelope env;
    protected String type = null;

    public JAIGraphicImage(String location, WorldFile wf) {
        super(location, wf);
    }

    @Override
    protected void initImage() throws ReferencedImageException {
        BufferedImage image = this.getImage();
        if (image != null) {
            return;
        }
        InputStream is = null;
        InputStream is2 = null;
        try {
            RenderedOp src;
            URI uri = new URI(this.getUri());
            if (CompressedFile.isArchive(uri) || CompressedFile.isCompressed(uri)) {
                is = CompressedFile.openFile(uri);
                if (!(is instanceof SeekableStream)) {
                    is = SeekableStream.wrapInputStream((InputStream)is, (boolean)true);
                }
                src = JAI.create((String)"stream", (Object)is);
            } else {
                src = JAI.create((String)"fileload", (Object)uri.getPath());
            }
            this.setImage(src.getAsBufferedImage());
            JAIGraphicImage.close(is);
            is2 = CompressedFile.openFile(this.getUri());
            is2 = SeekableStream.wrapInputStream((InputStream)is2, (boolean)true);
            String[] decs = ImageCodec.getDecoderNames((SeekableStream)((SeekableStream)is2));
            if (decs.length > 0) {
                this.setType(decs[0]);
            }
            JAIGraphicImage.close(is2);
        }
        catch (Exception e) {
            try {
                throw new ReferencedImageException(e);
            }
            catch (Throwable throwable) {
                JAIGraphicImage.close(is);
                JAIGraphicImage.close(is2);
                throw throwable;
            }
        }
        JAIGraphicImage.close(is);
        JAIGraphicImage.close(is2);
    }
}

