/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.imagery.geoimg;

import com.sun.media.jai.codec.SeekableStream;
import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.util.FileUtil;
import com.vividsolutions.jump.workbench.JUMPWorkbench;
import com.vividsolutions.jump.workbench.Logger;
import com.vividsolutions.jump.workbench.imagery.ReferencedImageException;
import com.vividsolutions.jump.workbench.imagery.geoimg.GeoRaster;
import com.vividsolutions.jump.workbench.imagery.graphic.WorldFile;
import it.geosolutions.imageio.core.CoreCommonImageMetadata;
import it.geosolutions.imageio.gdalframework.GDALImageReaderSpi;
import it.geosolutions.imageio.gdalframework.GDALUtilities;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageReaderSpi;
import javax.media.jai.RenderedOp;
import org.libtiff.jai.codec.XTIFFDirectory;
import org.libtiff.jai.codec.XTIFFField;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;

public class GeoReferencedRaster
extends GeoRaster {
    private final String MSG_GENERAL = "This is not a valid GeoTIFF file.";
    Envelope envModel_image;
    Envelope envModel_image_backup;
    PixelType pixelType = PixelType.AREA;
    boolean honourNegativeScaleY = false;
    private Coordinate rasterULPixelCenter;
    private Coordinate modelULPixelCenter;
    private double scaleX;
    private double scaleY;

    public GeoReferencedRaster(String location) throws ReferencedImageException {
        this(location, null);
    }

    public GeoReferencedRaster(String location, Object reader) throws ReferencedImageException {
        super(location, reader);
        this.readRasterfile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseGeoTIFFDirectory(URI uri) throws ReferencedImageException {
        XTIFFField fieldModelTiePoints;
        XTIFFDirectory dir;
        block13: {
            dir = null;
            InputStream input = null;
            ReferencedImageException re = null;
            try {
                input = GeoReferencedRaster.createInputStream(uri);
                SeekableStream ss = SeekableStream.wrapInputStream((InputStream)input, (boolean)true);
                dir = XTIFFDirectory.create(ss, 0);
            }
            catch (IllegalArgumentException e) {
                re = new ReferencedImageException("probably no tiff image: " + e.getMessage());
            }
            catch (IOException e) {
                re = new ReferencedImageException("problem accessing tiff image: " + e.getMessage());
            }
            finally {
                GeoReferencedRaster.disposeInput(input);
                if (re == null) break block13;
                throw re;
            }
        }
        if ((fieldModelTiePoints = dir.getField(33922)) == null) {
            XTIFFField fieldModelGeoTransform = dir.getField(34264);
            if (fieldModelGeoTransform == null) {
                throw new ReferencedImageException("Missing tiepoints-tag and tranformation matrix-tag parameters in file.\nThis is not a valid GeoTIFF file.");
            }
            double[] tags = new double[]{fieldModelGeoTransform.getAsDouble(0), fieldModelGeoTransform.getAsDouble(1), fieldModelGeoTransform.getAsDouble(4), fieldModelGeoTransform.getAsDouble(5), fieldModelGeoTransform.getAsDouble(3), fieldModelGeoTransform.getAsDouble(7)};
            Logger.debug("gtiff transform: " + Arrays.toString(tags));
            this.setEnvelope(tags);
        } else if (fieldModelTiePoints.getType() == 12) {
            Coordinate imageCoord = new Coordinate(fieldModelTiePoints.getAsDouble(0), fieldModelTiePoints.getAsDouble(1));
            Coordinate modelCoord = new Coordinate(fieldModelTiePoints.getAsDouble(3), fieldModelTiePoints.getAsDouble(4));
            Logger.debug("gtiff tiepoints found : " + Arrays.toString(fieldModelTiePoints.getAsDoubles()));
            XTIFFField fieldModelPixelScale = dir.getField(33550);
            if (fieldModelPixelScale == null) {
                throw new ReferencedImageException("Missing pixelscale-tag in file.\nThis is not a valid GeoTIFF file.");
            }
            this.scaleX = fieldModelPixelScale.getAsDouble(0);
            this.scaleY = fieldModelPixelScale.getAsDouble(1);
            if (!this.honourNegativeScaleY) {
                this.scaleY = -Math.abs(this.scaleY);
            }
            Logger.debug("gtiff scale : scalex=" + this.scaleX + ", scaley=" + this.scaleY);
            double tx = modelCoord.x - this.scaleX * imageCoord.x;
            double ty = modelCoord.y - this.scaleY * imageCoord.y;
            Logger.debug("translation " + tx + " - " + ty);
            this.rasterULPixelCenter = this.pixelType == PixelType.AREA ? new Coordinate(0.5, 0.5) : new Coordinate(0.0, 0.0);
            this.modelULPixelCenter = new Coordinate(this.getScaleX() * this.rasterULPixelCenter.x + tx, this.getScaleY() * this.rasterULPixelCenter.y + ty);
            Logger.debug("model UL pixel center " + this.modelULPixelCenter);
            this.setEnvelope();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseGDALMetaData(URI uri) throws ReferencedImageException {
        if (!areGDALClassesAvailable || !GDALUtilities.isGDALAvailable()) {
            throw new ReferencedImageException("no gdal metadata available because gdal is not properly loaded.");
        }
        IOException ex = null;
        try {
            List<ImageReaderSpi> readers = GeoReferencedRaster.listValidImageIOReaders(uri, GDALImageReaderSpi.class);
            for (ImageReaderSpi readerSpi : readers) {
                Object input = GeoReferencedRaster.createInput(uri, readerSpi);
                ImageReader reader = readerSpi.createReaderInstance();
                IIOMetadata metadata = null;
                try {
                    reader.setInput(input);
                    metadata = reader.getImageMetadata(0);
                }
                catch (RuntimeException e) {
                    Logger.debug("fail " + readerSpi + "/" + input + " -> " + e);
                }
                finally {
                    reader.dispose();
                    GeoReferencedRaster.disposeInput(input);
                }
                if (!(metadata instanceof CoreCommonImageMetadata)) {
                    Logger.info("Unexpected error! Metadata should be an instance of the expected class: GDALCommonIIOImageMetadata.");
                    continue;
                }
                double[] geoTransform = ((CoreCommonImageMetadata)metadata).getGeoTransformation();
                Logger.debug("successfully retrieved gdal geo metadata: " + Arrays.toString(geoTransform));
                if (geoTransform == null || geoTransform.length != 6) continue;
                double[] tags = new double[]{geoTransform[1], geoTransform[4], geoTransform[2], geoTransform[5], geoTransform[0], geoTransform[3]};
                this.setEnvelope(tags);
                return;
            }
        }
        catch (IOException e1) {
            ex = e1;
        }
        throw new ReferencedImageException("no gdal metadata retrieved.", ex);
    }

    private void parseWorldFile() throws IOException {
        InputStream is = null;
        try {
            is = WorldFile.find(this.getURI().toString());
            List<String> lines = FileUtil.getContents(is);
            double[] tags = new double[6];
            for (int i = 0; i < 6; ++i) {
                String line = lines.get(i);
                tags[i] = Double.parseDouble(line);
            }
            Logger.debug("worldfile: " + Arrays.toString(tags));
            if (this.pixelType == PixelType.AREA) {
                tags[4] = tags[4] - tags[0] * 0.5;
                tags[5] = tags[5] - tags[3] * 0.5;
            }
            this.setEnvelope(tags);
        }
        catch (IOException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                FileUtil.close(is);
                throw throwable;
            }
        }
        FileUtil.close(is);
    }

    @Override
    protected void readRasterfile() throws ReferencedImageException {
        super.readRasterfile();
        URI uri = this.getURI();
        try {
            this.parseWorldFile();
            Logger.debug("Worldfile geo metadata fetched.");
            return;
        }
        catch (IOException e) {
            Logger.debug("Worldfile geo metadata unavailable: " + e.getMessage());
            try {
                this.parseGDALMetaData(uri);
                Logger.debug("GDAL geo metadata fetched.");
                return;
            }
            catch (ReferencedImageException e2) {
                Logger.debug("GDAL geo metadata unavailable: " + e2.getMessage());
                try {
                    this.parseGeoTIFFDirectory(uri);
                    if (this.envModel_image != null) {
                        Logger.debug("XTIFF geo metadata fetched.");
                        return;
                    }
                }
                catch (ReferencedImageException e3) {
                    Logger.debug("XTIFF geo metadata unavailable: " + e3.getMessage());
                }
                Logger.info("No georeference found! Will use default 0,0 placement.");
                JUMPWorkbench.getInstance().getFrame().warnUser(I18N.getInstance().get(this.getClass().getName() + ".no-georeference-found"));
                double[] tags = new double[]{1.0, 0.0, 0.0, -1.0, 0.0, 0.0};
                this.setEnvelope(tags);
                return;
            }
        }
    }

    private void setEnvelope(double[] tags) {
        AffineTransform transform = new AffineTransform(tags);
        this.scaleX = transform.getScaleX();
        this.scaleY = transform.getScaleY();
        double offset = this.pixelType == PixelType.AREA ? 0.5 : 0.0;
        Point2D.Double rasterLT = new Point2D.Double((double)this.src.getMinX() + offset, (double)this.src.getMinY() + offset);
        Point2D.Double modelLT = new Point2D.Double();
        transform.transform(rasterLT, modelLT);
        Logger.debug("setEnvelope " + rasterLT + " -> " + modelLT);
        this.rasterULPixelCenter = new Coordinate(((Point2D)rasterLT).getX(), ((Point2D)rasterLT).getY());
        this.modelULPixelCenter = new Coordinate(((Point2D)modelLT).getX(), ((Point2D)modelLT).getY());
        this.setEnvelope();
    }

    void setEnvelope() {
        double ulx = this.rasterULPixelCenter.x - 0.5;
        double uly = this.rasterULPixelCenter.y - 0.5;
        Coordinate imageEnvelopeBL = new Coordinate(ulx, uly + (double)this.src.getHeight());
        Coordinate imageEnvelopeTR = new Coordinate(ulx + (double)this.src.getWidth(), uly);
        Logger.debug("Image envelope " + ulx + "," + uly + "," + (ulx + (double)this.src.getWidth()) + "," + (uly + (double)this.src.getHeight()));
        Coordinate modelEnvelopeBL = this.rasterToModelSpace(imageEnvelopeBL);
        Coordinate modelEnvelopeTR = this.rasterToModelSpace(imageEnvelopeTR);
        Logger.debug("Model envelope " + modelEnvelopeBL.x + "," + modelEnvelopeTR.y + "," + modelEnvelopeTR.x + "," + modelEnvelopeBL.y);
        this.envModel_image_backup = this.envModel_image = new Envelope(modelEnvelopeBL, modelEnvelopeTR);
    }

    private Coordinate rasterToModelSpace(Coordinate coorRaster) {
        Coordinate coorModel = new Coordinate();
        coorModel.x = this.modelULPixelCenter.x + (coorRaster.x - this.rasterULPixelCenter.x) * this.scaleX;
        coorModel.y = this.modelULPixelCenter.y + (coorRaster.y - this.rasterULPixelCenter.y) * this.scaleY;
        coorModel.z = 0.0;
        return coorModel;
    }

    public Envelope getEnvelope() {
        return this.envModel_image;
    }

    public Envelope getOriginalEnvelope() {
        return this.envModel_image_backup;
    }

    public Coordinate getModelULPixelCenter() {
        return this.modelULPixelCenter;
    }

    @Deprecated
    public Coordinate getCoorRasterTiff_tiepointLT() {
        return this.rasterULPixelCenter;
    }

    public double getScaleX() {
        return this.scaleX;
    }

    public double getScaleY() {
        return this.scaleY;
    }

    public Envelope getEnvelope(Feature f) throws ReferencedImageException {
        Geometry rasterEnv;
        Geometry g;
        if (f != null && (g = f.getGeometry()) != null && !(rasterEnv = new GeometryFactory().toGeometry(this.getOriginalEnvelope())).equals(g)) {
            double xUnit;
            Envelope envGeom = g.getEnvelopeInternal();
            RenderedOp img = super.getRenderedOp();
            this.scaleX = xUnit = Math.abs(envGeom.getWidth() / (double)img.getWidth());
            double yUnit = Math.abs(envGeom.getHeight() / (double)img.getHeight());
            this.scaleY = -yUnit;
            this.envModel_image = new Envelope(envGeom);
            return this.envModel_image;
        }
        return this.getOriginalEnvelope();
    }

    public static enum PixelType {
        AREA,
        POINT;

    }
}

