/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.imagery.geoimg;

import com.sun.media.jai.codec.ImageCodec;
import com.sun.media.jai.codec.SeekableStream;
import com.vividsolutions.jump.io.CompressedFile;
import com.vividsolutions.jump.util.FileUtil;
import com.vividsolutions.jump.util.StringUtil;
import com.vividsolutions.jump.workbench.Logger;
import com.vividsolutions.jump.workbench.imagery.ReferencedImageException;
import com.vividsolutions.jump.workbench.imagery.geoimg.GeoImageFactory;
import com.vividsolutions.jump.workbench.model.Disposable;
import com.vividsolutions.jump.workbench.model.Prioritized;
import it.geosolutions.imageio.gdalframework.GDALImageReaderSpi;
import it.geosolutions.imageio.gdalframework.GDALUtilities;
import it.geosolutions.imageio.utilities.ImageIOUtilities;
import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.spi.IIORegistry;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;
import javax.media.jai.JAI;
import javax.media.jai.ParameterBlockJAI;
import javax.media.jai.RecyclingTileFactory;
import javax.media.jai.RenderedOp;
import javax.media.jai.TileCache;
import javax.media.jai.util.ImagingListener;
import org.gdal.gdal.gdal;

public class GeoRaster
implements Disposable {
    protected String imageFileLocation;
    private URI uri = null;
    protected Object fixed_reader = null;
    protected RenderedOp src = null;
    private ImageReader src_reader = null;
    private Object src_input = null;
    protected String type = null;
    protected Object used_loader = null;
    protected RenderingHints cache_hints;
    private TileCache cache;
    private RecyclingTileFactory rtf;
    double[] min;
    double[] max;
    static boolean areGDALClassesAvailable;
    private static LinkedHashMap<URI, List<ImageReaderSpi>> validIOReaderCache;

    public GeoRaster(String imageFileLocation) {
        this(imageFileLocation, null);
    }

    public GeoRaster(String imageFileLocation, Object fixed_reader) {
        this.imageFileLocation = imageFileLocation;
        this.fixed_reader = fixed_reader;
    }

    protected URI getURI() {
        return this.uri;
    }

    protected void fetchRaster() throws ReferencedImageException {
        List<Object> affirmed_readers;
        Logger.trace("imageFileLocation is -> " + this.imageFileLocation);
        try {
            this.uri = new URI(this.imageFileLocation);
            if (!this.uri.isAbsolute()) {
                throw new URISyntaxException(this.imageFileLocation, "missing scheme://");
            }
        }
        catch (URISyntaxException e) {
            Logger.trace("not an URI, will treat as path -> " + this.imageFileLocation, e);
            File file = new File(this.imageFileLocation);
            this.uri = file.toURI();
        }
        Logger.trace("uri is now -> " + this.uri.toString());
        if (!new File(this.uri).canRead()) {
            throw new ReferencedImageException("cannot read file -> " + this.imageFileLocation);
        }
        ImageReadParam param = new ImageReadParam();
        ParameterBlockJAI pbjImageRead = new ParameterBlockJAI("ImageRead");
        pbjImageRead.setParameter("readParam", (Object)param);
        if (this.fixed_reader == null) {
            affirmed_readers = new ArrayList<ImageReaderSpi>(GeoRaster.listValidImageIOReaders(this.uri, null));
            Collections.sort(affirmed_readers, new Comparator<ImageReaderSpi>(){

                @Override
                public int compare(final ImageReaderSpi o1, final ImageReaderSpi o2) {
                    Prioritized p1 = new Prioritized(){

                        @Override
                        public int getPriority() {
                            return GeoImageFactory.getPriority(o1);
                        }
                    };
                    Prioritized p2 = new Prioritized(){

                        @Override
                        public int getPriority() {
                            return GeoImageFactory.getPriority(o2);
                        }
                    };
                    return Prioritized.COMPARATOR.compare(p1, p2);
                }
            });
        } else {
            affirmed_readers = this.fixed_reader instanceof ImageReaderSpi ? Collections.singletonList((ImageReaderSpi)this.fixed_reader) : Collections.emptyList();
        }
        ListIterator i = affirmed_readers.listIterator();
        while (i.hasNext()) {
            ImageReaderSpi readerSpi = (ImageReaderSpi)i.next();
            Logger.trace("Trying reader " + GeoImageFactory.loaderString(readerSpi));
            try {
                this.src_input = GeoRaster.createInput(this.uri, readerSpi);
                this.src_reader = readerSpi.createReaderInstance();
                this.src_reader.setInput(this.src_input);
                pbjImageRead.setParameter("Input", this.src_input);
                pbjImageRead.setParameter("Reader", (Object)this.src_reader);
                this.src = JAI.create((String)"ImageRead", (ParameterBlock)pbjImageRead, null);
                if (this.src != null && this.src.getWidth() > 0) {
                    this.type = this.src_reader.getFormatName();
                    this.used_loader = this.src_reader;
                    return;
                }
                this.dispose();
            }
            catch (Exception e) {
                if (this.fixed_reader != null && this.fixed_reader == readerSpi) {
                    throw new ReferencedImageException(e);
                }
                Logger.trace(e);
                this.dispose();
            }
        }
        try {
            if (this.fixed_reader == null || this.fixed_reader instanceof ImageCodec) {
                this.createJAIRenderedOP(this.uri, (ImageCodec)this.fixed_reader);
            }
        }
        catch (IOException e) {
            throw new ReferencedImageException(e);
        }
        if (this.src != null) {
            return;
        }
        this.dispose();
        throw new ReferencedImageException("no one wants to decode me.");
    }

    protected void readRasterfile() throws ReferencedImageException {
        this.fetchRaster();
        this.normalize(this.src);
    }

    protected void normalize(RenderedOp image) {
    }

    @Deprecated
    public RenderedOp getImage() throws ReferencedImageException {
        return this.getRenderedOp();
    }

    public RenderedOp getRenderedOp() throws ReferencedImageException {
        if (this.src == null) {
            this.readRasterfile();
        }
        return this.src;
    }

    public RenderedOp fullContrast() {
        int bands = this.src.getNumBands();
        double[] constants = new double[bands];
        double[] offsets = new double[bands];
        for (int i = 0; i < bands; ++i) {
            constants[i] = 306.0 / (this.max[i] - this.min[i]);
            offsets[i] = 255.0 * this.min[i] / (this.min[i] - this.max[i]);
        }
        ParameterBlock pb = new ParameterBlock();
        pb.addSource(this.src);
        pb.add(constants);
        pb.add(offsets);
        return JAI.create((String)"rescale", (ParameterBlock)pb, null);
    }

    public double[] getMinimumExtreme() {
        return this.min;
    }

    public double[] getMaximumExtreme() {
        return this.max;
    }

    protected String getType() {
        return this.type;
    }

    protected Object getLoader() {
        return this.used_loader;
    }

    public RenderingHints createCacheRenderingHints() {
        if (this.src instanceof RenderedOp && this.src.getWidth() > 2000 && this.src.getHeight() > 2000 && this.cache_hints == null) {
            this.cache = JAI.createTileCache((long)0x4000000L);
            this.cache_hints = new RenderingHints(JAI.KEY_TILE_CACHE, this.cache);
            this.rtf = new RecyclingTileFactory();
            this.cache_hints.put(JAI.KEY_TILE_CACHE, this.cache);
            this.cache_hints.put(JAI.KEY_TILE_FACTORY, this.rtf);
            this.cache_hints.put(JAI.KEY_TILE_RECYCLER, this.rtf);
            this.cache_hints.put(JAI.KEY_CACHED_TILE_RECYCLING_ENABLED, Boolean.TRUE);
        }
        return this.cache_hints != null ? (RenderingHints)this.cache_hints.clone() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createJAIRenderedOP(URI uri, ImageCodec codec) throws IOException {
        String[] decs;
        Object input = GeoRaster.createInput(uri);
        if (codec instanceof ImageCodec) {
            SeekableStream is2 = SeekableStream.wrapInputStream((InputStream)GeoRaster.createInputStream(uri), (boolean)true);
            decs = ImageCodec.getDecoderNames((SeekableStream)is2);
            GeoRaster.disposeInput(is2);
        } else {
            decs = new String[]{};
        }
        ArrayList<ImageCodec> removed_codecs = new ArrayList<ImageCodec>();
        try {
            for (String name : decs) {
                ImageCodec candidate_codec = ImageCodec.getCodec((String)name);
                if (codec.getClass().isAssignableFrom(candidate_codec.getClass())) continue;
                ImageCodec.unregisterCodec((String)name);
                removed_codecs.add(candidate_codec);
            }
            if (input instanceof InputStream) {
                if (!(input instanceof SeekableStream)) {
                    input = SeekableStream.wrapInputStream((InputStream)((InputStream)input), (boolean)true);
                }
                this.src = JAI.create((String)"stream", (Object)input);
            } else {
                this.src = JAI.create((String)"fileload", (Object)uri.getPath());
            }
            this.type = codec.getFormatName();
            this.used_loader = codec;
        }
        finally {
            for (ImageCodec imageCodec : removed_codecs) {
                ImageCodec.registerCodec((ImageCodec)imageCodec);
            }
        }
    }

    @Override
    public void dispose() {
        if (this.src instanceof RenderedImage) {
            if (areGDALClassesAvailable) {
                ImageIOUtilities.disposeImage((RenderedImage)this.src);
            }
            this.src = null;
        }
        if (this.src_reader instanceof ImageReader) {
            this.src_reader.reset();
            this.src_reader.dispose();
            this.src_reader = null;
        }
        GeoRaster.disposeInput(this.src_input);
        if (this.cache instanceof TileCache) {
            this.cache.flush();
        }
        if (this.rtf instanceof RecyclingTileFactory) {
            this.rtf.flush();
        }
    }

    protected static boolean hasFileExtension(ImageReaderSpi provider, URI uri) {
        String path = CompressedFile.getTargetFileWithPath(uri);
        String ext = CompressedFile.getExtension(path);
        return GeoRaster.hasFileExtension(provider, ext);
    }

    protected static boolean hasFileExtension(ImageReaderSpi provider, String ext) {
        return Arrays.asList(provider.getFileSuffixes()).contains(ext);
    }

    protected static boolean hasNoFileExtensions(ImageReaderSpi provider) {
        String[] exts = provider.getFileSuffixes();
        return exts.length == 0 || exts.length == 1 && exts[0] instanceof String && exts[0].trim().isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static List<ImageReaderSpi> listValidImageIOReaders(URI uri, Class filter) {
        GeoRaster.resetGDALReaderSelection();
        Iterator<ImageReaderSpi> iter = IIORegistry.getDefaultInstance().getServiceProviders(ImageReaderSpi.class, false);
        Vector<ImageReaderSpi> affirmed_readers = new Vector();
        while (iter.hasNext()) {
            ImageReaderSpi provider = iter.next();
            if (filter != null && !filter.isInstance(provider) || areGDALClassesAvailable && provider instanceof GDALImageReaderSpi && !((GDALImageReaderSpi)provider).isAvailable()) continue;
            Object input = null;
            boolean canDec = false;
            try {
                input = GeoRaster.createInput(uri, provider);
                canDec = provider.canDecodeInput(input);
            }
            catch (Exception e) {
                Logger.debug(e);
                continue;
            }
            finally {
                GeoRaster.disposeInput(input);
                continue;
            }
            boolean hasNoExts = GeoRaster.hasNoFileExtensions(provider);
            boolean hasExt = GeoRaster.hasFileExtension(provider, uri);
            if (!canDec && !hasExt) continue;
            affirmed_readers.add(provider);
        }
        affirmed_readers = Collections.unmodifiableList(affirmed_readers);
        validIOReaderCache.put(uri, affirmed_readers);
        return affirmed_readers;
    }

    protected static List<ImageCodec> listValidJAICodecs(URI uri) throws IOException {
        InputStream is = GeoRaster.createInputStream(uri);
        SeekableStream ss = SeekableStream.wrapInputStream((InputStream)is, (boolean)true);
        String[] decs = ImageCodec.getDecoderNames((SeekableStream)ss);
        GeoRaster.disposeInput(ss);
        GeoRaster.disposeInput(is);
        ArrayList<ImageCodec> l = new ArrayList<ImageCodec>();
        for (String dec : decs) {
            ImageCodec c = ImageCodec.getCodec((String)dec);
            l.add(c);
        }
        return l;
    }

    public static List<Object> listValidReaders(URI uri) throws IOException {
        ArrayList<Object> l = new ArrayList<Object>(GeoRaster.listValidImageIOReaders(uri, null));
        l.addAll(GeoRaster.listValidJAICodecs(uri));
        return l;
    }

    public static List<Object> listAllReaders() {
        ArrayList<Object> loaders = new ArrayList<Object>();
        Iterator<ImageReaderSpi> iter = IIORegistry.getDefaultInstance().getServiceProviders(ImageReaderSpi.class, true);
        while (iter.hasNext()) {
            ImageReaderSpi provider = iter.next();
            Logger.trace("GeoRaster.listAllReaders(): " + provider.toString());
            if (areGDALClassesAvailable && provider instanceof GDALImageReaderSpi && !((GDALImageReaderSpi)provider).isAvailable()) {
                Logger.trace("unavailable");
                continue;
            }
            Logger.trace("added");
            loaders.add(provider);
        }
        loaders.addAll(Collections.list(ImageCodec.getCodecs()));
        return loaders;
    }

    protected static Object createInput(URI uri) throws IOException {
        return GeoRaster.createInput(uri, null);
    }

    protected static Object createInput(URI uri, Object loader) throws IOException {
        Object input;
        if (CompressedFile.isArchive(uri) || CompressedFile.isCompressed(uri)) {
            InputStream src_is = CompressedFile.openFile(uri);
            src_is = new BufferedInputStream(src_is);
            input = src_is;
        } else {
            input = new File(uri);
        }
        if (loader == null) {
            return input;
        }
        if (loader instanceof ImageReaderSpi) {
            Class<?>[] clazzes = ((ImageReaderSpi)loader).getInputTypes();
            ArrayList intypes = clazzes != null ? Arrays.asList(clazzes) : new ArrayList();
            for (Class clazz : intypes) {
                ImageInputStream iis;
                if (clazz.isInstance(input)) {
                    return input;
                }
                if (!ImageInputStream.class.equals((Object)clazz) || (iis = ImageIO.createImageInputStream(input)) == null) continue;
                return iis;
            }
            throw new IOException("Couldn't create an input for '" + uri + "' accepted (" + StringUtil.toCommaDelimitedString(intypes) + ")by reader '" + loader + "'");
        }
        return input;
    }

    protected static InputStream createInputStream(URI uri) throws IOException {
        Object in = GeoRaster.createInput(uri);
        if (in instanceof String) {
            in = new File((String)in);
        }
        if (in instanceof File) {
            in = new FileInputStream((File)in);
        }
        return (InputStream)in;
    }

    protected static void disposeInput(Object input) {
        if (input instanceof Closeable) {
            FileUtil.close((Closeable)input);
        }
    }

    static void resetGDALReaderSelection() {
        if (!areGDALClassesAvailable || !GDALUtilities.isGDALAvailable()) {
            return;
        }
        gdal.SetConfigOption((String)"GDAL_SKIP", (String)"");
        gdal.AllRegister();
    }

    static {
        JAI.getDefaultInstance().setImagingListener(new ImagingListener(){

            public boolean errorOccurred(String msg, Throwable thrown, Object where, boolean isRetryable) throws RuntimeException {
                Logger.error(thrown);
                return false;
            }
        });
        areGDALClassesAvailable = false;
        try {
            Class.forName("it.geosolutions.imageio.gdalframework.GDALImageReaderSpi");
            Class.forName("it.geosolutions.imageio.gdalframework.GDALUtilities");
            Class.forName("it.geosolutions.imageio.utilities.ImageIOUtilities");
            areGDALClassesAvailable = true;
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            Logger.debug(e);
        }
        validIOReaderCache = new LinkedHashMap<URI, List<ImageReaderSpi>>(){

            @Override
            protected boolean removeEldestEntry(Map.Entry<URI, List<ImageReaderSpi>> arg0) {
                return this.size() > 10;
            }
        };
    }
}

