/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.imagery.geoimg;

import com.sun.media.jai.codec.ImageCodec;
import com.vividsolutions.jump.workbench.Logger;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.imagery.ReferencedImage;
import com.vividsolutions.jump.workbench.imagery.geoimg.GeoImage;
import com.vividsolutions.jump.workbench.imagery.graphic.AbstractGraphicImageFactory;
import com.vividsolutions.jump.workbench.imagery.imageio.JP2GDALEcwImageReaderSpi;
import com.vividsolutions.jump.workbench.imagery.imageio.JP2GDALJasperImageReaderSpi;
import com.vividsolutions.jump.workbench.imagery.imageio.JP2GDALOpenJPEGImageReaderSpi;
import it.geosolutions.imageio.gdalframework.GDALImageReaderSpi;
import java.io.File;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Locale;
import javax.imageio.ImageIO;
import javax.imageio.spi.IIORegistry;
import javax.imageio.spi.ImageReaderSpi;
import org.geotiff.image.jai.GeoTIFFDescriptor;

public class GeoImageFactory
extends AbstractGraphicImageFactory {
    Object loader = null;
    static boolean classGDALImageReaderSpiAvailable = false;

    public void setLoader(Object loader) {
        this.loader = loader;
    }

    public Object getLoader() {
        return this.loader;
    }

    public GeoImageFactory() {
        try {
            IIORegistry.getDefaultInstance().registerServiceProvider((Object)new JP2GDALOpenJPEGImageReaderSpi());
            IIORegistry.getDefaultInstance().registerServiceProvider((Object)new JP2GDALEcwImageReaderSpi());
            IIORegistry.getDefaultInstance().registerServiceProvider((Object)new JP2GDALJasperImageReaderSpi());
        }
        catch (NoClassDefFoundError e) {
            Logger.error("Can't register JP2GDAL readers.", e);
        }
        Iterator<ImageReaderSpi> iter = IIORegistry.getDefaultInstance().getServiceProviders(ImageReaderSpi.class, true);
        while (iter.hasNext()) {
            ImageReaderSpi reader = iter.next();
            Logger.trace("GeoImageFactory - add " + GeoImageFactory.loaderString(reader) + " " + reader.getClass().getCanonicalName());
            String[] exts = reader.getFileSuffixes();
            if (exts.length == 0 || exts.length == 1 && exts[0] instanceof String && exts[0].trim().isEmpty()) {
                this.addExtension("*");
                continue;
            }
            this.addExtensions(Arrays.asList(exts));
        }
        Enumeration e = ImageCodec.getCodecs();
        while (e.hasMoreElements()) {
            ImageCodec codec = (ImageCodec)e.nextElement();
            String ext = codec.getFormatName().toLowerCase();
            this.addExtension(ext);
        }
    }

    public GeoImageFactory(Object loader) {
        this.loader = loader;
        if (loader instanceof ImageCodec) {
            String ext = ((ImageCodec)loader).getFormatName().toLowerCase();
            this.addExtension(ext);
        } else if (loader instanceof ImageReaderSpi) {
            ImageReaderSpi reader = (ImageReaderSpi)loader;
            String[] exts = reader.getFileSuffixes();
            if (exts.length == 0 || exts.length == 1 && exts[0] instanceof String && exts[0].trim().isEmpty()) {
                this.addExtension("*");
            } else {
                this.addExtensions(Arrays.asList(exts));
            }
        }
    }

    @Override
    public String getTypeName() {
        return "Referenced Image";
    }

    @Override
    public ReferencedImage createImage(String location) throws Exception {
        GeoImage img = new GeoImage(location, this.loader);
        return img;
    }

    @Override
    public String getDescription() {
        return this.getTypeName() + " " + GeoImageFactory.loaderString(this.loader);
    }

    public static String loaderString(Object loader) {
        if (loader != null) {
            String loaderString = "";
            if (loader instanceof ImageReaderSpi) {
                try {
                    loaderString = ((ImageReaderSpi)loader).getDescription(Locale.getDefault());
                    loaderString = loaderString.replace("Java Advanced Imaging Image I/O Tools", "ImageIO");
                }
                catch (NoSuchMethodError e) {
                    loaderString = loader.getClass().getSimpleName();
                    loaderString = loaderString.replace("ImageReaderSpi", "");
                    loaderString = loaderString + " (" + loader.getClass().getPackage().getName() + ")";
                }
                if (classGDALImageReaderSpiAvailable && loader instanceof GDALImageReaderSpi) {
                    loaderString = "GDAL " + loaderString;
                }
                if (!loaderString.toLowerCase().contains("version")) {
                    loaderString = loaderString + ", version " + ((ImageReaderSpi)loader).getVersion();
                }
                loaderString = loaderString + ", " + ((ImageReaderSpi)loader).getVendorName();
            } else {
                loaderString = loader instanceof ImageCodec ? "JAI " + ((ImageCodec)loader).getFormatName().toUpperCase() : loader.getClass().getName();
            }
            return "(" + loaderString + ")";
        }
        return "(ImageIO[ext],JAI)";
    }

    @Override
    public int getPriority() {
        if (this.loader == null) {
            return Integer.MAX_VALUE;
        }
        return GeoImageFactory.getPriority(this.loader);
    }

    public static int getPriority(Object loader) {
        String name = loader.getClass().getName();
        if (name.equals("com.vividsolutions.jump.workbench.imagery.imageio.JP2GDALOpenJPEGImageReaderSpi")) {
            return 10;
        }
        if (name.equals("com.vividsolutions.jump.workbench.imagery.imageio.JP2GDALEcwImageReaderSpi")) {
            return 15;
        }
        if (name.equals("it.geosolutions.imageio.plugins.jp2ecw.JP2GDALEcwImageReaderSpi")) {
            return Integer.MAX_VALUE;
        }
        if (name.startsWith("com.vividsolutions.jump.workbench.imagery")) {
            return 20;
        }
        if (name.startsWith("com.github.jaiimageio")) {
            return 30;
        }
        if (name.startsWith("it.geosolutions.imageio")) {
            if (classGDALImageReaderSpiAvailable && loader instanceof GDALImageReaderSpi) {
                return 45;
            }
            return 40;
        }
        if (name.startsWith("com.sun.media.imageio")) {
            return 60;
        }
        if (loader instanceof ImageReaderSpi) {
            return 80;
        }
        return 100;
    }

    @Override
    public boolean isAvailable(WorkbenchContext context) {
        File temp;
        try {
            Class<?> c = this.getClass().getClassLoader().loadClass("javax.media.jai.JAI");
            Class<?> c2 = this.getClass().getClassLoader().loadClass("com.sun.media.jai.codec.ImageCodec");
            if (c == null || c2 == null) {
                return false;
            }
        }
        catch (ClassNotFoundException e) {
            Logger.error(e);
            return false;
        }
        if (ImageCodec.getCodec((String)"xtiff") == null) {
            GeoTIFFDescriptor.register();
        }
        if ((temp = new File(System.getProperty("java.io.tmpdir"))).isDirectory() && temp.exists()) {
            ImageIO.setCacheDirectory(temp);
            ImageIO.setUseCache(true);
        }
        return true;
    }

    static {
        try {
            Class.forName("it.geosolutions.imageio.gdalframework.GDALImageReaderSpi");
            classGDALImageReaderSpiAvailable = true;
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            Logger.debug(e);
        }
    }
}

