/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.plugin.edit;

import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.util.CoordinateArrays;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineSegment;
import org.locationtech.jts.geom.LineString;

public class SegmentsExtracter {
    private static final GeometryFactory factory = new GeometryFactory();
    private Map<LineSegment, SegmentCount> segmentMap = new TreeMap<LineSegment, SegmentCount>();
    private Map<LineSegment, List<Feature>> sourceMap;
    private boolean countZeroLengthSegments = true;
    private TaskMonitor monitor;
    private Geometry fence = null;
    private boolean normalize = false;

    public SegmentsExtracter() {
    }

    public SegmentsExtracter(TaskMonitor monitor) {
        this.monitor = monitor;
        this.countZeroLengthSegments = true;
    }

    public SegmentsExtracter(TaskMonitor monitor, boolean countZeroLengthSegments) {
        this.monitor = monitor;
        this.countZeroLengthSegments = countZeroLengthSegments;
    }

    public void setFence(Geometry fence) {
        this.fence = fence;
    }

    public SegmentsExtracter normalizeSegments() {
        this.normalize = true;
        return this;
    }

    public SegmentsExtracter keepSource() {
        this.sourceMap = new HashMap<LineSegment, List<Feature>>();
        return this;
    }

    public void add(FeatureCollection fc) {
        this.monitor.allowCancellationRequests();
        int totalFeatures = fc.size();
        int j = 0;
        for (Feature feature : fc.getFeatures()) {
            if (this.monitor.isCancelRequested()) break;
            this.monitor.report(++j, totalFeatures, "features");
            this.add(feature);
        }
    }

    public void add(Feature f) {
        Geometry g = f.getGeometry();
        if (this.fence != null && !g.intersects(this.fence)) {
            return;
        }
        List<Coordinate[]> coordArrays = CoordinateArrays.toCoordinateArrays(g, true);
        for (Coordinate[] coordArray : coordArrays) {
            for (int j = 0; j < coordArray.length - 1; ++j) {
                LineString segLine;
                if (this.fence != null && !this.fence.intersects((Geometry)(segLine = factory.createLineString(new Coordinate[]{coordArray[j], coordArray[j + 1]})))) continue;
                this.add(f, coordArray[j], coordArray[j + 1]);
            }
        }
    }

    public void add(Feature f, Coordinate p0, Coordinate p1) {
        SegmentCount count;
        boolean isZeroLength = p0.equals((Object)p1);
        if (!this.countZeroLengthSegments && isZeroLength) {
            return;
        }
        LineSegment lineseg = new LineSegment(p0, p1);
        if (this.normalize) {
            lineseg.normalize();
        }
        if ((count = this.segmentMap.get(lineseg)) == null) {
            this.segmentMap.put(lineseg, new SegmentCount(1));
        } else {
            count.increment();
        }
        if (this.sourceMap != null) {
            List<Feature> features = this.sourceMap.get(lineseg);
            if (features == null) {
                features = new ArrayList<Feature>();
            }
            features.add(f);
            this.sourceMap.put(lineseg, features);
        }
    }

    public Collection<LineSegment> getSegments() {
        return this.segmentMap.keySet();
    }

    public Collection<LineSegment> getAllSegments() {
        ArrayList<LineSegment> list = new ArrayList<LineSegment>(this.segmentMap.size());
        for (Map.Entry<LineSegment, SegmentCount> entry : this.segmentMap.entrySet()) {
            for (int i = 0; i < entry.getValue().count; ++i) {
                list.add(entry.getKey());
            }
        }
        return list;
    }

    public Collection<LineSegment> getSegments(int minOccurs, int maxOccurs) {
        ArrayList<LineSegment> segmentList = new ArrayList<LineSegment>();
        for (Map.Entry<LineSegment, SegmentCount> entry : this.segmentMap.entrySet()) {
            LineSegment ls = entry.getKey();
            int count = entry.getValue().getCount();
            if (count < minOccurs || count > maxOccurs) continue;
            segmentList.add(ls);
        }
        return segmentList;
    }

    public Map<LineSegment, List<Feature>> getSegmentSource() {
        return this.sourceMap;
    }

    public List<Feature> getSegmentSource(LineSegment lineSegment) {
        return this.sourceMap.get(lineSegment);
    }

    public class SegmentCount {
        private int count = 0;

        public SegmentCount(int value) {
            this.count = value;
        }

        public int getCount() {
            return this.count;
        }

        public void increment() {
            ++this.count;
        }
    }
}

