/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.geom;

import com.vividsolutions.jump.geom.LineSegmentEnvelopeIntersector;
import org.locationtech.jts.algorithm.locate.SimplePointInAreaLocator;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryComponentFilter;
import org.locationtech.jts.geom.Polygon;

public class EnvelopeIntersector {
    private static final LineSegmentEnvelopeIntersector lineSegmentEnvelopeIntersector = new LineSegmentEnvelopeIntersector();

    public static boolean intersects(Geometry geometry, Envelope envelope) {
        if (envelope.isNull()) {
            return false;
        }
        if (!envelope.intersects(geometry.getEnvelopeInternal())) {
            return false;
        }
        if (geometry instanceof GeometryCollection) {
            GeometryCollection gc = (GeometryCollection)geometry;
            for (int i = 0; i < gc.getNumGeometries(); ++i) {
                if (!EnvelopeIntersector.intersects(gc.getGeometryN(i), envelope)) continue;
                return true;
            }
            return false;
        }
        if (EnvelopeIntersector.intersectsBoundary(geometry, envelope)) {
            return true;
        }
        if (geometry instanceof Polygon) {
            return EnvelopeIntersector.contains((Polygon)geometry, new Coordinate(envelope.getMinX(), envelope.getMinY()));
        }
        return false;
    }

    private static boolean contains(Polygon polygon, Coordinate c) {
        return SimplePointInAreaLocator.containsPointInPolygon((Coordinate)c, (Polygon)polygon);
    }

    private static boolean intersectsBoundary(Geometry geometry, final Envelope envelope) {
        final BooleanWrapper intersects = new BooleanWrapper(false);
        geometry.apply(new GeometryComponentFilter(){

            public void filter(Geometry geometry) {
                Coordinate[] coordinates = geometry.getCoordinates();
                if (intersects.value) {
                    return;
                }
                if (envelope.contains(coordinates[0])) {
                    intersects.value = true;
                }
                for (int i = 1; i < coordinates.length; ++i) {
                    if (!EnvelopeIntersector.intersectsLineSegment(coordinates[i], coordinates[i - 1], envelope)) continue;
                    intersects.value = true;
                }
            }
        });
        return intersects.value;
    }

    private static boolean intersectsLineSegment(Coordinate a, Coordinate b, Envelope envelope) {
        return lineSegmentEnvelopeIntersector.touches(a, b, envelope);
    }

    private static class BooleanWrapper {
        public boolean value;

        public BooleanWrapper(boolean value) {
            this.value = value;
        }
    }
}

