/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.datastore.spatialite;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.datastore.AdhocQuery;
import com.vividsolutions.jump.datastore.FilterQuery;
import com.vividsolutions.jump.datastore.SpatialReferenceSystemID;
import com.vividsolutions.jump.datastore.spatialdatabases.SpatialDatabasesDSConnection;
import com.vividsolutions.jump.datastore.spatialdatabases.SpatialDatabasesSQLBuilder;
import com.vividsolutions.jump.datastore.spatialite.SpatialiteDSMetadata;
import com.vividsolutions.jump.datastore.spatialite.SpatialiteFeatureInputStream;
import com.vividsolutions.jump.datastore.spatialite.SpatialiteSQLBuilder;
import com.vividsolutions.jump.datastore.spatialite.SpatialiteValueConverterFactory;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.io.FeatureInputStream;
import java.sql.Connection;
import java.sql.SQLException;

public class SpatialiteDSConnection
extends SpatialDatabasesDSConnection {
    public SpatialiteDSConnection(Connection con) {
        super(con);
        this.dbMetadata = new SpatialiteDSMetadata(this);
    }

    @Override
    public SpatialDatabasesSQLBuilder getSqlBuilder(SpatialReferenceSystemID srid, String[] colNames) {
        return new SpatialiteSQLBuilder((SpatialiteDSMetadata)this.dbMetadata, srid, colNames);
    }

    @Override
    public FeatureInputStream executeFilterQuery(FilterQuery query) throws SQLException {
        SpatialReferenceSystemID srid = this.dbMetadata.getSRID(query.getDatasetName(), query.getGeometryAttributeName());
        String[] colNames = this.dbMetadata.getColumnNames(query.getDatasetName());
        SpatialiteSQLBuilder builder = (SpatialiteSQLBuilder)this.getSqlBuilder(srid, colNames);
        String queryString = builder.getSQL(query);
        SpatialiteFeatureInputStream fis = new SpatialiteFeatureInputStream(this.connection, queryString, query.getPrimaryKey());
        fis.setMetadata((SpatialiteDSMetadata)this.dbMetadata);
        return fis;
    }

    @Override
    public FeatureInputStream executeAdhocQuery(AdhocQuery query) throws Exception {
        FeatureSchema fs;
        String queryString = query.getQuery();
        SpatialiteFeatureInputStream ifs = new SpatialiteFeatureInputStream(this.connection, queryString, query.getPrimaryKey());
        ifs.setMetadata((SpatialiteDSMetadata)this.dbMetadata);
        try {
            fs = ifs.getFeatureSchema();
        }
        catch (Exception e) {
            throw new Exception(I18N.getInstance().get(SpatialDatabasesDSConnection.class.getName() + ".SQL-error") + e.getMessage());
        }
        if (fs.getGeometryIndex() < 0) {
            throw new Exception(I18N.getInstance().get(SpatialDatabasesDSConnection.class.getName() + ".resultset-must-have-a-geometry-column"));
        }
        return ifs;
    }

    @Override
    public SpatialiteValueConverterFactory getValueConverterFactory() {
        return new SpatialiteValueConverterFactory(this.connection);
    }
}

