/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.datastore.spatialdatabases;

import com.vividsolutions.jump.datastore.DataStoreConnection;
import com.vividsolutions.jump.datastore.DataStoreLayer;
import com.vividsolutions.jump.datastore.DataStoreMetadata;
import com.vividsolutions.jump.datastore.GeometryColumn;
import com.vividsolutions.jump.datastore.PrimaryKeyColumn;
import com.vividsolutions.jump.datastore.SQLUtil;
import com.vividsolutions.jump.datastore.SpatialReferenceSystemID;
import com.vividsolutions.jump.datastore.jdbc.JDBCUtil;
import com.vividsolutions.jump.datastore.jdbc.ResultSetBlock;
import com.vividsolutions.jump.feature.AttributeType;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.workbench.Logger;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.WKBReader;
import org.locationtech.jts.io.WKTReader;

public class SpatialDatabasesDSMetadata
implements DataStoreMetadata {
    protected final WKBReader reader = new WKBReader();
    protected final WKTReader txtReader = new WKTReader();
    protected DataStoreConnection conn;
    protected Map<String, SpatialReferenceSystemID> sridMap = new HashMap<String, SpatialReferenceSystemID>();
    protected String datasetNameQuery = null;
    protected String defaultSchemaName = null;
    protected String spatialDbName = null;
    protected String spatialExtentQuery1 = null;
    protected String spatialExtentQuery2 = null;
    protected String geoColumnsQuery = null;
    protected String sridQuery = null;
    protected String coordDimQuery = null;
    protected String datasetInfoQuery = null;
    protected ArrayList<DataStoreLayer> dataStoreLayers = null;

    public SpatialDatabasesDSMetadata() {
    }

    public SpatialDatabasesDSMetadata(DataStoreConnection conn) {
        this.conn = conn;
        this.datasetNameQuery = "";
        this.defaultSchemaName = "";
        this.spatialDbName = "";
        this.spatialExtentQuery1 = "";
        this.spatialExtentQuery2 = "";
        this.geoColumnsQuery = "";
        this.sridQuery = "";
        this.dataStoreLayers = new ArrayList();
    }

    public String getDatasetNameQuery() {
        return this.datasetNameQuery;
    }

    public String getDefaultSchemaName() {
        return this.defaultSchemaName;
    }

    public String getSpatialDbName() {
        return this.spatialDbName;
    }

    public String getSpatialExtentQuery1(String schema, String table, String attributeName) {
        return null;
    }

    public String getSpatialExtentQuery2(String schema, String table, String attributeName) {
        return null;
    }

    public String getGeoColumnsQuery(String datasetName) {
        return String.format(this.geoColumnsQuery, datasetName);
    }

    public String getSridQuery(String schemaName, String tableName, String colName) {
        return String.format(this.sridQuery, schemaName, tableName, colName);
    }

    public String getCoordinateDimensionQuery(String schemaName, String tableName, String colName) {
        return String.format(this.coordDimQuery, schemaName, tableName, colName);
    }

    public String getDatasetInfoQuery() {
        return this.datasetInfoQuery;
    }

    public ArrayList<DataStoreLayer> getDataStoreLayers() {
        return this.dataStoreLayers;
    }

    protected String getSchemaName(String tableName) {
        int dotPos = tableName.indexOf(".");
        String schema = this.defaultSchemaName;
        if (dotPos != -1) {
            schema = tableName.substring(0, dotPos);
        }
        return schema;
    }

    protected String getTableName(String tableName) {
        int dotPos = tableName.indexOf(".");
        String ret = tableName;
        if (dotPos != -1) {
            ret = tableName.substring(dotPos + 1);
        }
        return ret;
    }

    protected boolean missingGeoException(Exception e) {
        return e instanceof SQLException && e.getMessage().contains("geometry_columns");
    }

    @Override
    public String[] getDatasetNames() {
        final ArrayList datasetNames = new ArrayList();
        this.dataStoreLayers = new ArrayList();
        try {
            JDBCUtil.execute(this.conn.getJdbcConnection(), this.getDatasetInfoQuery(), new ResultSetBlock(){

                @Override
                public void yield(ResultSet resultSet) throws SQLException {
                    while (resultSet.next()) {
                        String schema = resultSet.getString(1);
                        String table = resultSet.getString(2);
                        if (!schema.equalsIgnoreCase(SpatialDatabasesDSMetadata.this.getDefaultSchemaName())) {
                            table = schema + "." + table;
                        }
                        if (!datasetNames.contains(table)) {
                            datasetNames.add(table);
                        }
                        GeometryColumn geo = new GeometryColumn(resultSet.getString(3), resultSet.getInt(4), resultSet.getInt(5), resultSet.getString(6));
                        SpatialDatabasesDSMetadata.this.dataStoreLayers.add(new DataStoreLayer(table, geo));
                    }
                }
            });
        }
        catch (Exception e) {
            if (this.missingGeoException(e)) {
                Logger.error("not a " + this.getSpatialDbName() + " db or bad search_path", e);
            }
            e.printStackTrace();
        }
        return datasetNames.toArray(new String[datasetNames.size()]);
    }

    @Override
    public synchronized Envelope getExtents(String datasetName, String attributeName) {
        Envelope[] e;
        block5: {
            String table;
            String schema;
            e = new Envelope[]{null};
            if (datasetName.indexOf(46) != -1) {
                String[] parts = datasetName.split("\\.", 2);
                schema = parts[0];
                table = parts[1];
            } else {
                schema = this.defaultSchemaName;
                table = datasetName;
            }
            String sql1 = this.getSpatialExtentQuery1(schema, table, attributeName);
            String sql2 = this.getSpatialExtentQuery2(schema, table, attributeName);
            ResultSetBlock resultSetBlock = new ResultSetBlock(){

                @Override
                public void yield(ResultSet resultSet) throws Exception {
                    if (resultSet.next()) {
                        byte[] bytes = null;
                        Geometry geom = null;
                        try {
                            bytes = (byte[])resultSet.getObject(1);
                            if (bytes != null) {
                                geom = SpatialDatabasesDSMetadata.this.reader.read(bytes);
                            }
                        }
                        catch (Exception e2) {
                            geom = SpatialDatabasesDSMetadata.this.txtReader.read(resultSet.getString(1));
                        }
                        if (geom != null) {
                            e[0] = geom.getEnvelopeInternal();
                        }
                    }
                }
            };
            try {
                JDBCUtil.execute(this.conn.getJdbcConnection(), sql1, resultSetBlock);
                if (e[0] == null || e[0].isNull()) {
                    JDBCUtil.execute(this.conn.getJdbcConnection(), sql2, resultSetBlock);
                }
            }
            catch (Exception ex1) {
                if (sql2 == null) break block5;
                JDBCUtil.execute(this.conn.getJdbcConnection(), sql2, resultSetBlock);
            }
        }
        return e[0];
    }

    @Override
    public List<GeometryColumn> getGeometryAttributes(String datasetName) {
        String sql = this.getGeoColumnsQuery(datasetName);
        return this.getGeometryAttributes(sql, datasetName);
    }

    protected List<GeometryColumn> getGeometryAttributes(String sql, String datasetName) {
        final ArrayList<GeometryColumn> geometryAttributes = new ArrayList<GeometryColumn>();
        JDBCUtil.execute(this.conn.getJdbcConnection(), sql, new ResultSetBlock(){

            @Override
            public void yield(ResultSet resultSet) throws SQLException {
                while (resultSet.next()) {
                    geometryAttributes.add(new GeometryColumn(resultSet.getString(1), resultSet.getInt(2), resultSet.getInt(3), resultSet.getString(4)));
                }
            }
        });
        return geometryAttributes;
    }

    @Override
    public List<PrimaryKeyColumn> getPrimaryKeyColumns(String datasetName) throws SQLException {
        ArrayList<PrimaryKeyColumn> identifierColumns = new ArrayList<PrimaryKeyColumn>();
        ResultSet rs = null;
        try {
            ResultSet rs2;
            DatabaseMetaData dbMd = this.conn.getJdbcConnection().getMetaData();
            rs = dbMd.getPrimaryKeys(null, this.getSchemaName(datasetName), this.getTableName(datasetName));
            while (rs.next()) {
                String colName = rs.getString(4);
                rs2 = dbMd.getColumns(null, this.getSchemaName(datasetName), this.getTableName(datasetName), colName);
                rs2.next();
                String colType = rs2.getString(6);
                identifierColumns.add(new PrimaryKeyColumn(colName, colType));
                rs2.close();
            }
            rs = dbMd.getTables(null, this.getSchemaName(datasetName), this.getTableName(datasetName), null);
            while (rs.next()) {
                String tableType = rs.getString(4);
                if (!tableType.equals("VIEW")) continue;
                rs2 = dbMd.getColumns(null, this.getSchemaName(datasetName), this.getTableName(datasetName), null);
                while (rs2.next()) {
                    PrimaryKeyColumn pk = new PrimaryKeyColumn(rs2.getString(4), rs2.getString(6));
                    if (pk.getType() != 12 && pk.getType() != 4 && pk.getType() != -5) continue;
                    identifierColumns.add(pk);
                }
            }
        }
        catch (SQLException sqle) {
            throw sqle;
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException sQLException) {}
        }
        return identifierColumns;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized String[] getColumnNames(String datasetName) {
        ArrayList<String> cols = new ArrayList<String>();
        ResultSet rs = null;
        try {
            DatabaseMetaData dbMd = this.conn.getJdbcConnection().getMetaData();
            rs = dbMd.getColumns(null, this.getSchemaName(datasetName), this.getTableName(datasetName), null);
            while (rs.next()) {
                cols.add(rs.getString(4));
            }
        }
        catch (SQLException sQLException) {
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException sQLException) {}
        }
        return cols.toArray(new String[cols.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isIndexed(String dsName, String column) throws SQLException {
        ResultSet rs = null;
        boolean ret = false;
        String schemaName = this.getSchemaName(dsName);
        String tableName = this.getTableName(dsName);
        try {
            DatabaseMetaData dbMd = this.conn.getJdbcConnection().getMetaData();
            rs = dbMd.getIndexInfo(null, schemaName, tableName, false, true);
            while (rs.next()) {
                if (!column.equals(rs.getString(9)) || rs.getString(6) == null || rs.getString(9) == null) continue;
                ret = true;
                break;
            }
        }
        catch (SQLException sqle) {
            sqle.printStackTrace();
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException sQLException) {}
        }
        return ret;
    }

    @Override
    public SpatialReferenceSystemID getSRID(String datasetName, String colName) throws SQLException {
        String key = datasetName + "#" + colName;
        if (!this.sridMap.containsKey(key)) {
            String srid = this.querySRID(datasetName, colName);
            this.sridMap.put(key, new SpatialReferenceSystemID(srid));
        }
        return this.sridMap.get(key);
    }

    protected String querySRID(String datasetName, String colName) {
        final StringBuffer srid = new StringBuffer();
        String sql = this.getSridQuery(this.getSchemaName(datasetName), this.getTableName(datasetName), colName);
        JDBCUtil.execute(this.conn.getJdbcConnection(), sql, new ResultSetBlock(){

            @Override
            public void yield(ResultSet resultSet) throws SQLException {
                if (resultSet.next()) {
                    String s = resultSet.getString(1);
                    srid.append(s == null ? "0" : s);
                }
            }
        });
        return srid.toString();
    }

    public int getCoordinateDimension(String datasetName, String colName) {
        final StringBuffer coordDim = new StringBuffer();
        String sql = this.getCoordinateDimensionQuery(this.getSchemaName(datasetName), this.getTableName(datasetName), colName);
        JDBCUtil.execute(this.conn.getJdbcConnection(), sql, new ResultSetBlock(){

            @Override
            public void yield(ResultSet resultSet) throws SQLException {
                if (resultSet.next()) {
                    String s = resultSet.getString(1);
                    coordDim.append(s == null ? "2" : s);
                }
            }
        });
        return Integer.parseInt(coordDim.toString());
    }

    @Override
    public DataStoreConnection getDataStoreConnection() {
        return this.conn;
    }

    public String getCreateTableStatement(FeatureSchema fSchema, String schemaName, String tableName, boolean normalizeColumnNames) {
        return "CREATE TABLE " + SQLUtil.compose(schemaName, tableName) + " (" + this.createColumnList(fSchema, true, false, false, true, normalizeColumnNames) + ");";
    }

    public String createColumnList(FeatureSchema schema, boolean includeSQLDataType, boolean includeGeometry, boolean includeExternalPK, boolean includeReadOnly, boolean normalizeColumnNames) {
        StringBuilder sb = new StringBuilder();
        int count = 0;
        for (int i = 0; i < schema.getAttributeCount(); ++i) {
            String name;
            AttributeType type = schema.getAttributeType(i);
            if (type == AttributeType.GEOMETRY && !includeGeometry || !includeExternalPK && schema.getExternalPrimaryKeyIndex() == i || !includeReadOnly && schema.getExternalPrimaryKeyIndex() != i && schema.isAttributeReadOnly(i)) continue;
            String string = name = normalizeColumnNames ? SQLUtil.normalize(schema.getAttributeName(i)) : schema.getAttributeName(i);
            if (0 < count++) {
                sb.append(", ");
            }
            sb.append("\"").append(name).append("\"");
            if (!includeSQLDataType) continue;
            sb.append(" ").append(this.getDbTypeName(type));
        }
        return sb.toString();
    }

    public String getAddSpatialIndexStatement(String schemaName, String tableName, String geometryColumn) {
        return ";";
    }

    public String getAddGeometryColumnStatement(String schemaName, String tableName, String geometryColumn, int srid, String geometryType, int dim) {
        if (schemaName == null) {
            return "SELECT AddGeometryColumn('" + tableName + "','" + geometryColumn + "'," + srid + ",'" + geometryType.toUpperCase() + "'," + dim + ");";
        }
        return "SELECT AddGeometryColumn('" + schemaName + "','" + tableName + "','" + geometryColumn + "'," + srid + ",'" + geometryType.toUpperCase() + "'," + dim + ");";
    }

    protected String getDbTypeName(AttributeType type) {
        if (type == AttributeType.GEOMETRY) {
            return "varbinary";
        }
        if (type == AttributeType.STRING) {
            return "varchar";
        }
        if (type == AttributeType.INTEGER) {
            return "integer";
        }
        if (type == AttributeType.LONG) {
            return "bigint";
        }
        if (type == AttributeType.DOUBLE) {
            return "double precision";
        }
        if (type == AttributeType.NUMERIC) {
            return "numeric";
        }
        if (type == AttributeType.DATE) {
            return "timestamp";
        }
        if (type == AttributeType.BOOLEAN) {
            return "boolean";
        }
        if (type == AttributeType.OBJECT) {
            return "varbinary";
        }
        return "varchar";
    }

    private static class ColumnNameBlock
    implements ResultSetBlock {
        List colList = new ArrayList();
        String[] colName;

        private ColumnNameBlock() {
        }

        @Override
        public void yield(ResultSet resultSet) throws SQLException {
            while (resultSet.next()) {
                this.colList.add(resultSet.getString(1));
            }
            this.colName = this.colList.toArray(new String[this.colList.size()]);
        }
    }
}

