/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.util;

import com.vividsolutions.jump.workbench.Logger;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class UriUtil {
    static final String charSet = "UTF-8";
    static final String regexp = "^([^:/]+://)(?:(([^@:/]*)(?:\\:([^@:/]*))?)@)?((.*?)(?::(\\d+))?(/.*))$";

    private UriUtil() {
    }

    public static URI createZipUri(File file, String entry) {
        try {
            URI fileUri = file.toURI();
            String filePath = fileUri.getPath();
            URI uri = new URI("zip", null, filePath + "!/" + entry, null);
            return uri;
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Cannot create URI for " + file + "!/" + entry);
        }
    }

    public static URI createZipUri(String file, String entry) {
        return UriUtil.createZipUri(new File(file), entry);
    }

    public static URI createFileUri(String file) {
        return new File(file).toURI();
    }

    public static File getZipFile(URI uri) {
        try {
            URI fileUri = new URI("file", null, UriUtil.getZipFilePath(uri), null);
            return new File(fileUri);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static String getZipFilePath(URI uri) {
        String path = uri.getPath();
        int index = path.indexOf(33);
        return index < 0 ? path : path.substring(0, index);
    }

    public static String getZipFileName(URI uri) {
        String path = UriUtil.getZipFilePath(uri);
        int index = path.lastIndexOf(47);
        return index < 0 ? path : path.substring(index + 1);
    }

    public static String getZipEntryName(URI uri) {
        String path = uri.getPath();
        int index = path.indexOf(33);
        if (index == -1) {
            return null;
        }
        return path.substring(index + 2);
    }

    public static String getFileExtension(URI uri) {
        String path = uri.getPath();
        int dotIndex = path.lastIndexOf(46);
        if (dotIndex != -1) {
            return path.substring(dotIndex + 1);
        }
        return "";
    }

    public static String getFileName(URI uri) {
        return UriUtil.getZipFileName(uri);
    }

    public static String getFileNameWithoutExtension(URI uri) {
        String name = UriUtil.getFileName(uri);
        int dotIndex = name.lastIndexOf(46);
        if (dotIndex != -1) {
            return name.substring(0, dotIndex);
        }
        return "";
    }

    public static String getZipEntryFilePath(URI uri) {
        String name = UriUtil.getZipEntryName(uri);
        int slashIndex = name.lastIndexOf(47);
        if (slashIndex != -1) {
            return name.substring(0, slashIndex);
        }
        return null;
    }

    public static String getFilePath(URI uri) {
        return UriUtil.getZipFilePath(uri);
    }

    public static String getFileName(String path) {
        int slashIndex = path.lastIndexOf(47);
        return slashIndex > -1 ? path.substring(slashIndex) : path;
    }

    public static String getPath(String path) {
        int slashIndex = path.lastIndexOf(47);
        return slashIndex > -1 ? path.substring(0, slashIndex) : "";
    }

    public static String removeExtension(String path) {
        int dotIndex;
        int slashIndex = path.lastIndexOf(47);
        return slashIndex < (dotIndex = path.lastIndexOf(46)) ? path.substring(0, dotIndex) : path;
    }

    public static String urlEncode(String in) {
        try {
            return URLEncoder.encode(in, charSet);
        }
        catch (Exception e) {
            Logger.error(e);
            return in;
        }
    }

    public static String urlDecode(String in) {
        try {
            return URLDecoder.decode(in, charSet);
        }
        catch (Exception e) {
            Logger.error(e);
            return in;
        }
    }

    public static boolean isURL(String in) {
        Pattern p = Pattern.compile(regexp);
        Matcher m = p.matcher(in != null ? in : "");
        return m.matches();
    }

    public static String urlStripAuth(String url) {
        String clean = UriUtil.isURL(url) ? url.replaceFirst(regexp, "$1$5") : url;
        return clean;
    }

    public static String urlGetUser(String url) {
        if (UriUtil.isURL(url)) {
            return UriUtil.urlDecode(url.replaceFirst(regexp, "$3"));
        }
        return "";
    }

    public static String urlGetPassword(String url) {
        if (UriUtil.isURL(url)) {
            return UriUtil.urlDecode(url.replaceFirst(regexp, "$4"));
        }
        return "";
    }

    public static String urlGetUserInfo(String url) {
        if (UriUtil.isURL(url)) {
            return url.replaceFirst(regexp, "$2");
        }
        return "";
    }

    public static String urlGetHost(String url) {
        if (UriUtil.isURL(url)) {
            return UriUtil.urlDecode(url.replaceFirst(regexp, "$6"));
        }
        return "";
    }

    public static String urlGetPort(String url) {
        if (UriUtil.isURL(url)) {
            return UriUtil.urlDecode(url.replaceFirst(regexp, "$7"));
        }
        return "";
    }

    public static String urlGetPath(String url) {
        if (UriUtil.isURL(url)) {
            return UriUtil.urlDecode(url.replaceFirst(regexp, "$8"));
        }
        return "";
    }

    public static String urlStripPassword(String url) {
        String user = UriUtil.urlGetUser(url);
        if (!user.isEmpty()) {
            user = user + "@";
        }
        String clean = UriUtil.isURL(url) ? url.replaceFirst(regexp, "$1" + user + "$5") : url;
        return clean;
    }

    public static String urlAddCredentials(String url, String user, String pass) {
        String urlCreds;
        if (!UriUtil.isURL(url)) {
            return url;
        }
        String string = urlCreds = user != null ? UriUtil.urlEncode(user) : "";
        if (!urlCreds.isEmpty()) {
            String urlPass;
            String string2 = urlPass = pass != null ? UriUtil.urlEncode(pass) : "";
            if (!urlPass.isEmpty()) {
                urlCreds = urlCreds + ":" + urlPass;
            }
        }
        return UriUtil.urlAddUserInfo(url, urlCreds);
    }

    public static String urlMakeAppendSafe(String url) {
        String fixedURL = url.trim();
        if (!fixedURL.contains("?")) {
            fixedURL = fixedURL + "?";
        } else if (!fixedURL.endsWith("?") && !fixedURL.endsWith("&")) {
            fixedURL = fixedURL + "&";
        }
        return fixedURL;
    }

    public static String urlAddUserInfo(String url, String userinfo) {
        if (!UriUtil.isURL(url)) {
            return url;
        }
        if (userinfo == null || userinfo.isEmpty()) {
            return url;
        }
        return url.replaceFirst(regexp, "$1" + userinfo + "@$5");
    }

    public static Map<String, String> getParameters(URI uri) {
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
        String query = uri.getRawQuery();
        if (query != null && !query.isEmpty()) {
            String[] pairs;
            for (String pair : pairs = query.split("&")) {
                if (!pair.contains("=")) continue;
                String[] param = pair.split("=", 2);
                parameters.put(param[0], UriUtil.urlDecode(param[1]));
            }
        }
        return parameters;
    }
}

