/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.sextante.gui.additionalResults;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.workbench.JUMPWorkbench;
import com.vividsolutions.jump.workbench.Logger;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Task;
import com.vividsolutions.jump.workbench.ui.FeatureCollectionPanel;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.HTMLPanel;
import com.vividsolutions.jump.workbench.ui.WorkbenchFrame;
import it.betastudio.adbtoolbox.libs.DxfExport;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import javax.imageio.ImageIO;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import javax.xml.namespace.QName;
import org.apache.batik.dom.svg.SVGDOMImplementation;
import org.apache.batik.svggen.SVGGraphics2D;
import org.math.plot.PlotPanel;
import org.math.plot.plots.Plot;
import org.openjump.core.apitools.IOTools;
import org.openjump.core.ui.io.file.FileNameExtensionFilter;
import org.openjump.core.ui.util.LayerableUtil;
import org.openjump.sextante.core.ObjectAndDescription;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;

public class AdditionalResultsIO {
    private static final String sSaved = I18N.getInstance().get("org.openjump.core.ui.plugin.raster.RasterImageLayerPropertiesPlugIn.file.saved");
    private static final String SCouldNotSave = I18N.getInstance().get("org.openjump.sextante.gui.additionalResults.AdditionalResultsPlugIn.Could-not-save-selected-result");
    static WorkbenchFrame frame = JUMPWorkbench.getInstance().getFrame();
    static WorkbenchContext wContext = frame.getContext();
    public static final String HEIGHT = I18N.getInstance().get("org.openjump.core.ui.plugin.raster.ProfileGraphTool.values");
    public static final String WIDTH = I18N.getInstance().get("org.openjump.core.ui.plugin.raster.ProfileGraphTool.2d-distance");

    public static void save(TreePath m_Path) {
        if (m_Path != null) {
            try {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)m_Path.getLastPathComponent();
                ObjectAndDescription oad = (ObjectAndDescription)node.getUserObject();
                Component c = (Component)oad.getObject();
                if (c instanceof FeatureCollectionPanel) {
                    FeatureCollectionPanel panel = (FeatureCollectionPanel)c;
                    FeatureCollection fcoll = panel.getFeatureCollection();
                    FileNameExtensionFilter filter2 = new FileNameExtensionFilter("Comma-Separated Values (csv)", "csv");
                    FileNameExtensionFilter filter3 = new FileNameExtensionFilter("JUMP Markup Language (JML)", "jml");
                    FileNameExtensionFilter filter = new FileNameExtensionFilter("ESRI Shapefile (SHP)", "shp");
                    GUIUtil.FileChooserWithOverwritePrompting fc = new GUIUtil.FileChooserWithOverwritePrompting();
                    if (!LayerableUtil.isMixedGeometryType(fcoll)) {
                        fc.setFileFilter(filter);
                    }
                    fc.setFileFilter(filter3);
                    fc.setFileFilter(filter2);
                    fc.addChoosableFileFilter(filter2);
                    int returnVal = fc.showSaveDialog(frame);
                    if (returnVal == 0) {
                        if (fc.getFileFilter().equals(filter3)) {
                            File file = new File(((JFileChooser)fc).getSelectedFile() + ".jml");
                            IOTools.saveJMLFile(fcoll, file.getAbsolutePath());
                            AdditionalResultsIO.saved(file);
                        } else if (fc.getFileFilter().equals(filter)) {
                            File file = new File(((JFileChooser)fc).getSelectedFile() + ".shp");
                            IOTools.saveShapefile(fcoll, file.getAbsolutePath());
                            AdditionalResultsIO.saved(file);
                        } else if (fc.getFileFilter().equals(filter2)) {
                            JTable table = panel.getTable();
                            File file = new File(((JFileChooser)fc).getSelectedFile() + ".csv");
                            IOTools.saveCSV(table, file.getAbsolutePath());
                            AdditionalResultsIO.saved(file);
                        }
                    }
                } else if (c instanceof JScrollPane) {
                    JScrollPane pane = (JScrollPane)c;
                    Component view = pane.getViewport().getView();
                    if (view instanceof JTextPane || view instanceof JLabel || view instanceof JTextArea) {
                        JTextPane text = (JTextPane)pane.getViewport().getView();
                        GUIUtil.FileChooserWithOverwritePrompting fc = new GUIUtil.FileChooserWithOverwritePrompting("html");
                        FileNameExtensionFilter filter = new FileNameExtensionFilter("HTML", "html");
                        fc.setFileFilter(filter);
                        fc.addChoosableFileFilter(filter);
                        int returnVal = fc.showSaveDialog(frame);
                        fc.getWidth();
                        fc.getHeight();
                        if (returnVal == 0) {
                            try {
                                File file = new File(((JFileChooser)fc).getSelectedFile() + ".html");
                                file.getParent();
                                FileWriter fileWriter = new FileWriter(file);
                                BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
                                bufferedWriter.write(text.getText());
                                bufferedWriter.close();
                                AdditionalResultsIO.saved(file);
                            }
                            catch (Exception e) {
                                AdditionalResultsIO.notsaved();
                            }
                        }
                    } else if (view instanceof JTable) {
                        JTable table = (JTable)pane.getViewport().getView();
                        FileNameExtensionFilter filter = new FileNameExtensionFilter("Comma-Separated Values (csv)", "csv");
                        GUIUtil.FileChooserWithOverwritePrompting fc = new GUIUtil.FileChooserWithOverwritePrompting("csv");
                        fc.setFileFilter(filter);
                        fc.addChoosableFileFilter(filter);
                        int returnVal = fc.showSaveDialog(frame);
                        fc.getWidth();
                        fc.getHeight();
                        if (returnVal == 0) {
                            File file = new File(((JFileChooser)fc).getSelectedFile() + ".csv");
                            IOTools.saveCSV(table, file.getAbsolutePath());
                        } else if (returnVal == 1) {
                            return;
                        }
                    } else if (view instanceof JPanel) {
                        JPanel panel = (JPanel)pane.getViewport().getView();
                        int w = panel.getWidth();
                        int h = panel.getHeight();
                        BufferedImage bi = new BufferedImage(w, h, 1);
                        Graphics2D g = bi.createGraphics();
                        panel.paint(g);
                        FileNameExtensionFilter filter = new FileNameExtensionFilter("Portable Network Graphics (png)", "png");
                        GUIUtil.FileChooserWithOverwritePrompting fc = new GUIUtil.FileChooserWithOverwritePrompting("png");
                        FileNameExtensionFilter filter3 = new FileNameExtensionFilter("Scalable Vector Graphics (svg)", "svg");
                        fc.setFileFilter(filter);
                        fc.setFileFilter(filter3);
                        fc.addChoosableFileFilter(filter);
                        int returnVal = fc.showSaveDialog(frame);
                        fc.getWidth();
                        fc.getHeight();
                        if (returnVal == 0) {
                            if (fc.getFileFilter().equals(filter)) {
                                try {
                                    File file = new File(((JFileChooser)fc).getSelectedFile() + ".png");
                                    ImageIO.write((RenderedImage)bi, "png", file);
                                    AdditionalResultsIO.saved(file);
                                }
                                catch (Exception e) {
                                    AdditionalResultsIO.notsaved();
                                }
                            } else if (fc.getFileFilter().equals(filter3)) {
                                File file = new File(((JFileChooser)fc).getSelectedFile() + ".svg");
                                file.getParent();
                                AdditionalResultsIO.saveAsSVG(panel, file);
                                AdditionalResultsIO.saved(file);
                            }
                        }
                    }
                } else if (c instanceof PlotPanel) {
                    PlotPanel panel = (PlotPanel)c;
                    FileNameExtensionFilter filter = new FileNameExtensionFilter("Portable Network Graphics (png)", "png");
                    FileNameExtensionFilter filter2 = new FileNameExtensionFilter("Drawing Interchange Format(dxf)", "dxf");
                    FileNameExtensionFilter filterSVG = new FileNameExtensionFilter("Scalable Vector Graphics (svg)", "svg");
                    GUIUtil.FileChooserWithOverwritePrompting fc = new GUIUtil.FileChooserWithOverwritePrompting();
                    if (oad.getDescription().contains(I18N.getInstance().get("org.openjump.core.ui.plugin.raster.ProfileGraphTool.Profile-Plot"))) {
                        fc.setFileFilter(filter2);
                    }
                    fc.setFileFilter(filter);
                    if (AdditionalResultsIO.CheckSVGLibs()) {
                        fc.setFileFilter(filterSVG);
                    }
                    fc.addChoosableFileFilter(filter);
                    int returnVal = fc.showSaveDialog(frame);
                    fc.getWidth();
                    fc.getHeight();
                    if (returnVal == 0) {
                        if (fc.getFileFilter().equals(filter)) {
                            File file = new File(((JFileChooser)fc).getSelectedFile() + ".png");
                            file.getParent();
                            panel.toGraphicFile(file);
                            AdditionalResultsIO.saved(file);
                        } else if (fc.getFileFilter().equals(filter2)) {
                            File file = new File(((JFileChooser)fc).getSelectedFile() + ".dxf");
                            file.getParent();
                            double[][] pointsOfProfile = null;
                            for (Plot plot : panel.getPlots()) {
                                pointsOfProfile = plot.getData();
                            }
                            frame.setCursor(new Cursor(3));
                            AdditionalResultsIO.exportToDxf(file.getAbsolutePath(), pointsOfProfile);
                            frame.setCursor(new Cursor(0));
                            AdditionalResultsIO.saved(file);
                        } else if (fc.getFileFilter().equals(filterSVG)) {
                            File file = new File(((JFileChooser)fc).getSelectedFile() + ".svg");
                            file.getParent();
                            AdditionalResultsIO.saveAsSVG((Component)panel.plotCanvas, file);
                            AdditionalResultsIO.saved(file);
                        }
                    }
                } else if (c instanceof JTable) {
                    JTable table = (JTable)c;
                    FileNameExtensionFilter filter = new FileNameExtensionFilter("Comma-Separated Values (csv)", "csv");
                    GUIUtil.FileChooserWithOverwritePrompting fc = new GUIUtil.FileChooserWithOverwritePrompting("csv");
                    fc.setFileFilter(filter);
                    fc.addChoosableFileFilter(filter);
                    int returnVal = fc.showSaveDialog(frame);
                    fc.getWidth();
                    fc.getHeight();
                    if (returnVal == 0) {
                        File file = new File(((JFileChooser)fc).getSelectedFile() + ".csv");
                        IOTools.saveCSV(table, file.getAbsolutePath());
                    } else if (returnVal == 1) {
                        return;
                    }
                } else if (c instanceof HTMLPanel) {
                    HTMLPanel panel = (HTMLPanel)c;
                    String text = panel.lastString();
                    FileNameExtensionFilter filter = new FileNameExtensionFilter("HTML", "html");
                    GUIUtil.FileChooserWithOverwritePrompting fc = new GUIUtil.FileChooserWithOverwritePrompting("html");
                    fc.setFileFilter(filter);
                    fc.addChoosableFileFilter(filter);
                    int returnVal = fc.showSaveDialog(frame);
                    fc.getWidth();
                    fc.getHeight();
                    if (returnVal == 0) {
                        try {
                            File file = new File(((JFileChooser)fc).getSelectedFile() + ".html");
                            file.getParent();
                            FileWriter fileWriter = new FileWriter(file);
                            BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
                            bufferedWriter.write(text);
                            bufferedWriter.close();
                            AdditionalResultsIO.saved(file);
                        }
                        catch (Exception e) {
                            AdditionalResultsIO.notsaved();
                        }
                    }
                } else if (c instanceof JPanel) {
                    JPanel panel = (JPanel)c;
                    int w = panel.getWidth();
                    int h = panel.getHeight();
                    BufferedImage bi = new BufferedImage(w, h, 1);
                    Graphics2D g = bi.createGraphics();
                    panel.paint(g);
                    FileNameExtensionFilter filter = new FileNameExtensionFilter("Portable Network Graphics (png)", "png");
                    FileNameExtensionFilter filterSVG = new FileNameExtensionFilter("Scalable Vector Graphics (svg)", "svg");
                    GUIUtil.FileChooserWithOverwritePrompting fc = new GUIUtil.FileChooserWithOverwritePrompting("png");
                    fc.setFileFilter(filter);
                    if (AdditionalResultsIO.CheckSVGLibs()) {
                        fc.setFileFilter(filterSVG);
                    }
                    fc.addChoosableFileFilter(filter);
                    int returnVal = fc.showSaveDialog(frame);
                    fc.getWidth();
                    fc.getHeight();
                    if (returnVal == 0) {
                        if (fc.getFileFilter().equals(filter)) {
                            try {
                                File file = new File(((JFileChooser)fc).getSelectedFile() + ".png");
                                ImageIO.write((RenderedImage)bi, "png", file);
                                AdditionalResultsIO.saved(file);
                            }
                            catch (Exception e) {
                                AdditionalResultsIO.notsaved();
                            }
                        } else if (fc.getFileFilter().equals(filterSVG)) {
                            File file = new File(((JFileChooser)fc).getSelectedFile() + ".svg");
                            file.getParent();
                            AdditionalResultsIO.saveAsSVG(panel, file);
                            AdditionalResultsIO.saved(file);
                        }
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected static void saved(File file) {
        JUMPWorkbench.getInstance().getFrame().setStatusMessage(sSaved + " :" + file.getAbsolutePath());
    }

    protected static void notsaved() {
        JOptionPane.showMessageDialog(null, SCouldNotSave, I18N.getInstance().get(SCouldNotSave), 2);
    }

    public static void Logger(Class<?> plugin, Exception e) {
        JUMPWorkbench.getInstance().getFrame().warnUser(plugin.getSimpleName() + " Exception: " + e.toString());
        Logger.error(plugin.getName() + " Exception: ", e);
    }

    public static void saveAsSVG(Component component, File selFile) throws Exception {
        SVGGraphics2D svgGenerator = AdditionalResultsIO.drawSvgGraphics(component);
        try {
            FileOutputStream fos = new FileOutputStream(selFile, false);
            OutputStreamWriter out = new OutputStreamWriter((OutputStream)fos, StandardCharsets.UTF_8);
            svgGenerator.stream((Writer)out, true);
            out.close();
        }
        catch (Exception e) {
            wContext.getWorkbench().getFrame().handleThrowable(e);
        }
    }

    private static SVGGraphics2D drawSvgGraphics(Component component) {
        DOMImplementation domImpl = SVGDOMImplementation.getDOMImplementation();
        String svgNS = "http://www.w3.org/2000/svg";
        Document svgDocument = domImpl.createDocument(svgNS, "svg", null);
        SVGGraphics2D svgGenerator = new SVGGraphics2D(svgDocument);
        svgGenerator.setSVGCanvasSize(component.getSize());
        component.paintAll((Graphics)svgGenerator);
        svgGenerator.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_DEFAULT);
        svgGenerator.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_DEFAULT);
        svgGenerator.scale(0.9375000000000001, 0.9375000000000001);
        return svgGenerator;
    }

    public static Integer round100(Integer b) {
        return b - b % 100;
    }

    public static void exportToDxf(String fileName, double[][] points) {
        try {
            int ip;
            int p;
            double minX = Double.MAX_VALUE;
            double maxX = -minX;
            double minY = Double.MAX_VALUE;
            double maxY = -minY;
            for (double[] point : points) {
                if (point[0] < minX) {
                    minX = point[0];
                }
                if (point[0] > maxX) {
                    maxX = point[0];
                }
                if (point[1] < minY) {
                    minY = point[1];
                }
                if (!(point[1] > maxY)) continue;
                maxY = point[1];
            }
            DecimalFormatSymbols dfs = new DecimalFormatSymbols(Locale.ENGLISH);
            DecimalFormat twoPlaces = null;
            String twoPlacesS = "0.00";
            twoPlaces = new DecimalFormat("0.00", dfs);
            int pointsCount = points.length;
            int txtHight = 14;
            int txtHight2 = 22;
            int b = ((int)minY - 99) / 100 * 100;
            double baseElev = b - 100;
            int a = ((int)maxY + 99) / 100 * 100;
            double topElev = a + 200;
            int sepSpacing = 140;
            String layNameProf = "PROFILE";
            String baseSectionLayer = "BASE";
            String partialValuesLayer = "PARTIAL_VALUES";
            String gridLayer = "GRID";
            String layNameText = "GRID_TEXT";
            double sep1Y = baseElev - 28.0;
            double sep2Y = sep1Y - 140.0;
            double sep3Y = topElev;
            double leg5Y = sep3Y + 140.0;
            double legX = minX - 420.0;
            DxfExport dxfExp = new DxfExport();
            dxfExp.writeHeader(legX, sep3Y, maxX, maxY);
            dxfExp.writeStartSec();
            dxfExp.writeTablesStart();
            dxfExp.writeTableStart();
            dxfExp.writeVPort((maxX + legX) / 2.0, (maxY + sep3Y) / 2.0, 0.0, 0.0, 1.0, 1.0);
            dxfExp.writeTableEnd();
            dxfExp.writeTableStart();
            dxfExp.writeAppId();
            dxfExp.writeTableEnd();
            dxfExp.writeTableStart();
            dxfExp.writeLayersStart();
            dxfExp.writeLayer("PROFILE", 5);
            dxfExp.writeLayer("BASE", 0);
            dxfExp.writeLayer("PARTIAL_VALUES", 8);
            dxfExp.writeLayer("GRID", 9);
            dxfExp.writeLayer("GRID_TEXT", 7);
            dxfExp.writeTableEnd();
            dxfExp.writeEndSec();
            dxfExp.writeStartSec();
            dxfExp.writeEntStart();
            dxfExp.writePolyline("PROFILE", points);
            Task selectedTask = wContext.getTask();
            String unitsDistLabel = "";
            unitsDistLabel = selectedTask.getProperties().containsKey(new QName("Project Unit")) ? " [" + selectedTask.getProperty(new QName("Project Unit")).toString() + "]" : "";
            dxfExp.writeText("GRID_TEXT", 0.0, 0.0, 0.0, (maxX - minX) / 2.0, sep2Y, 0.0, 22, 0.0, 0, 2, WIDTH + unitsDistLabel);
            dxfExp.writeText("PARTIAL_VALUES", 0.0, 0.0, 0.0, (maxX - minX) / 2.0, leg5Y, 0.0, 22, 0.0, 0, 2, HEIGHT + unitsDistLabel);
            dxfExp.writeText("GRID_TEXT", 0.0, 0.0, 0.0, minX - 200.0, (topElev + baseElev) / 2.0, 0.0, 22, 90.0, 0, 2, HEIGHT + unitsDistLabel);
            dxfExp.writeText("GRID_TEXT", 0.0, 0.0, 0.0, maxX + 200.0, (topElev + baseElev) / 2.0, 0.0, 22, 270.0, 0, 2, HEIGHT + unitsDistLabel);
            double p1x = 0.0;
            double p1y = 0.0;
            double p2x = 0.0;
            double p2y = 0.0;
            double alPt1x = 0.0;
            double alPt1y = 0.0;
            double alPt2y = 0.0;
            String labelText = null;
            int interPointsCount = 0;
            double[] interStepD = null;
            interStepD = new double[]{100.0};
            interPointsCount = (int)((maxX - minX) / interStepD[0]) + 2;
            double[] interPointsDists = new double[interPointsCount];
            double[] interPointsElev = new double[interPointsCount];
            for (int ip2 = 0; ip2 < interPointsCount; ++ip2) {
                interPointsDists[ip2] = ip2 < interPointsCount - 1 ? interStepD[0] * (double)ip2 : maxX;
            }
            int[] interPointsIds = new int[interPointsCount];
            int ipId = 0;
            for (p = 1; p < pointsCount; ++p) {
                if (!(points[p][0] >= interPointsDists[ipId])) continue;
                interPointsIds[ipId] = Math.abs(points[p][0] - interPointsDists[ipId]) <= Math.abs(interPointsDists[ipId] - points[p - 1][0]) ? p : p - 1;
                ++ipId;
            }
            if (interPointsIds[interPointsCount - 1] == 0) {
                interPointsIds[interPointsCount - 1] = pointsCount - 1;
            }
            ipId = 0;
            for (p = 1; p < pointsCount; ++p) {
                if (!(points[p][0] >= interPointsDists[ipId])) continue;
                interPointsIds[ipId] = Math.abs(points[p][0] - interPointsDists[ipId]) <= Math.abs(interPointsDists[ipId] - points[p - 1][0]) ? p : p - 1;
                interPointsElev[ipId] = (interPointsDists[ipId] - points[p - 1][0]) / (points[p][0] - points[p - 1][0]) * (points[p][1] - points[p - 1][1]) + points[p - 1][1];
                ++ipId;
            }
            for (ip = 0; ip < interPointsCount; ++ip) {
                if (!(baseElev + interPointsDists[ip] < topElev) && baseElev + interPointsDists[ip] != topElev) continue;
                p1x = maxX;
                p1y = interPointsDists[ip] + baseElev;
                p2x = minX;
                p2y = interPointsDists[ip] + baseElev;
                dxfExp.writeLineType("GRID", "DOTTINY", p1x, p1y, p2x, p2y);
                alPt1x = minX - 100.0;
                double alPt1ax = maxX + 14.0;
                alPt1y = interPointsDists[ip] + baseElev;
                labelText = twoPlaces.format(interPointsDists[ip] + baseElev);
                dxfExp.writeText("GRID_TEXT", 0.0, 0.0, 0.0, alPt1x, alPt1y, 0.0, 14, 0.0, 0, 2, labelText);
                dxfExp.writeText("GRID_TEXT", 0.0, 0.0, 0.0, alPt1ax, alPt1y, 0.0, 14, 0.0, 0, 2, labelText);
                alPt1x = minX;
                alPt1y = interPointsDists[ip] + baseElev;
                double alPt2x = minX - 7.0;
                dxfExp.writeLine("BASE", alPt1x, alPt1y, alPt2x, alPt1y);
                double alPt2x2 = maxX + 7.0;
                dxfExp.writeLine("BASE", maxX, alPt1y, alPt2x2, alPt1y);
            }
            for (ip = 0; ip < interPointsCount; ++ip) {
                p1x = interPointsDists[ip];
                p1y = topElev;
                p2x = interPointsDists[ip];
                p2y = baseElev;
                dxfExp.writeLineType("GRID", "DOTTINY", p1x, p1y, p2x, p2y);
                alPt1x = interPointsDists[ip];
                alPt1y = sep1Y - 56.0;
                labelText = twoPlaces.format(interPointsDists[ip]);
                dxfExp.writeText("GRID_TEXT", 0.0, 0.0, 0.0, alPt1x, alPt1y, 0.0, 14, 90.0, 0, 2, labelText);
                alPt1x = interPointsDists[ip];
                alPt1y = baseElev;
                alPt2y = baseElev - 7.0;
                dxfExp.writeLine("BASE", alPt1x, alPt1y, alPt1x, alPt2y);
                alPt1x = interPointsDists[ip];
                alPt1y = sep3Y + 14.0;
                labelText = twoPlaces.format(points[interPointsIds[ip]][1]);
                dxfExp.writeText("PARTIAL_VALUES", 0.0, 0.0, 0.0, alPt1x, alPt1y, 0.0, 14, 90.0, 0, 2, labelText);
                alPt1y = sep3Y;
                alPt2y = sep3Y + 7.0;
                dxfExp.writeLine("PARTIAL_VALUES", alPt1x, alPt1y, alPt1x, alPt2y);
            }
            dxfExp.writeLine("BASE", minX, baseElev, maxX, baseElev);
            dxfExp.writeLine("BASE", minX, baseElev, minX, topElev);
            dxfExp.writeLine("BASE", maxX, baseElev, maxX, topElev);
            dxfExp.writeLine("PARTIAL_VALUES", minX, sep3Y, maxX, sep3Y);
            dxfExp.writeEnding();
            int ret = dxfExp.exportDxf(fileName);
            if (ret == 0) {
                return;
            }
            return;
        }
        catch (Exception ex) {
            wContext.getWorkbench().getFrame().warnUser("Errore durante l'esportazione: ");
            return;
        }
    }

    public static boolean CheckSVGLibs() {
        ClassLoader cl = JUMPWorkbench.getInstance().getPlugInManager().getClassLoader();
        Class<?> c = null;
        Class<?> c2 = null;
        try {
            c = cl.loadClass("org.apache.batik.dom.GenericDOMImplementation");
            c2 = cl.loadClass("org.apache.batik.svggen.SVGGraphics2D");
        }
        catch (ClassNotFoundException e) {
            AdditionalResultsIO.Logger(JUMPWorkbench.getInstance().getPlugInManager().getClass(), e);
        }
        if (c == null || c2 == null) {
            JUMPWorkbench.getInstance().getFrame().warnUser(" not initialized because batik is missing.");
            return false;
        }
        return true;
    }
}

