/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.wms;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.JUMPWorkbench;
import com.vividsolutions.jump.workbench.Logger;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.WMSLayer;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import com.vividsolutions.wms.MapLayer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.apache.commons.lang3.StringUtils;
import org.openjump.core.apitools.LayerTools;
import org.openjump.core.ui.io.file.FileNameExtensionFilter;
import org.openjump.core.ui.plugin.wms.LegendRequest;
import org.openjump.core.ui.swing.DetachableInternalFrame;

public class WMSLegendPlugIn
extends AbstractPlugIn {
    private static ImageIcon ICON = IconLoader.icon("saig/addLegend.gif");
    private JScrollPane scrollPane = new JScrollPane();
    private final String sSaved = I18N.getInstance().get("org.openjump.core.ui.plugin.raster.RasterImageLayerPropertiesPlugIn.file.saved");
    private final String SCouldNotSave = I18N.getInstance().get("org.openjump.sextante.gui.additionalResults.AdditionalResultsPlugIn.Could-not-save-selected-result");
    private final String SAVE = I18N.getInstance().get("deejump.plugin.SaveLegendPlugIn.Save");
    private final String CLOSE = I18N.getInstance().get("ui.plugin.imagery.ImageLayerManagerDialog.Close");
    private final String PLUGIN = I18N.getInstance().get("org.openjump.core.ui.plugin.wms.WMSLegendPlugIn");
    private final String PANEL = I18N.getInstance().get("org.openjump.core.ui.plugin.wms.WMSLegendPlugIn.panel");
    private final String MESSAGE = I18N.getInstance().get("org.openjump.core.ui.plugin.wms.WMSLegendPlugIn.message");

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        WMSLayer layer = (WMSLayer)LayerTools.getSelectedLayerable(context, WMSLayer.class);
        final DetachableInternalFrame frame = new DetachableInternalFrame();
        frame.setTitle(this.PANEL + " (" + layer.getName() + ")");
        frame.setResizable(true);
        frame.setClosable(true);
        frame.setIconifiable(true);
        frame.setMaximizable(true);
        frame.setFrameIcon(ICON);
        frame.setSize(200, 500);
        frame.setLayer(JLayeredPane.PALETTE_LAYER);
        this.scrollPane = new JScrollPane(this.getLegendPanel(context), 20, 30);
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)this.scrollPane, "Center");
        panel.setPreferredSize(this.scrollPane.getPreferredSize());
        frame.add((Component)panel, "North");
        JPanel okPanel = new JPanel();
        JButton saveButton = new JButton(this.SAVE){
            private static final long serialVersionUID = 1L;

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(100, 25);
            }
        };
        JButton closeButton = new JButton(this.CLOSE){
            private static final long serialVersionUID = 2L;

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(100, 25);
            }
        };
        saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WMSLegendPlugIn.this.save(WMSLegendPlugIn.this.scrollPane);
            }
        });
        closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                frame.dispose();
            }
        });
        okPanel.add((Component)saveButton, "West");
        okPanel.add((Component)closeButton, "East");
        frame.add((Component)okPanel, "South");
        frame.pack();
        context.getWorkbenchFrame().addInternalFrame(frame, true, true);
        return true;
    }

    public void save(JScrollPane pane) {
        JPanel panel = (JPanel)pane.getViewport().getView();
        int w = panel.getWidth();
        int h = panel.getHeight();
        BufferedImage bi = new BufferedImage(w, h, 1);
        Graphics2D g = bi.createGraphics();
        panel.paint(g);
        FileNameExtensionFilter filter = new FileNameExtensionFilter("Portable Network Graphics (png)", "png");
        GUIUtil.FileChooserWithOverwritePrompting fc = new GUIUtil.FileChooserWithOverwritePrompting("png");
        fc.setFileFilter(filter);
        fc.addChoosableFileFilter(filter);
        int returnVal = fc.showSaveDialog(JUMPWorkbench.getInstance().getFrame());
        fc.getWidth();
        fc.getHeight();
        if (returnVal == 0) {
            try {
                File file = new File(((JFileChooser)fc).getSelectedFile() + ".png");
                ImageIO.write((RenderedImage)bi, "png", file);
                this.saved(file);
            }
            catch (Exception e) {
                this.notsaved();
                WMSLegendPlugIn.Logger(this.getClass(), e);
            }
        }
    }

    public static void Logger(Class<?> plugin, Exception e) {
        JUMPWorkbench.getInstance().getFrame().warnUser(plugin.getSimpleName() + " Exception: " + e.toString());
        Logger.error(plugin.getName() + " Exception: ", e);
    }

    protected void saved(File file) {
        JUMPWorkbench.getInstance().getFrame().setStatusMessage(this.sSaved + " :" + file.getAbsolutePath());
    }

    protected void notsaved() {
        JOptionPane.showMessageDialog(null, this.SCouldNotSave, I18N.getInstance().get(this.getName()), 2);
    }

    public JPanel getLegendPanel(PlugInContext context) throws IOException {
        JPanel mainPanel = new JPanel(new GridBagLayout());
        WMSLayer layer = (WMSLayer)LayerTools.getSelectedLayerable(context, WMSLayer.class);
        List<String> names = layer.getLayerNames();
        mainPanel.setBackground(Color.WHITE);
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        for (String layerName : names) {
            MapLayer mapLayer = layer.getService().getCapabilities().getMapLayerByName(layerName);
            String layerTitle = StringUtils.isNotEmpty((CharSequence)mapLayer.getTitle()) ? mapLayer.getTitle() : layerName;
            JLabel nameLabel = new JLabel(I18N.getInstance().get("org.openjump.core.ui.plugin.queries.SimpleQuery.layer: {0}", layerTitle));
            nameLabel.setHorizontalAlignment(0);
            nameLabel.setFont(new Font("Verdana", 1, 16));
            mainPanel.add((Component)nameLabel, "Center");
            LegendRequest req = new LegendRequest(layer.getService(), layerName);
            Image image = req.getImage();
            ImageIcon legendIcon = new ImageIcon(image);
            if (legendIcon != null) {
                JLabel labelIcon = new JLabel(legendIcon, 0);
                mainPanel.add((Component)labelIcon, "South");
                continue;
            }
            JLabel textLabel = new JLabel(this.MESSAGE);
            mainPanel.add((Component)textLabel, "South");
        }
        return mainPanel;
    }

    public MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerNamePanelMustBeActiveCheck()).add(checkFactory.createExactlyNLayerablesMustBeSelectedCheck(1, WMSLayer.class));
    }

    @Override
    public String getName() {
        return this.PLUGIN;
    }

    @Override
    public ImageIcon getIcon() {
        return ICON;
    }
}

