/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.view;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import com.vividsolutions.jump.workbench.ui.MultiInputDialog;
import com.vividsolutions.jump.workbench.ui.Viewport;
import java.text.DecimalFormat;
import javax.swing.JTextField;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.openjump.core.ui.util.ScreenScale;

public class ZoomToScalePlugIn
extends AbstractPlugIn {
    private String T1 = "scale";
    double scale = 25000.0;
    double oldHorizontalScale = 0.0;
    double modelWidth = 0.0;
    double panelWidth = 0.0;
    String text = I18N.getInstance().get("org.openjump.core.ui.plugin.view.ZoomToScalePlugIn.set-new-scale-to-zoom") + "     1:";

    @Override
    public void initialize(PlugInContext context) throws Exception {
        super.initialize(context);
        this.T1 = I18N.getInstance().get("org.openjump.core.ui.plugin.view.ZoomToScalePlugIn.scale") + ": ";
        context.getFeatureInstaller().addMainMenuItem(this, new String[]{MenuNames.VIEW}, I18N.getInstance().get("org.openjump.core.ui.plugin.view.ZoomToScalePlugIn.zoom-to-scale") + "{pos:9}", false, null, ZoomToScalePlugIn.createEnableCheck(context.getWorkbenchContext()));
    }

    public static MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createAtLeastNLayerablesMustExistCheck(1));
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        Viewport port = context.getLayerViewPanel().getViewport();
        this.oldHorizontalScale = ScreenScale.getHorizontalMapScale(port);
        MultiInputDialog dialog = new MultiInputDialog(context.getWorkbenchFrame(), I18N.getInstance().get("org.openjump.core.ui.plugin.view.ZoomToScalePlugIn.zoom-to-scale"), true);
        this.setDialogValues(dialog, context);
        GUIUtil.centreOnWindow(dialog);
        dialog.setVisible(true);
        if (!dialog.wasOKPressed()) {
            return false;
        }
        this.getDialogValues(dialog);
        this.zoomToNewScale(context);
        return true;
    }

    public void zoomToNewScale(PlugInContext context) throws Exception {
        Viewport port = context.getLayerViewPanel().getViewport();
        this.oldHorizontalScale = ScreenScale.getHorizontalMapScale(port);
        double factor = this.scale / this.oldHorizontalScale;
        Envelope oldEnvelope = port.getEnvelopeInModelCoordinates();
        double xc = 0.5 * (oldEnvelope.getMaxX() + oldEnvelope.getMinX());
        double yc = 0.5 * (oldEnvelope.getMaxY() + oldEnvelope.getMinY());
        double xmin = xc - 0.5 * factor * oldEnvelope.getWidth();
        double xmax = xc + 0.5 * factor * oldEnvelope.getWidth();
        double ymin = yc - 0.5 * factor * oldEnvelope.getHeight();
        double ymax = yc + 0.5 * factor * oldEnvelope.getHeight();
        Coordinate[] coords = new Coordinate[]{new Coordinate(xmin, ymin), new Coordinate(xmax, ymax)};
        LineString g1 = new GeometryFactory().createLineString(coords);
        port.zoom(g1.getEnvelopeInternal());
    }

    private void setDialogValues(MultiInputDialog dialog, PlugInContext context) {
        dialog.addLabel(I18N.getInstance().get("org.openjump.core.ui.plugin.view.ZoomToScalePlugIn.actual-scale-in-horizontal-direction") + "     1:" + new DecimalFormat("#").format(this.oldHorizontalScale));
        JTextField field = dialog.addDoubleField(this.text, Math.floor(this.oldHorizontalScale), 12, this.text);
        field.setHorizontalAlignment(2);
    }

    private void getDialogValues(MultiInputDialog dialog) {
        this.scale = dialog.getDouble(this.text);
    }

    public void setScale(double scale) {
        this.scale = scale;
    }
}

