/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.tools.generate;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.AttributeType;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureDataset;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.StandardCategoryNames;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.AttributeTypeFilter;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import com.vividsolutions.jump.workbench.ui.MultiInputDialog;
import com.vividsolutions.jump.workbench.ui.MultiTabInputDialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.operation.linemerge.LineMerger;
import org.openjump.core.ui.images.IconLoader;
import org.openjump.core.ui.plugin.tools.generate.AbstractLinearReferencingPlugIn;

public class LinearReferencingOnLayerPlugIn
extends AbstractLinearReferencingPlugIn {
    private static final String KEY = LinearReferencingOnLayerPlugIn.class.getName();
    private String MAIN_OPTIONS;
    private String SOURCE_LAYER;
    private String ATTRIBUTES;
    private String USE_ATTRIBUTE_AS_PATH_IDENTIFIER;
    private String PATH_IDENTIFIER_TOOLTIP;
    private String PATH_IDENTIFIER_ATTRIBUTE;
    private String USE_ATTRIBUTE_TO_ORDER_PATH_SECTIONS;
    private String PATH_SECTION_TOOLTIP;
    private String PATH_SECTION_ATTRIBUTE;
    String layer_name;
    boolean use_attribute_as_path_identifier = false;
    String path_identifier_attribute;
    boolean use_attribute_to_order_path_sections = false;
    String path_section_attribute;
    private String categoryName = StandardCategoryNames.RESULT;

    public LinearReferencingOnLayerPlugIn() {
        super(I18N.getInstance().get(KEY), IconLoader.icon("linearref_layer.png"));
    }

    public void setCategoryName(String value) {
        this.categoryName = value;
    }

    @Override
    public void initialize(PlugInContext context) throws Exception {
        context.getFeatureInstaller().addMainMenuPlugin(this, new String[]{MenuNames.TOOLS, MenuNames.TOOLS_GENERATE, MenuNames.TOOLS_LINEARREFERENCING}, this.getName() + "...", false, this.getIcon(), LinearReferencingOnLayerPlugIn.createEnableCheck(context.getWorkbenchContext()));
    }

    public static MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerNamePanelMustBeActiveCheck()).add(checkFactory.createAtLeastNLayersMustExistCheck(1));
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        this.MAIN_OPTIONS = I18N.getInstance().get(KEY + ".main-options");
        this.SOURCE_LAYER = I18N.getInstance().get(KEY + ".source-layer");
        this.ATTRIBUTES = I18N.getInstance().get(KEY + ".attributes");
        this.USE_ATTRIBUTE_AS_PATH_IDENTIFIER = I18N.getInstance().get(KEY + ".use-attribute-as-path-identifier");
        this.PATH_IDENTIFIER_TOOLTIP = I18N.getInstance().get(KEY + ".path-identifier-tooltip");
        this.PATH_IDENTIFIER_ATTRIBUTE = I18N.getInstance().get(KEY + ".path-identifier-attribute");
        this.USE_ATTRIBUTE_TO_ORDER_PATH_SECTIONS = I18N.getInstance().get(KEY + ".use-attribute-to-order-path-sections");
        this.PATH_SECTION_TOOLTIP = I18N.getInstance().get(KEY + ".path-section-tooltip");
        this.PATH_SECTION_ATTRIBUTE = I18N.getInstance().get(KEY + ".path-section-attribute");
        super.execute(context);
        MultiTabInputDialog dialog = new MultiTabInputDialog((Frame)context.getWorkbenchFrame(), this.getName(), this.MAIN_OPTIONS, true);
        this.setDialogValues(dialog, context);
        GUIUtil.centreOnWindow(dialog);
        dialog.setVisible(true);
        if (!dialog.wasOKPressed()) {
            return false;
        }
        this.getDialogValues(dialog);
        return true;
    }

    @Override
    public void run(TaskMonitor monitor, PlugInContext context) throws Exception {
        monitor.allowCancellationRequests();
        FeatureSchema featureSchema = new FeatureSchema();
        featureSchema.addAttribute("GEOMETRY", AttributeType.GEOMETRY);
        featureSchema.addAttribute("LAYER", AttributeType.STRING);
        featureSchema.addAttribute("PATH", AttributeType.STRING);
        featureSchema.addAttribute("NUM", AttributeType.INTEGER);
        featureSchema.addAttribute("DISTANCE", AttributeType.DOUBLE);
        featureSchema.addAttribute("OFFSET", AttributeType.DOUBLE);
        FeatureDataset resultFC = new FeatureDataset(featureSchema);
        Layer layer = context.getLayerManager().getLayer(this.layer_name);
        List<Geometry> geometries = this.prepareGeometries(layer.getFeatureCollectionWrapper().getFeatures());
        for (Geometry geometry : geometries) {
            if (geometry.getDimension() == 1) {
                this.setPointsAlong(resultFC, layer.getName(), geometry.getUserData().toString(), geometry);
                continue;
            }
            if (geometry.getDimension() != 2) continue;
            this.setPointsAlong(resultFC, layer.getName(), geometry.getUserData().toString(), geometry.getBoundary());
        }
        if (resultFC.size() > 0) {
            context.addLayer(this.categoryName, "Linear-Referencing", resultFC);
        } else {
            context.getWorkbenchFrame().warnUser(this.EMPTY_RESULT);
        }
    }

    private List<Geometry> prepareGeometries(List<Feature> features) {
        ArrayList<Geometry> geometries = new ArrayList<Geometry>();
        if (features.size() == 0) {
            return geometries;
        }
        HashMap map = new HashMap();
        for (Feature feature : features) {
            List<Object> list;
            TreeMap k;
            Object key2;
            Object key1;
            Object object = key1 = this.use_attribute_as_path_identifier ? feature.getAttribute(this.path_identifier_attribute) : Integer.valueOf(feature.getID());
            if (this.use_attribute_as_path_identifier && key1 == null) continue;
            if (key1 == null) {
                key1 = "null";
            }
            Object object2 = key2 = this.use_attribute_to_order_path_sections ? feature.getAttribute(this.path_section_attribute) : Integer.valueOf(feature.getID());
            if (this.use_attribute_as_path_identifier && key2 == null) continue;
            if (key2 == null) {
                key2 = "null";
            }
            if ((k = (TreeMap)map.get(key1)) == null) {
                list = new ArrayList();
                list.add(feature.getGeometry());
                TreeMap<Object, ArrayList<Geometry>> tm = new TreeMap<Object, ArrayList<Geometry>>();
                tm.put(key2, (ArrayList<Geometry>)list);
                map.put(key1, tm);
                continue;
            }
            list = (List)k.get(key2);
            if (list == null) {
                list = new ArrayList<Geometry>();
            }
            list.add(feature.getGeometry());
            k.put(key2, list);
        }
        GeometryFactory factory = features.iterator().next().getGeometry().getFactory();
        for (Map.Entry entry : map.entrySet()) {
            TreeMap tm = (TreeMap)entry.getValue();
            ArrayList<LineString> sections = new ArrayList<LineString>();
            for (Map.Entry entry2 : tm.entrySet()) {
                List geoms = (List)entry2.getValue();
                LineMerger merger = new LineMerger();
                merger.add((Collection)geoms);
                Collection coll = merger.getMergedLineStrings();
                for (Object obj : coll) {
                    sections.add((LineString)obj);
                }
            }
            MultiLineString newGeometry = factory.createMultiLineString(sections.toArray(new LineString[sections.size()]));
            newGeometry.setUserData(entry.getKey());
            geometries.add((Geometry)newGeometry);
        }
        return geometries;
    }

    private void setDialogValues(MultiTabInputDialog dialog, PlugInContext context) {
        Layer layer = context.getLayerManager().getLayer(this.layer_name);
        if (layer == null) {
            layer = context.getCandidateLayer(0);
        }
        dialog.setSideBarDescription(this.DESCRIPTION);
        dialog.addLayerComboBox(this.SOURCE_LAYER, layer, null, context.getLayerManager().getLayers());
        dialog.addSubTitle(this.DISTANCE_UNIT);
        dialog.addRadioButton(this.MAP_UNIT, "UNIT", this.map_unit, this.MAP_UNIT_TOOLTIP);
        dialog.addRadioButton(this.LINESTRING_FRACTION, "UNIT", this.linestring_fraction, this.LINESTRING_FRACTION_TOOLTIP);
        dialog.addSubTitle(this.DISTANCE_AND_OFFSET);
        dialog.addDoubleField(this.DISTANCE, this.distance, 6, this.DISTANCE_TOOLTIP);
        dialog.addDoubleField(this.OFFSET, this.offset, 6, this.OFFSET_TOOLTIP);
        dialog.addSeparator();
        final JCheckBox repeatCheckBox = dialog.addCheckBox(this.REPEAT, this.repeat, null);
        final JTextField repeatDistanceTextField = dialog.addDoubleField(this.REPEAT_DISTANCE, this.repeat_distance, 6, null);
        final JCheckBox addEndPointCheckBox = dialog.addCheckBox(this.ADD_END_POINT, this.add_end_point, null);
        dialog.addSeparator();
        dialog.addPane(this.ATTRIBUTES);
        final JCheckBox useAttributeAsPathCheckBox = dialog.addCheckBox(this.USE_ATTRIBUTE_AS_PATH_IDENTIFIER, this.use_attribute_as_path_identifier, this.PATH_IDENTIFIER_TOOLTIP);
        final JComboBox<String> pathIdentifierComboBox = dialog.addAttributeComboBox(this.PATH_IDENTIFIER_ATTRIBUTE, this.SOURCE_LAYER, AttributeTypeFilter.NUMSTRING_FILTER, null);
        pathIdentifierComboBox.setEnabled(this.use_attribute_as_path_identifier);
        if (this.use_attribute_as_path_identifier) {
            pathIdentifierComboBox.setSelectedItem(this.path_identifier_attribute);
        }
        final JCheckBox orderSectionsCheckBox = dialog.addCheckBox(this.USE_ATTRIBUTE_TO_ORDER_PATH_SECTIONS, this.use_attribute_to_order_path_sections, this.PATH_SECTION_TOOLTIP);
        final JComboBox<String> orderSectionsComboBox = dialog.addAttributeComboBox(this.PATH_SECTION_ATTRIBUTE, this.SOURCE_LAYER, AttributeTypeFilter.NUMSTRING_FILTER, null);
        orderSectionsComboBox.setEnabled(this.use_attribute_to_order_path_sections);
        if (this.use_attribute_to_order_path_sections) {
            orderSectionsComboBox.setSelectedItem(this.path_section_attribute);
        }
        repeatCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                repeatDistanceTextField.setEnabled(repeatCheckBox.isSelected());
                addEndPointCheckBox.setEnabled(repeatCheckBox.isSelected());
            }
        });
        useAttributeAsPathCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                pathIdentifierComboBox.setEnabled(useAttributeAsPathCheckBox.isSelected());
            }
        });
        orderSectionsCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                orderSectionsComboBox.setEnabled(orderSectionsCheckBox.isSelected());
            }
        });
    }

    private void getDialogValues(MultiInputDialog dialog) {
        this.layer_name = dialog.getLayer(this.SOURCE_LAYER).getName();
        this.map_unit = dialog.getBoolean(this.MAP_UNIT);
        this.linestring_fraction = dialog.getBoolean(this.LINESTRING_FRACTION);
        this.distance = dialog.getDouble(this.DISTANCE);
        this.offset = dialog.getDouble(this.OFFSET);
        this.repeat = dialog.getBoolean(this.REPEAT);
        this.repeat_distance = dialog.getDouble(this.REPEAT_DISTANCE);
        if (this.repeat_distance == 0.0) {
            this.repeat = false;
        }
        this.add_end_point = dialog.getBoolean(this.ADD_END_POINT);
        this.use_attribute_as_path_identifier = dialog.getBoolean(this.USE_ATTRIBUTE_AS_PATH_IDENTIFIER);
        this.path_identifier_attribute = dialog.getText(this.PATH_IDENTIFIER_ATTRIBUTE);
        this.use_attribute_to_order_path_sections = dialog.getBoolean(this.USE_ATTRIBUTE_TO_ORDER_PATH_SECTIONS);
        this.path_section_attribute = dialog.getText(this.PATH_SECTION_ATTRIBUTE);
    }
}

