/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.tools.generate;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.BasicFeature;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import javax.swing.ImageIcon;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.linearref.LengthIndexedLine;
import org.openjump.core.ui.plugin.AbstractThreadedUiPlugIn;

public abstract class AbstractLinearReferencingPlugIn
extends AbstractThreadedUiPlugIn {
    private static final String KEY = AbstractLinearReferencingPlugIn.class.getName();
    protected String DESCRIPTION;
    protected String DISTANCE_UNIT;
    protected String MAP_UNIT;
    protected String MAP_UNIT_TOOLTIP;
    protected String LINESTRING_FRACTION;
    protected String LINESTRING_FRACTION_TOOLTIP;
    protected String DISTANCE_AND_OFFSET;
    protected String DISTANCE;
    protected String DISTANCE_TOOLTIP;
    protected String OFFSET;
    protected String OFFSET_TOOLTIP;
    protected String REPEAT;
    protected String REPEAT_DISTANCE;
    protected String ADD_END_POINT;
    protected String EMPTY_RESULT;
    protected boolean map_unit = true;
    protected boolean linestring_fraction = false;
    protected double distance = 0.0;
    protected double offset = 0.0;
    protected boolean repeat = false;
    protected double repeat_distance = 0.0;
    protected boolean add_end_point = false;

    public AbstractLinearReferencingPlugIn(String s, ImageIcon icon) {
        super(s, icon);
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        this.DESCRIPTION = I18N.getInstance().get(KEY + ".description");
        this.DISTANCE_UNIT = I18N.getInstance().get(KEY + ".distance-unit");
        this.MAP_UNIT = I18N.getInstance().get(KEY + ".map-unit");
        this.MAP_UNIT_TOOLTIP = I18N.getInstance().get(KEY + ".map-unit-tooltip");
        this.LINESTRING_FRACTION = I18N.getInstance().get(KEY + ".linestring-fraction");
        this.LINESTRING_FRACTION_TOOLTIP = I18N.getInstance().get(KEY + ".linestring-fraction-tooltip");
        this.DISTANCE_AND_OFFSET = I18N.getInstance().get(KEY + ".distance-and-offset");
        this.DISTANCE = I18N.getInstance().get(KEY + ".distance");
        this.DISTANCE_TOOLTIP = I18N.getInstance().get(KEY + ".distance-tooltip");
        this.OFFSET = I18N.getInstance().get(KEY + ".offset");
        this.OFFSET_TOOLTIP = I18N.getInstance().get(KEY + ".offset-tooltip");
        this.REPEAT = I18N.getInstance().get(KEY + ".repeat");
        this.REPEAT_DISTANCE = I18N.getInstance().get(KEY + ".repeat-distance");
        this.ADD_END_POINT = I18N.getInstance().get(KEY + ".add-end-point");
        this.EMPTY_RESULT = I18N.getInstance().get(KEY + ".empty-result");
        return true;
    }

    protected void setPointsAlong(FeatureCollection dataset, String layerName, String path, Geometry geometry) {
        double sign;
        LengthIndexedLine lengthIndexedLine = new LengthIndexedLine(geometry);
        double length = geometry.getLength();
        double dist = this.linestring_fraction ? this.distance * length : this.distance;
        int count = 0;
        double delta = 0.0;
        double d = sign = this.distance == 0.0 ? 1.0 : Math.signum(this.distance);
        if (this.repeat) {
            sign = this.distance == 0.0 ? Math.signum(this.repeat_distance) : Math.signum(this.distance);
            double d2 = delta = this.linestring_fraction ? sign * Math.abs(this.repeat_distance) * length : sign * Math.abs(this.repeat_distance);
        }
        while (Math.abs(dist) <= length) {
            Coordinate c = lengthIndexedLine.extractPoint(dist, this.offset);
            BasicFeature feature = new BasicFeature(dataset.getFeatureSchema());
            feature.setGeometry((Geometry)geometry.getFactory().createPoint(c));
            feature.setAttribute("LAYER", (Object)layerName);
            feature.setAttribute("PATH", (Object)path);
            feature.setAttribute("NUM", (Object)count++);
            feature.setAttribute("DISTANCE", (Object)dist);
            feature.setAttribute("OFFSET", (Object)this.offset);
            dataset.add(feature);
            if (this.add_end_point) {
                if (this.repeat && Math.abs(dist) < length && Math.abs(dist + delta) > length) {
                    dist = this.distance == 0.0 ? length : Math.signum(this.distance) * length;
                    continue;
                }
                if (!this.repeat) {
                    dist = this.distance == 0.0 ? length : Math.signum(this.distance) * length;
                    continue;
                }
            }
            if (!this.repeat || delta == 0.0) break;
            dist += delta;
        }
    }
}

