/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.tools;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.plugin.ThreadedPlugIn;
import com.vividsolutions.jump.workbench.ui.EditTransaction;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import com.vividsolutions.jump.workbench.ui.MultiInputDialog;
import com.vividsolutions.jump.workbench.ui.plugin.FeatureInstaller;
import java.util.Collection;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.simplify.TopologyPreservingSimplifier;

public class SimplifyWithJTSAlgorithmPlugIn
extends AbstractPlugIn
implements ThreadedPlugIn {
    private static final String sSimplifyJTSAlgorithm = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.SimplifyWithJTSAlgorithmPlugIn");
    private static final String sidebarText = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.SimplifyWithJTSAlgorithmPlugIn.Line-simplification-for-a-selected-line-or-polygon");
    private static final String sItem = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.SimplifyWithJTSAlgorithmPlugIn.Item");
    private static final String sSimplificationFinalized = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.SimplifyWithJTSAlgorithmPlugIn.simplification-finalized");
    private static String T3 = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.SimplifyWithJTSAlgorithmPlugIn.Maximum-point-displacement-in-model-units");
    double maxPDisp = 0.0;

    @Override
    public void initialize(PlugInContext context) throws Exception {
        super.initialize(context);
        FeatureInstaller featureInstaller = context.getFeatureInstaller();
        featureInstaller.addMainMenuPlugin(this, new String[]{MenuNames.TOOLS, MenuNames.TOOLS_GENERALIZATION}, sSimplifyJTSAlgorithm, false, null, SimplifyWithJTSAlgorithmPlugIn.createEnableCheck(context.getWorkbenchContext()));
    }

    public static MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerNamePanelMustBeActiveCheck()).add(checkFactory.createAtLeastNItemsMustBeSelectedCheck(1)).add(checkFactory.createSelectedItemsLayersMustBeEditableCheck());
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        this.reportNothingToUndoYet(context);
        MultiInputDialog dialog = new MultiInputDialog(context.getWorkbenchFrame(), this.getName(), true);
        this.setDialogValues(dialog, context);
        GUIUtil.centreOnWindow(dialog);
        dialog.setVisible(true);
        if (!dialog.wasOKPressed()) {
            return false;
        }
        this.getDialogValues(dialog);
        return true;
    }

    private void setDialogValues(MultiInputDialog dialog, PlugInContext context) {
        dialog.setSideBarDescription(sidebarText);
        dialog.addDoubleField(T3, 1.0, 5);
    }

    private void getDialogValues(MultiInputDialog dialog) {
        this.maxPDisp = dialog.getDouble(T3);
    }

    protected Layer layer(PlugInContext context) {
        return context.getLayerViewPanel().getSelectionManager().getLayersWithSelectedItems().iterator().next();
    }

    @Override
    public void run(TaskMonitor monitor, PlugInContext context) throws Exception {
        monitor.allowCancellationRequests();
        this.simplify(context, this.maxPDisp, monitor);
        System.gc();
    }

    private boolean simplify(PlugInContext context, double maxDisp, TaskMonitor monitor) throws Exception {
        Collection<Feature> features = context.getLayerViewPanel().getSelectionManager().getFeaturesWithSelectedItems();
        EditTransaction transaction = new EditTransaction(features, this.getName(), this.layer(context), this.isRollingBackInvalidEdits(context), false, context.getWorkbenchFrame());
        int count = 0;
        int noItems = features.size();
        Geometry resultgeom = null;
        for (Feature f : features) {
            resultgeom = TopologyPreservingSimplifier.simplify((Geometry)f.getGeometry(), (double)Math.abs(maxDisp));
            String mytext = sItem + ": " + ++count + " / " + noItems + " : " + sSimplificationFinalized;
            monitor.report(mytext);
            transaction.setGeometry(f, resultgeom);
        }
        transaction.commit();
        return true;
    }
}

