/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.tools;

import bsh.EvalError;
import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.AttributeType;
import com.vividsolutions.jump.feature.BasicFeature;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollectionWrapper;
import com.vividsolutions.jump.feature.FeatureDataset;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.util.StringUtil;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.StandardCategoryNames;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.plugin.ThreadedBasePlugIn;
import com.vividsolutions.jump.workbench.ui.DualPaneInputDialog;
import com.vividsolutions.jump.workbench.ui.ErrorDialog;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.GenericNames;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import com.vividsolutions.jump.workbench.ui.OKCancelPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;
import org.openjump.core.feature.AttributeOperationFactory;
import org.openjump.core.feature.BeanshellAttributeOperation;

public class BeanshellAttributeCalculatorPlugIn
extends ThreadedBasePlugIn
implements GenericNames {
    private static final String KEY = BeanshellAttributeCalculatorPlugIn.class.getName();
    private static String BEANSHELL_ATT_CAL = I18N.getInstance().get(KEY);
    private static String NEW_ATTRIBUTE_NAME = I18N.getInstance().get(KEY + ".new-attribute-name");
    private static String NEW_ATTRIBUTE_TYPE = I18N.getInstance().get(KEY + ".new-attribute-type");
    private static String BSH_EXPRESSION = I18N.getInstance().get(KEY + ".beanshell-expression");
    private static String SCRIPT_SNIPPETS = I18N.getInstance().get(KEY + ".script-snippets");
    private static String COMPUTING_NEW_ATTRIBUTE = I18N.getInstance().get(KEY + ".computing-new-attribute");
    private static String TOO_MANY_ERRORS = I18N.getInstance().get(KEY + ".too-many-errors");
    private static String DYNAMIC = I18N.getInstance().get(KEY + ".dynamic");
    private static String TEST_EXPRESSION = I18N.getInstance().get(KEY + ".test-expression");
    private static String SCRIPT_INIT_ERROR = I18N.getInstance().get(KEY + ".script-initialisation-error");
    private static String SCRIPT_EVAL_ERROR = I18N.getInstance().get(KEY + ".script-evaluation-error");
    private static String CHECK_TYPES_MATCH = I18N.getInstance().get(KEY + ".check-types-match");
    private static String SCRIPT_EVAL = I18N.getInstance().get(KEY + ".script-evaluation");
    private static String SCRIPT_OK = I18N.getInstance().get(KEY + ".script-ok");
    String[] FUNCTIONS = new String[]{".trim()", ".toLowerCase()", ".toUpperCase()", ".length()", "round(double,int)", "FEATURE.ID", "GEOMETRY.area", "GEOMETRY.length", "GEOMETRY.coordinate.x", "GEOMETRY.coordinate.y", "GEOMETRY.coordinate.z", "GEOMETRY.geometryType", "GEOMETRY.numPoints", "GEOMETRY.distance(selection())", "GEOMETRY.isValid()", ".matches(?)", ".replaceAll(?,?)", ".substring(0,2)", "()?\"true\":\"false\"", "?==null?\"0\":\"1\""};
    Layer layer;
    String new_attribute_name = NEW_ATTRIBUTE_NAME;
    String bsh_expression = "\"Nb Pts = \" + GEOMETRY.getNumPoints()";
    AttributeType new_attribute_type = AttributeType.STRING;
    boolean dynamic;
    final Vector<String> keywords = new Vector();

    @Override
    public String getName() {
        return BEANSHELL_ATT_CAL;
    }

    @Override
    public void initialize(PlugInContext context) throws Exception {
        context.getFeatureInstaller().addMainMenuPlugin(this, new String[]{MenuNames.TOOLS, MenuNames.TOOLS_EDIT_ATTRIBUTES}, this.getName(), false, null, new MultiEnableCheck().add(context.getCheckFactory().createTaskWindowMustBeActiveCheck()).add(context.getCheckFactory().createAtLeastNLayersMustExistCheck(1)));
    }

    @Override
    public boolean execute(final PlugInContext context) {
        final DualPaneInputDialog dialog = new DualPaneInputDialog(context.getWorkbenchFrame(), BEANSHELL_ATT_CAL, true);
        if (this.layer == null) {
            this.layer = context.getCandidateLayer(0);
        }
        JComboBox<Layer> jcb_layer = dialog.addLayerComboBox(SOURCE_LAYER, this.layer, null, context.getLayerManager());
        this.keywords.clear();
        this.keywords.addAll(this.getFieldsFromLayer(this.layer));
        Collections.addAll(this.keywords, this.FUNCTIONS);
        JTextField jtf_att1 = dialog.addTextField(NEW_ATTRIBUTE_NAME, this.getDefaultAttributeName(this.new_attribute_name), 16, null, null);
        ArrayList<AttributeType> list = new ArrayList<AttributeType>();
        list.add(AttributeType.STRING);
        list.add(AttributeType.DOUBLE);
        list.add(AttributeType.INTEGER);
        list.add(AttributeType.LONG);
        list.add(AttributeType.BOOLEAN);
        list.add(AttributeType.DATE);
        list.add(AttributeType.OBJECT);
        JComboBox<AttributeType> jcb_type = dialog.addComboBox(NEW_ATTRIBUTE_TYPE, this.new_attribute_type, list, "");
        JCheckBox jcb_dynamic = dialog.addCheckBox(DYNAMIC, false, DYNAMIC);
        final JTextArea jta_bsh_expression = dialog.addTextAreaField(BSH_EXPRESSION, this.bsh_expression, 3, 50, true, null, BSH_EXPRESSION);
        JButton test_expression = dialog.addButton(TEST_EXPRESSION);
        test_expression.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BeanshellAttributeCalculatorPlugIn.this.checkExpression(context, dialog);
            }
        });
        dialog.setRightPane();
        final JList<String> keywordsList = new JList<String>(this.keywords);
        keywordsList.setVisibleRowCount(12);
        JScrollPane scrollPane = new JScrollPane(keywordsList);
        dialog.addSubTitle(SCRIPT_SNIPPETS);
        dialog.addRow(scrollPane);
        keywordsList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    jta_bsh_expression.replaceSelection(keywordsList.getSelectedValue().toString());
                }
            }
        });
        jcb_layer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BeanshellAttributeCalculatorPlugIn.this.layer = dialog.getLayer(GenericNames.SOURCE_LAYER);
                BeanshellAttributeCalculatorPlugIn.this.keywords.clear();
                BeanshellAttributeCalculatorPlugIn.this.keywords.addAll(BeanshellAttributeCalculatorPlugIn.this.getFieldsFromLayer(dialog.getLayer(GenericNames.SOURCE_LAYER)));
                Collections.addAll(BeanshellAttributeCalculatorPlugIn.this.keywords, BeanshellAttributeCalculatorPlugIn.this.FUNCTIONS);
                keywordsList.setListData(BeanshellAttributeCalculatorPlugIn.this.keywords);
            }
        });
        GUIUtil.centreOnWindow(dialog);
        dialog.setVisible(true);
        if (dialog.wasOKPressed()) {
            this.layer = dialog.getLayer(SOURCE_LAYER);
            this.new_attribute_name = dialog.getText(NEW_ATTRIBUTE_NAME);
            this.new_attribute_type = (AttributeType)dialog.getComboBox(NEW_ATTRIBUTE_TYPE).getSelectedItem();
            this.dynamic = dialog.getBoolean(DYNAMIC);
            this.bsh_expression = dialog.getText(BSH_EXPRESSION);
            return true;
        }
        return false;
    }

    @Override
    public void run(TaskMonitor monitor, PlugInContext context) throws Exception {
        monitor.allowCancellationRequests();
        monitor.report(COMPUTING_NEW_ATTRIBUTE + "...");
        FeatureCollectionWrapper fc = this.layer.getFeatureCollectionWrapper();
        FeatureSchema fs = fc.getFeatureSchema();
        BeanshellAttributeOperation operation = (BeanshellAttributeOperation)AttributeOperationFactory.getFactory(BeanshellAttributeOperation.class.getName()).createOperation(this.new_attribute_type, this.bsh_expression);
        FeatureSchema dfs = fs.clone();
        dfs.addAttribute(this.new_attribute_name, this.new_attribute_type);
        if (this.dynamic) {
            dfs.setOperation(dfs.getAttributeCount() - 1, operation);
            dfs.setAttributeReadOnly(dfs.getAttributeCount() - 1, true);
        }
        FeatureDataset result = new FeatureDataset(dfs);
        boolean errors = false;
        Object evalError = null;
        Iterator<Feature> it = fc.iterator();
        while (it.hasNext()) {
            Feature oldFeature = it.next();
            BasicFeature newFeature = new BasicFeature(dfs);
            for (int i = 0; i < fs.getAttributeCount(); ++i) {
                newFeature.setAttribute(fs.getAttributeName(i), oldFeature.getAttribute(i));
            }
            if (!this.dynamic) {
                newFeature.setAttribute(this.new_attribute_name, operation.evaluate((BasicFeature)oldFeature));
            }
            result.add(newFeature);
        }
        context.getLayerManager().addLayer(StandardCategoryNames.RESULT, this.layer.getName() + "_" + this.new_attribute_name, result);
    }

    private List getFieldsFromLayer(Layer l) {
        ArrayList<String> fields = new ArrayList<String>();
        FeatureSchema schema = l.getFeatureCollectionWrapper().getFeatureSchema();
        for (int i = 0; i < schema.getAttributeCount(); ++i) {
            fields.add(BeanshellAttributeOperation.normalizeVarName(schema.getAttributeName(i)));
        }
        return fields;
    }

    private String getDefaultAttributeName(String base) {
        if (base.startsWith(NEW_ATTRIBUTE_NAME)) {
            String ext = base.substring(NEW_ATTRIBUTE_NAME.length());
            if (ext.trim().length() == 0) {
                return NEW_ATTRIBUTE_NAME + "1";
            }
            if (ext.matches("[1-9][0-9]*")) {
                return NEW_ATTRIBUTE_NAME + (Integer.parseInt(ext) + 1);
            }
            return base;
        }
        return NEW_ATTRIBUTE_NAME;
    }

    private void checkExpression(PlugInContext context, DualPaneInputDialog dialog) {
        String tmp_bsh_expression = dialog.getText(BSH_EXPRESSION);
        FeatureCollectionWrapper fc = this.layer.getFeatureCollectionWrapper();
        this.new_attribute_type = (AttributeType)dialog.getComboBox(NEW_ATTRIBUTE_TYPE).getSelectedItem();
        try {
            BeanshellAttributeOperation operation = (BeanshellAttributeOperation)AttributeOperationFactory.getFactory(BeanshellAttributeOperation.class.getName()).createOperation(this.new_attribute_type, tmp_bsh_expression);
            int count = 0;
            for (BasicFeature old : fc) {
                operation.evaluate(old);
                if (count++ <= 6) continue;
                break;
            }
            if (count == 0) {
                operation.evaluate(this.createFakeFeature(fc.getFeatureSchema()));
            }
            this.bsh_expression = tmp_bsh_expression;
        }
        catch (EvalError e) {
            ErrorDialog.show(dialog, SCRIPT_EVAL_ERROR, e.toString(), StringUtil.stackTrace(e));
            return;
        }
        catch (NumberFormatException e) {
            ErrorDialog.show(dialog, SCRIPT_EVAL_ERROR, CHECK_TYPES_MATCH + "\n" + e.toString(), StringUtil.stackTrace(e));
            return;
        }
        catch (ParseException e) {
            ErrorDialog.show(dialog, SCRIPT_EVAL_ERROR, CHECK_TYPES_MATCH + "\n" + e.toString(), StringUtil.stackTrace(e));
            return;
        }
        catch (IllegalArgumentException e) {
            ErrorDialog.show(dialog, SCRIPT_EVAL_ERROR, CHECK_TYPES_MATCH + "\n" + e.toString(), StringUtil.stackTrace(e));
            return;
        }
        final JDialog okDialog = new JDialog(dialog, SCRIPT_EVAL, true);
        okDialog.getContentPane().setLayout(new BorderLayout(20, 10));
        OKCancelPanel okPanel = new OKCancelPanel();
        okPanel.setOKPressed(true);
        okPanel.getSelectedButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                okDialog.setVisible(false);
            }
        });
        okPanel.setCancelVisible(false);
        okDialog.getContentPane().add((Component)new JLabel(SCRIPT_OK), "Center");
        okDialog.getContentPane().add((Component)okPanel, "South");
        okDialog.getContentPane().add((Component)new JLabel(), "North");
        okDialog.getContentPane().add((Component)new JLabel(), "East");
        okDialog.getContentPane().add((Component)new JLabel(), "West");
        GUIUtil.centreOnWindow(okDialog);
        okDialog.setVisible(true);
    }

    private BasicFeature createFakeFeature(FeatureSchema fs) {
        BasicFeature bf = new BasicFeature(fs);
        for (int i = 0; i < fs.getAttributeCount(); ++i) {
            if (fs.isOperation(i)) continue;
            if (fs.getAttributeType(i) == AttributeType.STRING) {
                bf.setAttribute(i, (Object)"Micha\ufffdl");
                continue;
            }
            if (fs.getAttributeType(i) == AttributeType.DOUBLE) {
                bf.setAttribute(i, (Object)9.999);
                continue;
            }
            if (fs.getAttributeType(i) == AttributeType.INTEGER) {
                bf.setAttribute(i, (Object)100);
                continue;
            }
            if (fs.getAttributeType(i) == AttributeType.LONG) {
                bf.setAttribute(i, (Object)1000000L);
                continue;
            }
            if (fs.getAttributeType(i) == AttributeType.BOOLEAN) {
                bf.setAttribute(i, (Object)true);
                continue;
            }
            if (fs.getAttributeType(i) == AttributeType.DATE) {
                bf.setAttribute(i, (Object)new Date());
                continue;
            }
            if (fs.getAttributeType(i) != AttributeType.GEOMETRY) continue;
            bf.setAttribute(i, (Object)new GeometryFactory().createPoint((Coordinate)null));
        }
        return bf;
    }
}

