/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.raster;

import com.sun.media.jai.codecimpl.util.RasterFactory;
import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.util.FileUtil;
import com.vividsolutions.jump.workbench.JUMPWorkbench;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.FenceLayerFinder;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.JTablePanel;
import com.vividsolutions.jump.workbench.ui.cursortool.RectangleTool;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.IOException;
import java.util.Objects;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.openjump.core.CheckOS;
import org.openjump.core.apitools.IOTools;
import org.openjump.core.rasterimage.RasterImageIO;
import org.openjump.core.rasterimage.RasterImageLayer;
import org.openjump.core.ui.io.file.FileNameExtensionFilter;

public class RasterQueryDragTool
extends RectangleTool {
    protected Coordinate tentativeCoordinate;
    public static final String LAYER_NAME = I18N.getInstance().get("org.openjump.core.ui.plugin.raster.RasterImageLayerPropertiesPlugIn.cell.values");
    public static final String LAYER = I18N.getInstance().get("org.openjump.core.ui.plugin.raster.RasterImageLayerPropertiesPlugIn.layer");
    RasterImageLayer rLayer;
    private final String sSaved = I18N.getInstance().get("org.openjump.core.ui.plugin.raster.RasterImageLayerPropertiesPlugIn.file.saved");
    private final String SCouldNotSave = I18N.getInstance().get("org.openjump.sextante.gui.additionalResults.AdditionalResultsPlugIn.Could-not-save-selected-result");

    public RasterQueryDragTool(WorkbenchContext context) {
        super(context);
        this.setColor(Color.red);
        this.setStroke(new BasicStroke(1.5f));
    }

    @Override
    public Icon getIcon() {
        return IconLoader.icon("information_16x16.png");
    }

    @Override
    public Cursor getCursor() {
        BufferedImage i = !CheckOS.isLinux() ? IconLoader.image("information_cursor.png") : IconLoader.image("information_cursor_2color.gif");
        return RasterQueryDragTool.createCursor(i);
    }

    @Override
    protected void gestureFinished() throws NoninvertibleTransformException, IOException, RasterImageLayer.RasterDataNotFoundException {
        this.reportNothingToUndoYet();
        WorkbenchContext wbcontext = this.getWorkbench().getContext();
        RasterImageLayer[] ls = wbcontext.getLayerableNamePanel().selectedNodes(RasterImageLayer.class).toArray(new RasterImageLayer[0]);
        if (ls != null && ls.length > 0) {
            this.rLayer = ls[0];
            this.reportNothingToUndoYet();
            this.getPanel().setViewportInitialized(true);
            FenceLayerFinder fenceLayerFinder = new FenceLayerFinder(this.getPanel());
            fenceLayerFinder.setFence((Geometry)this.getRectangle());
            if (!fenceLayerFinder.getLayer().isVisible()) {
                fenceLayerFinder.getLayer().setVisible(true);
            }
            this.printArray(this.rLayer, (Geometry)this.getRectangle());
        }
    }

    public MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerNamePanelMustBeActiveCheck()).add(checkFactory.createWindowWithLayerViewPanelMustBeActiveCheck()).add(checkFactory.createExactlyNLayerablesMustBeSelectedCheck(1, RasterImageLayer.class));
    }

    @Override
    public String getName() {
        return I18N.getInstance().get("org.openjump.core.ui.plugin.raster.RasterQueryPlugIn");
    }

    public void printArray(RasterImageLayer rLayer, Geometry fence) throws NoninvertibleTransformException, IOException {
        Raster raster = null;
        Envelope envWanted = fence.getEnvelopeInternal().intersection(rLayer.getWholeImageEnvelope());
        Rectangle subset = rLayer.getRectangleFromEnvelope(envWanted);
        raster = rLayer.getRasterData(subset);
        int w = raster.getWidth();
        int h = raster.getHeight();
        Object[][] data = new Object[w][h];
        Object[] columnNames = new Object[w];
        for (int x = 0; x < w; ++x) {
            columnNames[x] = "Col" + x;
            for (int y = 0; y < h; ++y) {
                data[x][y] = raster.getSampleDouble(x, y, 0);
            }
        }
        DefaultTableModel tableModel = new DefaultTableModel(data, columnNames);
        final JTablePanel jTablePanel = new JTablePanel(tableModel);
        jTablePanel.getAllComponetsExceptTable().removeAll();
        jTablePanel.getTable().setAutoResizeMode(0);
        jTablePanel.getTable().setTableHeader(null);
        jTablePanel.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                Dialog dialog;
                Window window = SwingUtilities.getWindowAncestor(jTablePanel);
                if (window instanceof Dialog && !(dialog = (Dialog)window).isResizable()) {
                    dialog.setResizable(true);
                }
            }
        });
        JPanel pan = new JPanel(new BorderLayout());
        pan.setPreferredSize(new Dimension(400, 300));
        pan.add((Component)jTablePanel, "Center");
        pan.add((Component)this.savePanel(jTablePanel.getTable()), "South");
        JOptionPane.showOptionDialog(null, pan, I18N.getInstance().get("org.openjump.core.ui.plugin.raster.RasterQueryPlugIn"), -1, -1, null, new Object[0], null);
    }

    private JPanel savePanel(final JTable jTable) {
        JPanel save = new JPanel();
        save.setLayout(new FlowLayout(2));
        JButton saveButton = new JButton(I18N.getInstance().get("deejump.plugin.SaveLegendPlugIn.Save"));
        saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    File file = null;
                    FileNameExtensionFilter filter2 = new FileNameExtensionFilter("Comma-Separated Values (csv)", "csv");
                    FileNameExtensionFilter filter3 = new FileNameExtensionFilter("Tagged Image Format", "tif");
                    GUIUtil.FileChooserWithOverwritePrompting fc = new GUIUtil.FileChooserWithOverwritePrompting();
                    fc.setFileFilter(filter3);
                    fc.setFileFilter(filter2);
                    fc.addChoosableFileFilter(filter2);
                    int returnVal = fc.showSaveDialog(JUMPWorkbench.getInstance().getFrame());
                    if (returnVal == 0) {
                        if (fc.getFileFilter().equals(filter2)) {
                            file = new File(((JFileChooser)fc).getSelectedFile() + ".csv");
                            FileUtil.addExtensionIfNone(file, "csv");
                            IOTools.saveCSV(jTable, file.getAbsolutePath());
                            RasterQueryDragTool.this.saved(file);
                        } else if (fc.getFileFilter().equals(filter3)) {
                            RasterImageIO rasterImageIO;
                            file = new File(((JFileChooser)fc).getSelectedFile() + ".tif");
                            FileUtil.addExtensionIfNone(file, "tif");
                            Envelope envWanted = RasterQueryDragTool.this.getRectangle().getEnvelopeInternal();
                            Rectangle subset = RasterQueryDragTool.this.rLayer.getRectangleFromEnvelope(envWanted);
                            Raster raster = RasterQueryDragTool.this.rLayer.getRasterData(subset);
                            if (RasterQueryDragTool.this.rLayer.getImage().getColorModel() instanceof IndexColorModel) {
                                IndexColorModel indexColorModel = (IndexColorModel)RasterQueryDragTool.this.rLayer.getImage().getColorModel();
                                DataBuffer dataBufferIn = raster.getDataBuffer();
                                DataBufferByte dataBufferOut = new DataBufferByte(subset.width * subset.height * 3, 3);
                                int index = 0;
                                int nCells = subset.height * subset.width;
                                for (int r = 0; r < subset.height; ++r) {
                                    for (int c = 0; c < subset.width; ++c) {
                                        int value = dataBufferIn.getElem(index);
                                        dataBufferOut.setElem(0, index, indexColorModel.getRed(value));
                                        dataBufferOut.setElem(1, index + nCells, indexColorModel.getGreen(value));
                                        dataBufferOut.setElem(2, index + nCells * 2, indexColorModel.getBlue(value));
                                        ++index;
                                    }
                                }
                                int[] bankIndices = new int[]{0, 1, 2};
                                int[] bandOffsets = new int[]{0, raster.getWidth() * raster.getHeight(), 2 * raster.getWidth() * raster.getHeight()};
                                WritableRaster wRaster = RasterFactory.createBandedRaster((DataBuffer)dataBufferOut, (int)raster.getWidth(), (int)raster.getHeight(), (int)raster.getWidth(), (int[])bankIndices, (int[])bandOffsets, (Point)new Point(0, 0));
                                raster = wRaster;
                            }
                            RasterImageIO rasterImageIO2 = rasterImageIO = new RasterImageIO();
                            Objects.requireNonNull(rasterImageIO2);
                            rasterImageIO.writeImage(file, raster, envWanted, rasterImageIO2.new RasterImageIO.CellSizeXY(RasterQueryDragTool.this.rLayer.getMetadata().getOriginalCellSize(), RasterQueryDragTool.this.rLayer.getMetadata().getOriginalCellSize()), RasterQueryDragTool.this.rLayer.getMetadata().getNoDataValue());
                            RasterQueryDragTool.this.saved(file);
                        }
                    }
                }
                catch (Exception ex) {
                    RasterQueryDragTool.this.notsaved();
                }
            }
        });
        save.add(saveButton);
        return save;
    }

    protected void saved(File file) {
        JUMPWorkbench.getInstance().getFrame().setStatusMessage(this.sSaved + " :" + file.getAbsolutePath());
    }

    protected void notsaved() {
        JUMPWorkbench.getInstance().getFrame().warnUser(this.SCouldNotSave);
    }
}

