/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.raster;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.cursortool.MultiClickTool;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.awt.geom.NoninvertibleTransformException;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import org.locationtech.jts.geom.Coordinate;
import org.openjump.core.rasterimage.RasterImageLayer;
import org.openjump.core.ui.plugin.raster.ProfileGraphGUI;

public class ProfileGraphTool
extends MultiClickTool {
    private static final String sDistance = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.MeasureM_FTool.Distance");
    private List<Coordinate> savedCoordinates = new ArrayList<Coordinate>();
    public static Coordinate currCoord;
    public Coordinate[] coordinates;

    public ProfileGraphTool(WorkbenchContext context) {
        super(context);
        this.allowSnapping();
    }

    @Override
    public Icon getIcon() {
        return IconLoader.icon("profile.png");
    }

    @Override
    public Cursor getCursor() {
        for (int i = 0; i < this.savedCoordinates.size(); ++i) {
            this.add(this.savedCoordinates.get(i));
        }
        return ProfileGraphTool.createCursor(IconLoader.icon("profile_icon.gif").getImage());
    }

    @Override
    public void mouseLocationChanged(MouseEvent e) {
        try {
            if (this.isShapeOnScreen()) {
                ArrayList<Coordinate> currentCoordinates = new ArrayList<Coordinate>(this.getCoordinates());
                currentCoordinates.add(this.getPanel().getViewport().toModelCoordinate(e.getPoint()));
                this.display(currentCoordinates, this.getPanel());
            }
            currCoord = this.snap(e.getPoint());
            super.mouseLocationChanged(e);
        }
        catch (Throwable t) {
            this.getPanel().getContext().handleThrowable(t);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        super.mousePressed(e);
        this.savedCoordinates = new ArrayList<Coordinate>(this.getCoordinates());
    }

    @Override
    protected void gestureFinished() throws NoninvertibleTransformException, IOException, RasterImageLayer.RasterDataNotFoundException {
        this.reportNothingToUndoYet();
        this.savedCoordinates.clear();
        this.display(this.getCoordinates(), this.getPanel());
        if (ProfileGraphGUI.getLayer() == null) {
            this.getPanel().getContext().warnUser(I18N.getInstance().get("pirol.plugIns.EditAttributeByFormulaPlugIn.no-layer-selected"));
            return;
        }
        this.coordinates = new Coordinate[this.getCoordinates().size()];
        int i = 0;
        Iterator<Coordinate> iterator = this.getCoordinates().iterator();
        while (iterator.hasNext()) {
            Coordinate c;
            this.coordinates[i] = c = iterator.next();
            ++i;
        }
        ProfileGraphGUI.calculateProfile(this.coordinates);
    }

    private void display(List<Coordinate> coordinates, LayerViewPanel panel) throws NoninvertibleTransformException {
        this.display(this.distance(coordinates), panel);
    }

    private void display(double distance, LayerViewPanel panel) {
        DecimalFormat df3 = new DecimalFormat("###,###,##0.0##");
        String distString = df3.format(distance / 0.3048);
        panel.getContext().setStatusMessage(sDistance + ": " + panel.format(distance) + "  m  (" + distString + " ft)");
    }

    private double distance(List<Coordinate> coordinates) {
        double distance = 0.0;
        for (int i = 1; i < coordinates.size(); ++i) {
            distance += coordinates.get(i - 1).distance(coordinates.get(i));
        }
        if (currCoord != null && coordinates.size() > 1) {
            distance -= coordinates.get(coordinates.size() - 2).distance(coordinates.get(coordinates.size() - 1));
            distance += coordinates.get(coordinates.size() - 2).distance(currCoord);
        }
        return distance;
    }

    @Override
    public String getName() {
        return I18N.getInstance().get("org.openjump.core.ui.plugin.raster.ProfileGraphPlugIn.Profile-Graph");
    }
}

