/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.raster;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.workbench.JUMPWorkbench;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.plugin.ThreadedBasePlugIn;
import com.vividsolutions.jump.workbench.ui.ColorChooserPanel;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import com.vividsolutions.jump.workbench.ui.MultiInputDialog;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.openjump.core.apitools.LayerTools;
import org.openjump.core.ccordsys.Unit;
import org.openjump.core.rasterimage.RasterImageLayer;
import org.openjump.core.ui.plugin.raster.ProfileGraphGUI;
import org.openjump.core.ui.plugin.raster.ProfileGraphTool;

public class ProfileGraphPlugIn
extends ThreadedBasePlugIn {
    public static String CLAYER = I18N.getInstance().get("ui.GenericNames.Source-Layer");
    private final String DRAWN = I18N.getInstance().get("org.openjump.core.ui.plugin.raster.ProfileGraphTool.draw-linstring-as-trace");
    private final String SELECTED = I18N.getInstance().get("org.openjump.core.ui.plugin.raster.ProfileGraphTool.use-selected-linstring-as-trace");
    private final String sName = I18N.getInstance().get("org.openjump.core.ui.plugin.raster.ProfileGraphPlugIn.Profile-Graph");
    private final String WARNING = I18N.getInstance().get("org.openjump.core.ui.plugin.raster.ProfileGraphTool.select-one-linstring");
    public final String PROFILE_INFO = I18N.getInstance().get("org.openjump.core.ui.plugin.layer.LayerPropertiesPlugIn.Info");
    public final String PLOT = I18N.getInstance().get("org.openjump.core.ui.plugin.raster.ProfileGraphTool.Profile-Plot");
    private final String OPTIONS = I18N.getInstance().get("com.vividsolutions.jump.workbench.ui.plugin.OptionsPlugIn");
    public static String HEIGHT = I18N.getInstance().get("org.openjump.core.ui.plugin.raster.ProfileGraphTool.values");
    public static String WIDTH = I18N.getInstance().get("org.openjump.core.ui.plugin.raster.ProfileGraphTool.2d-distance");
    public final String DESCRIPTION = I18N.getInstance().get("org.openjump.core.ui.plugin.raster.ProfileGraphTool.Description");
    private static String SELECT_BAND = I18N.getInstance().get("org.openjump.core.ui.plugin.raster.HistogramPlugIn.select-one-band");
    private static String LAYER_UNIT = I18N.getInstance().get("org.openjump.core.ui.plugin.file.ProjectInfoPlugIn.srs-unit");
    private static String VERICAL_AXES_LABEL = I18N.getInstance().get("org.openjump.core.ui.plugin.raster.ProfileGraphTool.vertical-axes-label");
    private static String HORIZONTAL_AXES_LABEL = I18N.getInstance().get("org.openjump.core.ui.plugin.raster.ProfileGraphTool.horizontal-axes-label");
    private static String COLOR = I18N.getInstance().get("ui.renderer.style.ColorThemingTableModel.colour");
    private static String CHOOSE_COLOR = I18N.getInstance().get("ui.ColorChooserPanel.choose-color");
    public static String UNIT;
    public static int numband;
    private boolean drawnType = true;
    private boolean selectedType = false;
    public static Color color;
    final ColorChooserPanel cpan = new ColorChooserPanel();
    private static RasterImageLayer rLayer;
    public static JTextField unitfiled;
    public static MultiInputDialog dialog;
    private final List<Coordinate> savedCoordinates = new ArrayList<Coordinate>();
    JComboBox<RasterImageLayer> box;
    JComboBox<String> comboBox = new JComboBox();

    @Override
    public void initialize(PlugInContext context) throws Exception {
        context.getFeatureInstaller().addMainMenuPlugin(this, new String[]{MenuNames.RASTER}, this.getName() + "...", false, this.getIcon(), ProfileGraphPlugIn.check(context));
    }

    @Override
    public String getName() {
        return this.sName;
    }

    public static MultiEnableCheck check(PlugInContext c) {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance(c.getWorkbenchContext());
        return new MultiEnableCheck().add(checkFactory.createWindowWithAssociatedTaskFrameMustBeActiveCheck()).add(checkFactory.createAtLeastNLayerablesOfTypeMustExistCheck(1, RasterImageLayer.class));
    }

    private void getDialogValues(MultiInputDialog dialog) {
        this.drawnType = dialog.getBoolean(this.DRAWN);
        this.selectedType = dialog.getBoolean(this.SELECTED);
        WIDTH = dialog.getText(HORIZONTAL_AXES_LABEL);
        HEIGHT = dialog.getText(VERICAL_AXES_LABEL);
        UNIT = dialog.getText(LAYER_UNIT);
        rLayer = (RasterImageLayer)dialog.getLayerable(CLAYER);
    }

    private void setDialogValues(final MultiInputDialog dialog, PlugInContext context) {
        String srsCode;
        List<RasterImageLayer> rlayers = context.getTask().getLayerManager().getLayerables(RasterImageLayer.class);
        ArrayList<String> srsArray = new ArrayList<String>();
        dialog.setSideBarDescription(this.DESCRIPTION);
        dialog.addSubTitle(this.PLOT);
        rLayer = !context.getLayerNamePanel().selectedNodes(RasterImageLayer.class).isEmpty() ? (RasterImageLayer)LayerTools.getSelectedLayerable(context, RasterImageLayer.class) : context.getTask().getLayerManager().getLayerables(RasterImageLayer.class).get(0);
        this.box = dialog.addLayerableComboBox(CLAYER, rLayer, "", rlayers);
        srsArray.add("metre");
        srsArray.add("foot");
        String srs = "";
        for (RasterImageLayer currentLayer : rlayers) {
            try {
                srs = currentLayer.getSrsInfo().getUnit().toString();
            }
            catch (Exception e) {
                srs = "metre";
            }
            if (!(!srs.isEmpty() & !srsArray.contains(srs))) continue;
            srsArray.add(Unit.find(srs).toString());
        }
        RasterImageLayer firstElement = (RasterImageLayer)rlayers.toArray()[0];
        try {
            srsCode = firstElement.getSrsInfo().getUnit().toString();
        }
        catch (Exception e) {
            srsCode = "Unknown";
        }
        String OUTPUT_GROUP = "Match Type";
        this.comboBox = dialog.addComboBox(LAYER_UNIT, "", srsArray, null);
        this.comboBox.setRenderer(new DefaultListCellRenderer(){
            private static final long serialVersionUID = 1L;

            @Override
            public void paint(Graphics g) {
                this.setForeground(Color.BLACK);
                super.paint(g);
            }
        });
        this.comboBox.setEnabled(srsCode.equals("Unknown"));
        this.comboBox.setSelectedItem(srsCode);
        dialog.addRadioButton(this.DRAWN, "Match Type", this.drawnType, null);
        Collection<Feature> features = context.getLayerViewPanel().getSelectionManager().getFeaturesWithSelectedItems();
        if (features.size() == 0 || features.size() > 1) {
            dialog.addRadioButton(this.SELECTED, "Match Type", this.selectedType, null).setEnabled(false);
        } else {
            dialog.addRadioButton(this.SELECTED, "Match Type", this.selectedType, null).setEnabled(true);
        }
        dialog.addSubTitle(this.OPTIONS);
        dialog.addTextField(HORIZONTAL_AXES_LABEL, WIDTH, 20, null, null);
        dialog.addTextField(VERICAL_AXES_LABEL, HEIGHT, 20, null, null);
        this.box.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String layerUnit = ProfileGraphPlugIn.getLayer().getSrsInfo().getUnit().toString();
                unitfiled.setText(layerUnit);
                ProfileGraphPlugIn.this.updateComponents();
                dialog.repaint();
            }
        });
        this.cpan.addActionListener(evt -> {
            color = this.cpan.getColor();
        });
        this.cpan.setColor(color);
        this.cpan.setAlpha(255);
        dialog.addRow("CheckColor", new JLabel(COLOR + " (" + this.PLOT + ")"), this.cpan, null, CHOOSE_COLOR);
    }

    public void updateComponents() {
        String layerUnit = ProfileGraphPlugIn.getLayer().getSrsInfo().getUnit().toString();
        this.comboBox.setEnabled(layerUnit.equals("Unknown"));
        this.comboBox.setSelectedItem(layerUnit);
    }

    public static RasterImageLayer getLayer() {
        return dialog.getRasterLayer(CLAYER);
    }

    public static String getUnit() {
        return dialog.getText(LAYER_UNIT);
    }

    @Override
    public Icon getIcon() {
        return IconLoader.icon("profile.png");
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        dialog = new MultiInputDialog(context.getWorkbenchFrame(), this.getName(), true);
        this.setDialogValues(dialog, context);
        GUIUtil.centreOnWindow(dialog);
        dialog.setVisible(true);
        return true;
    }

    @Override
    public void run(TaskMonitor monitor, PlugInContext context) throws Exception {
        monitor.allowCancellationRequests();
        monitor.report(this.getName() + ": " + I18N.getInstance().get("org.openjump.core.ui.plugin.edittoolbox.cursortools.FillPolygonTool.computing"));
        if (ProfileGraphGUI.resultFC != null || ProfileGraphGUI.nPoints > 0) {
            ProfileGraphGUI.resultFC.clear();
            ProfileGraphGUI.nPoints = 0;
        }
        this.savedCoordinates.clear();
        this.getDialogValues(dialog);
        if (!dialog.wasOKPressed()) {
            return;
        }
        RasterImageLayer selLayer = dialog.getRasterLayer(CLAYER);
        numband = 0;
        if (selLayer.getNumBands() > 1) {
            Object[] bands = new String[]{"0", "1", "2"};
            String stringInput = (String)JOptionPane.showInputDialog(JUMPWorkbench.getInstance().getFrame(), SELECT_BAND, this.sName, -1, null, bands, "0");
            try {
                numband = Integer.parseInt(stringInput);
            }
            catch (NumberFormatException e) {
                return;
            }
        }
        if (this.drawnType) {
            ProfileGraphTool profileTool = new ProfileGraphTool(context.getWorkbenchContext());
            context.getLayerViewPanel().setCurrentCursorTool(profileTool);
        } else if (this.selectedType) {
            Collection<Feature> features = context.getLayerViewPanel().getSelectionManager().getFeaturesWithSelectedItems();
            if (features.size() != 1) {
                context.getWorkbenchFrame().warnUser(I18N.getInstance().get("com.vividsolutions.jump.workbench.plugin.Exactly-n-features-must-be-selected", 1));
            } else {
                Geometry geom = features.iterator().next().getGeometry();
                if (geom instanceof LineString) {
                    Coordinate[] coords = geom.getCoordinates();
                    ProfileGraphGUI.calculateProfile(coords);
                } else {
                    context.getWorkbenchFrame().warnUser(this.WARNING);
                }
            }
        }
    }

    static {
        color = Color.blue.brighter();
        unitfiled = new JTextField("");
    }
}

