/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.mousemenu.category;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Category;
import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.LayerNamePanel;
import com.vividsolutions.jump.workbench.ui.PopupNodeProxy;
import com.vividsolutions.jump.workbench.ui.TitledPopupMenu;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import com.vividsolutions.jump.workbench.ui.plugin.FeatureInstaller;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;

public class SetCategoryVisibilityPlugIn
extends AbstractPlugIn {
    protected Map layer2Visibility = new HashMap();
    protected PlugInContext context = null;
    protected JCheckBoxMenuItem menuItem = null;
    protected static SetCategoryVisibilityPlugIn instance = null;

    public SetCategoryVisibilityPlugIn() {
        instance = this;
    }

    public static SetCategoryVisibilityPlugIn getInstance(PlugInContext context) {
        if (instance == null) {
            instance = new SetCategoryVisibilityPlugIn();
            SetCategoryVisibilityPlugIn.instance.context = context;
        }
        return instance;
    }

    @Override
    public String getName() {
        return I18N.getInstance().get("org.openjump.core.ui.plugin.mousemenu.category.SetCategoryVisibilityPlugIn.Set-Category-Visibility");
    }

    @Override
    public void initialize(PlugInContext context) throws Exception {
        super.initialize(context);
        this.context = context;
        TitledPopupMenu layerNamePopupMenu = context.getWorkbenchContext().getWorkbench().getFrame().getCategoryPopupMenu();
        FeatureInstaller featInst = context.getFeatureInstaller();
        this.menuItem = (JCheckBoxMenuItem)featInst.addPopupMenuPlugin(layerNamePopupMenu, this, this.getName() + "...", true, GUIUtil.toSmallIcon((ImageIcon)this.getIcon()), SetCategoryVisibilityPlugIn.createEnableCheck(context.getWorkbenchContext()));
    }

    public static MultiEnableCheck createEnableCheck(final WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance(workbenchContext);
        MultiEnableCheck multiEnableCheck = new MultiEnableCheck();
        multiEnableCheck.add(checkFactory.createAtLeastNCategoriesMustBeSelectedCheck(1));
        multiEnableCheck.add(new EnableCheck(){

            @Override
            public String check(JComponent component) {
                SetCategoryVisibilityPlugIn.getInstance(workbenchContext.createPlugInContext()).updateMenuItem();
                return null;
            }
        });
        return multiEnableCheck;
    }

    @Override
    public Icon getIcon() {
        return IconLoader.icon("eye.png");
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        LayerNamePanel lnp = context.getLayerNamePanel();
        Collection<Category> selCats = lnp.getSelectedCategories();
        Iterator<Category> iter = selCats.iterator();
        Boolean visible = null;
        Category cat_clicked = this.getClickedCategory();
        if (cat_clicked != null) {
            visible = !this.isCategoryVisible(cat_clicked);
        }
        while (iter.hasNext()) {
            Category cat = iter.next();
            if (visible == null) {
                visible = !this.isCategoryVisible(cat);
            }
            if (this.isCategoryVisible(cat) == visible.booleanValue()) continue;
            this.setLayersVisibility(cat.getLayerables(), visible);
        }
        return true;
    }

    private Category getClickedCategory() {
        Object o;
        PlugInContext context = this.context.getWorkbenchContext().createPlugInContext();
        LayerNamePanel lnp = context.getLayerNamePanel();
        Collection<Category> selCats = lnp.getSelectedCategories();
        Iterator<Category> iter = selCats.iterator();
        if (lnp instanceof PopupNodeProxy && (o = ((PopupNodeProxy)((Object)lnp)).getPopupNode()) instanceof Category) {
            return (Category)o;
        }
        return selCats.isEmpty() ? null : selCats.iterator().next();
    }

    private boolean isCategoryVisible(Category cat) {
        boolean lvisible = false;
        for (Layerable l : cat.getLayerables()) {
            if (!l.isVisible()) continue;
            lvisible = true;
            break;
        }
        return lvisible;
    }

    private void setLayersVisibility(List layers, boolean visible) {
        Iterator iter = layers.iterator();
        boolean changed = false;
        while (iter.hasNext()) {
            Layerable layer = (Layerable)iter.next();
            if (!visible) {
                this.layer2Visibility.put(layer, new Boolean(layer.isVisible()));
                layer.setVisible(false);
                continue;
            }
            if (!this.layer2Visibility.containsKey(layer)) continue;
            boolean lvisible = (Boolean)this.layer2Visibility.get(layer);
            if (lvisible) {
                layer.setVisible(lvisible);
                changed = true;
            }
            this.layer2Visibility.remove(layer);
        }
        if (visible && !changed) {
            for (Layerable l : layers) {
                l.setVisible(true);
            }
        }
    }

    public void updateMenuItem() {
        Category cat_clicked = this.getClickedCategory();
        if (cat_clicked == null) {
            return;
        }
        boolean visible = this.isCategoryVisible(cat_clicked);
        this.menuItem.setSelected(visible);
    }
}

