/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.mousemenu;

import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.EditTransaction;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.plugin.FeatureInstaller;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.ImageIcon;
import javax.swing.JPopupMenu;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateArrays;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.openjump.core.ui.images.IconLoader;

public class ReverseOrientationPlugIn
extends AbstractPlugIn {
    public static final ImageIcon ICON = IconLoader.icon("reverse.png");

    @Override
    public void initialize(PlugInContext context) throws Exception {
        super.initialize(context);
        WorkbenchContext workbenchContext = context.getWorkbenchContext();
        FeatureInstaller featureInstaller = context.getFeatureInstaller();
        JPopupMenu popupMenu = LayerViewPanel.popupMenu();
        featureInstaller.addPopupMenuItem(popupMenu, this, this.getName(), false, ICON, this.createEnableCheck(workbenchContext));
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        ArrayList<EditTransaction> transactions = new ArrayList<EditTransaction>();
        this.reportNothingToUndoYet(context);
        Collection<Layer> layers = context.getLayerViewPanel().getSelectionManager().getLayersWithSelectedItems();
        for (Layer layerWithSelectedItems : layers) {
            transactions.add(this.createTransaction(layerWithSelectedItems, context));
        }
        EditTransaction.commit(transactions);
        return true;
    }

    private EditTransaction createTransaction(Layer layer, PlugInContext context) {
        EditTransaction transaction = EditTransaction.createTransactionOnSelection(new EditTransaction.SelectionEditor(){

            public Geometry edit(Geometry geometryWithSelectedItems, Collection selectedItems) {
                Iterator j = selectedItems.iterator();
                while (j.hasNext()) {
                    ReverseOrientationPlugIn.this.reverse((Geometry)j.next());
                }
                return geometryWithSelectedItems;
            }
        }, context.getLayerViewPanel(), context.getLayerViewPanel().getContext(), this.getName(), layer, false, false);
        return transaction;
    }

    private void reverse(Geometry geometry) {
        if (geometry instanceof GeometryCollection) {
            this.reverse((GeometryCollection)geometry);
        } else if (geometry instanceof Polygon) {
            this.reverse((Polygon)geometry);
        } else if (geometry instanceof LineString) {
            this.reverse((LineString)geometry);
        }
    }

    private void reverse(GeometryCollection geometry) {
        for (int i = 0; i < geometry.getNumGeometries(); ++i) {
            this.reverse(geometry.getGeometryN(i));
        }
    }

    private void reverse(Polygon geometry) {
        CoordinateArrays.reverse((Coordinate[])geometry.getExteriorRing().getCoordinates());
        for (int i = 0; i < geometry.getNumInteriorRing(); ++i) {
            CoordinateArrays.reverse((Coordinate[])geometry.getInteriorRingN(i).getCoordinates());
        }
    }

    private void reverse(LineString geometry) {
        CoordinateArrays.reverse((Coordinate[])geometry.getCoordinates());
    }

    private void reverse(Point geometry) {
    }

    public MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerViewPanelMustBeActiveCheck()).add(checkFactory.createAtLeastNFeaturesMustHaveSelectedItemsCheck(1)).add(checkFactory.createSelectedItemsLayersMustBeEditableCheck());
    }
}

