/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.layer.pirolraster;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.model.WMSLayer;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.plugin.clipboard.CollectionOfLayerablesTransferable;
import com.vividsolutions.jump.workbench.ui.plugin.clipboard.DummyClipboardOwner;
import java.awt.Toolkit;
import java.util.ArrayList;
import java.util.Collection;
import org.openjump.core.rasterimage.RasterImageLayer;
import org.openjump.core.ui.plugin.layer.pirolraster.LayerableClipboardPlugIn;

public class CopySelectedRasterImageLayersPlugIn
extends LayerableClipboardPlugIn {
    @Override
    public String getName() {
        return I18N.getInstance().get("org.openjump.core.ui.plugin.layer.pirolraster.CopySelectedRasterImageLayersPlugIn.Copy-Selected-Raster-Image-Layers");
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        this.reportNothingToUndoYet(context);
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new CollectionOfLayerablesTransferable(this.clone(context.getLayerNamePanel().selectedNodes(Layerable.class))), new DummyClipboardOwner());
        return true;
    }

    private Collection clone(Collection layerables) {
        ArrayList<Layerable> clones = new ArrayList<Layerable>();
        for (Layerable layerable : layerables) {
            if (!(layerable instanceof Layer) && !(layerable instanceof WMSLayer) && !(layerable instanceof RasterImageLayer)) continue;
            System.out.println(this.cloneLayerable(layerable).getName());
            clones.add(this.cloneLayerable(layerable));
        }
        return clones;
    }

    public MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerNamePanelMustBeActiveCheck()).add(checkFactory.createAtLeastNLayerablesMustBeSelectedCheck(1, Layerable.class));
    }
}

