/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.file.save;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.util.Blackboard;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.datasource.DataSourceQueryChooser;
import com.vividsolutions.jump.workbench.datasource.DataSourceQueryChooserManager;
import com.vividsolutions.jump.workbench.datasource.FileDataSourceQueryChooser;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.InputChangedListener;
import com.vividsolutions.jump.workbench.ui.RecursiveKeyListener;
import com.vividsolutions.jump.workbench.ui.plugin.PersistentBlackboardPlugIn;
import com.vividsolutions.jump.workbench.ui.wizard.CancelNextException;
import com.vividsolutions.jump.workbench.ui.wizard.WizardDialog;
import com.vividsolutions.jump.workbench.ui.wizard.WizardPanelV2;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import javax.swing.plaf.FileChooserUI;
import javax.swing.plaf.basic.BasicFileChooserUI;
import org.openjump.core.ui.plugin.file.SaveWizardPlugIn;
import org.openjump.core.ui.plugin.file.open.JFCWithEnterAction;
import org.openjump.core.ui.plugin.file.save.FileDataSourceQueryChooserExtensionFilter;
import org.openjump.core.ui.plugin.file.save.SaveToFileWizard;

public class SelectFilePanel
extends JFCWithEnterAction
implements WizardPanelV2 {
    public static final String KEY = SelectFilePanel.class.getName();
    private static final String LASTFILE = null;
    private WorkbenchContext workbenchContext;
    private Set<InputChangedListener> listeners = new LinkedHashSet<InputChangedListener>();
    private WizardDialog dialog;
    private boolean isInputValidApproveRun = false;

    public SelectFilePanel(WorkbenchContext workbenchContext) {
        this.workbenchContext = workbenchContext;
        this.setControlButtonsAreShown(false);
        this.setMultiSelectionEnabled(false);
        this.setAcceptAllFileFilterUsed(false);
        List<DataSourceQueryChooser> loadChoosers = DataSourceQueryChooserManager.get(workbenchContext.getBlackboard()).getSaveDataSourceQueryChoosers();
        for (DataSourceQueryChooser chooser : loadChoosers) {
            if (!(chooser instanceof FileDataSourceQueryChooser)) continue;
            FileDataSourceQueryChooserExtensionFilter filter = new FileDataSourceQueryChooserExtensionFilter((FileDataSourceQueryChooser)chooser);
            this.addChoosableFileFilter(filter);
        }
        PropertyChangeListener changeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                SelectFilePanel.this.fireInputChanged();
            }
        };
        this.addPropertyChangeListener(changeListener);
        this.addKeyListener(new RecursiveKeyListener(this){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                SelectFilePanel.this.fireInputChanged();
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }
        });
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!"ApproveSelection".equals(e.getActionCommand())) {
                    return;
                }
                if (SelectFilePanel.this.isInputValidApproveRun) {
                    return;
                }
                if (SelectFilePanel.this.dialog != null) {
                    SelectFilePanel.this.dialog.next();
                }
            }
        };
        this.addActionListener(actionListener);
    }

    public void enteredFromLeft(Map dataMap) {
        Blackboard blackboard = PersistentBlackboardPlugIn.get(this.workbenchContext);
        String lastFilePath = (String)blackboard.get(LASTFILE);
        if (lastFilePath != null && !lastFilePath.isEmpty()) {
            this.setCurrentDirectory(new File(lastFilePath).getParentFile());
        }
        this.rescanCurrentDirectory();
        this.setData(SaveToFileWizard.DATAKEY_DATASOURCEQUERYCHOOSER, null);
        this.setData(SaveToFileWizard.DATAKEY_FILE, null);
        this.setSelectedFile(new File(""));
        String dataSetName = (String)this.getData(SaveWizardPlugIn.DATAKEY_SIMPLIFIED_LAYERNAME);
        if (dataSetName != null && !dataSetName.isEmpty()) {
            this.setSelectedFile(new File(dataSetName));
        }
    }

    @Override
    public void exitingToRight() throws Exception {
        boolean overwrite;
        if (!this.isInputValid()) {
            throw new CancelNextException();
        }
        File file = (File)this.getData(SaveToFileWizard.DATAKEY_FILE);
        if (file.exists() && !(overwrite = GUIUtil.showConfirmOverwriteDialog(this.getDialog(), file))) {
            throw new CancelNextException();
        }
        Blackboard blackboard = PersistentBlackboardPlugIn.get(this.workbenchContext);
        blackboard.put(LASTFILE, file.getPath());
    }

    @Override
    public void add(InputChangedListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void remove(InputChangedListener listener) {
        this.listeners.remove(listener);
    }

    private void fireInputChanged() {
        if (this.dialog == null || this.dialog.getData(WizardDialog.DATAKEY_CURRENTPANELID) != KEY) {
            return;
        }
        for (InputChangedListener listener : this.listeners) {
            listener.inputChanged();
        }
    }

    @Override
    public String getTitle() {
        return I18N.getInstance().get(KEY + ".title");
    }

    @Override
    public String getID() {
        return KEY;
    }

    @Override
    public String getInstructions() {
        return I18N.getInstance().get(KEY + ".instructions");
    }

    @Override
    public boolean isInputValid() {
        File file;
        this.setData(SaveToFileWizard.DATAKEY_DATASOURCEQUERYCHOOSER, null);
        this.setData(SaveToFileWizard.DATAKEY_FILE, null);
        SelectFilePanel jfc = this;
        FileChooserUI fcui = jfc.getUI();
        if (!this.isInputValidApproveRun && fcui instanceof BasicFileChooserUI) {
            BasicFileChooserUI bfcui = (BasicFileChooserUI)fcui;
            String filename = bfcui.getFileName();
            if (!(filename instanceof String) || filename.length() < 1) {
                return false;
            }
            this.isInputValidApproveRun = true;
            bfcui.getApproveSelectionAction().actionPerformed(new ActionEvent(new JButton(), 0, "nix"));
            this.isInputValidApproveRun = false;
        }
        if (!((file = ((JFileChooser)jfc).getSelectedFile()) instanceof File) || file.getName().isEmpty()) {
            return false;
        }
        FileFilter filter = this.getFileFilter();
        if (!(filter instanceof FileDataSourceQueryChooserExtensionFilter)) {
            return false;
        }
        FileDataSourceQueryChooserExtensionFilter datasourcefilter = (FileDataSourceQueryChooserExtensionFilter)filter;
        String[] extensions = ((FileDataSourceQueryChooserExtensionFilter)filter).getExtensions();
        if (extensions.length > 0 && !file.isDirectory() && !this.hasValidExtension(file, extensions)) {
            file = new File(file.getPath() + "." + extensions[0]);
        }
        if (file.isDirectory() || file.getName().isEmpty()) {
            return false;
        }
        this.setData(SaveToFileWizard.DATAKEY_DATASOURCEQUERYCHOOSER, datasourcefilter.getFileDataSourceQueryChooser());
        this.setData(SaveToFileWizard.DATAKEY_FILE, file);
        return true;
    }

    private boolean hasValidExtension(File file, String[] validExtensions) {
        String fileName = file.getName();
        for (String validExt : validExtensions) {
            if (!fileName.toLowerCase().endsWith("." + validExt.toLowerCase())) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getNextID() {
        return null;
    }

    @Override
    public void enteredFromRight() throws Exception {
    }

    public WizardDialog getDialog() {
        return this.dialog;
    }

    public void setDialog(WizardDialog dialog) {
        this.dialog = dialog;
    }

    private void setData(String key, Object value) {
        if (this.dialog != null) {
            this.dialog.setData(key, value);
        }
    }

    private Object getData(String key) {
        if (this.dialog != null) {
            return this.dialog.getData(key);
        }
        return null;
    }

    @Override
    public void exitingToLeft() {
    }
}

