/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.file.open;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.util.Blackboard;
import com.vividsolutions.jump.workbench.JUMPWorkbench;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.InputChangedListener;
import com.vividsolutions.jump.workbench.ui.plugin.PersistentBlackboardPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.SaveProjectAsPlugIn;
import com.vividsolutions.jump.workbench.ui.wizard.WizardDialog;
import com.vividsolutions.jump.workbench.ui.wizard.WizardPanel;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.openjump.core.ui.plugin.file.open.JFCWithEnterAction;
import org.openjump.core.ui.plugin.file.open.OpenProjectWizard;
import org.openjump.swing.listener.InvokeMethodActionListener;

public class SelectProjectFilesPanel
extends JFCWithEnterAction
implements WizardPanel {
    public static final String KEY = SelectProjectFilesPanel.class.getName();
    public static final String TITLE = I18N.getInstance().get("ui.plugin.OpenProjectPlugIn.open-project");
    public static final String INSTRUCTIONS = I18N.getInstance().get(KEY + ".instructions");
    public static final String ALL_FILES = I18N.getInstance().get(KEY + ".all-files");
    private Set<InputChangedListener> listeners = new LinkedHashSet<InputChangedListener>();
    private Blackboard blackboard;
    private ActionListener dialogActionListener;
    private boolean initialized = false;

    public SelectProjectFilesPanel(WorkbenchContext context) {
        this.setDialogType(0);
        this.setFileSelectionMode(0);
        this.setMultiSelectionEnabled(true);
        GUIUtil.removeChoosableFileFilters(this);
        this.addChoosableFileFilter(SaveProjectAsPlugIn.JUMP_PROJECT_FILE_FILTER);
        this.addChoosableFileFilter(GUIUtil.ALL_FILES_FILTER);
        this.setFileFilter(SaveProjectAsPlugIn.JUMP_PROJECT_FILE_FILTER);
        this.setControlButtonsAreShown(false);
        this.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                SelectProjectFilesPanel.this.fireInputChanged();
            }
        });
    }

    public void setDialog(WizardDialog dialog) {
        this.removeActionListener(this.dialogActionListener);
        this.dialogActionListener = new InvokeMethodActionListener(dialog, "next");
        this.addActionListener(this.dialogActionListener);
    }

    public void enteredFromLeft(Map dataMap) {
        Blackboard blackboard;
        String dir;
        if (!this.initialized && (dir = (String)(blackboard = PersistentBlackboardPlugIn.get(JUMPWorkbench.getInstance().getContext())).get(OpenProjectWizard.FILE_CHOOSER_DIRECTORY_KEY)) != null) {
            this.setCurrentDirectory(new File(dir));
        }
        this.rescanCurrentDirectory();
    }

    @Override
    public void exitingToRight() throws Exception {
    }

    @Override
    public String getID() {
        return this.getClass().getName();
    }

    @Override
    public String getInstructions() {
        return INSTRUCTIONS;
    }

    @Override
    public String getNextID() {
        return null;
    }

    @Override
    public String getTitle() {
        return TITLE;
    }

    @Override
    public boolean isInputValid() {
        return this.getSelectedFile() != null;
    }

    @Override
    public void add(InputChangedListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void remove(InputChangedListener listener) {
        this.listeners.remove(listener);
    }

    private void fireInputChanged() {
        for (InputChangedListener listener : this.listeners) {
            listener.inputChanged();
        }
    }
}

