/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.file;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.JUMPVersion;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.util.Blackboard;
import com.vividsolutions.jump.workbench.JUMPWorkbench;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.registry.Registry;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.WorkbenchFrame;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import com.vividsolutions.jump.workbench.ui.plugin.PersistentBlackboardPlugIn;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import org.openjump.core.ui.plugin.AbstractThreadedUiPlugIn;
import org.openjump.core.ui.plugin.datastore.SaveToDataStoreWizard;
import org.openjump.core.ui.plugin.datastore.transaction.DataStoreTransactionManager;
import org.openjump.core.ui.plugin.file.save.SaveToFileWizard;
import org.openjump.core.ui.swing.wizard.WizardGroup;
import org.openjump.core.ui.swing.wizard.WizardGroupDialog;

public class SaveWizardPlugIn
extends AbstractThreadedUiPlugIn {
    private static final String KEY = SaveWizardPlugIn.class.getName();
    private static final String LASTWIZARDCLASSNAME = KEY + ".lastwizard";
    public static final String DATAKEY_SIMPLIFIED_LAYERNAME = KEY + ".simplified-layername";
    public static final String DATAKEY_SELECTED_LAYERABLES = KEY + ".selected-layerables";
    private static WizardGroupDialog dialog = null;
    private WizardGroup lastWizard;
    private Blackboard blackboard;

    public SaveWizardPlugIn() {
        super(KEY + " (experimental)");
    }

    public static void addWizard(WorkbenchContext workbenchContext, WizardGroup wizard) {
        Registry registry = workbenchContext.getRegistry();
        registry.createEntry(KEY, wizard);
    }

    @Override
    public void initialize(PlugInContext context) throws Exception {
        super.initialize(context);
        JUMPWorkbench workbench = this.workbenchContext.getWorkbench();
        WorkbenchFrame frame = workbench.getFrame();
        this.blackboard = PersistentBlackboardPlugIn.get(context.getWorkbenchContext());
        SaveWizardPlugIn.addWizard(context.getWorkbenchContext(), new SaveToFileWizard(context));
        if (!JUMPVersion.getRelease().equalsIgnoreCase("release")) {
            SaveWizardPlugIn.addWizard(context.getWorkbenchContext(), new SaveToDataStoreWizard(context, (DataStoreTransactionManager)DataStoreTransactionManager.getTxInstance("org.openjump.core.ui.plugin.datastore.transaction.DataStoreTransactionManager")));
        }
    }

    @Override
    public boolean execute(PlugInContext pluginContext) throws Exception {
        Registry registry = this.workbenchContext.getRegistry();
        List wizards = registry.getEntries(KEY);
        Object lastwizard = null;
        if (dialog == null) {
            WorkbenchFrame workbenchFrame = pluginContext.getWorkbenchFrame();
            String name = this.getName();
            dialog = new WizardGroupDialog(this.workbenchContext, workbenchFrame, name);
            String lastwizardid = String.valueOf(this.blackboard.get(LASTWIZARDCLASSNAME));
            for (WizardGroup wizard : wizards) {
                dialog.addWizard(wizard);
                if (!wizard.getClass().getName().equals(lastwizardid)) continue;
                this.lastWizard = wizard;
            }
        }
        Collection<Layerable> layers = pluginContext.getSelectedLayerables();
        dialog.setData(DATAKEY_SELECTED_LAYERABLES, layers);
        Layerable layer = layers.iterator().next();
        String layerName = layer.getName().replaceAll("[/:\\\\><\\|]", "_");
        dialog.setData(DATAKEY_SIMPLIFIED_LAYERNAME, layerName);
        if (this.lastWizard != null) {
            dialog.setSelectedWizard(this.lastWizard);
        } else if (dialog.getWizardCount() > 0) {
            dialog.setSelectedWizard(dialog.getWizardAt(0));
        }
        dialog.pack();
        GUIUtil.centreOnWindow(dialog);
        dialog.setFocusable(false);
        dialog.setVisible(true);
        return dialog.wasFinishPressed();
    }

    @Override
    public void run(TaskMonitor monitor, PlugInContext context) throws Exception {
        WizardGroup wiz = dialog.getSelectedWizard();
        this.blackboard.put(LASTWIZARDCLASSNAME, wiz.getClass().getName());
        wiz.run(dialog, monitor);
    }

    @Override
    public EnableCheck getEnableCheck() {
        EnableCheckFactory checkFactory = this.getContext().getCheckFactory();
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerNamePanelMustBeActiveCheck()).add(checkFactory.createExactlyNLayersMustBeSelectedCheck(1));
    }

    @Override
    public Icon getIcon() {
        return IconLoader.icon("disk_dots.png");
    }

    @Override
    public String getName() {
        return I18N.getInstance().get("com.vividsolutions.jump.workbench.datasource.SaveDatasetAsPlugIn") + " (testing)";
    }
}

